/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.bind.Bound;
import org.kohsuke.stapler.framework.adjunct.AdjunctsInPage;
import org.kohsuke.stapler.jelly.AbstractStaplerTag;
import org.kohsuke.stapler.jelly.AdjunctTag;
import org.xml.sax.SAXException;

public class BindTag
extends AbstractStaplerTag {
    private String varName;
    private Object javaObject;

    public void setVar(String varName) {
        this.varName = varName;
    }

    public void setValue(Object o) {
        this.javaObject = o;
    }

    public void doTag(XMLOutput out) throws JellyTagException {
        this.ensureDependencies(out);
        AdjunctTag a = new AdjunctTag();
        a.setContext(this.getContext());
        a.setIncludes("org.kohsuke.stapler.bind");
        a.doTag(out);
        try {
            String expr;
            if (this.javaObject == null) {
                expr = "null";
            } else {
                Bound h = WebApp.getCurrent().boundObjectTable.bind(this.javaObject);
                expr = h.getProxyScript();
            }
            if (this.varName == null) {
                out.write(expr);
            } else {
                out.startElement("script");
                out.write(this.varName + "=" + expr + ";");
                out.endElement("script");
            }
        }
        catch (SAXException e) {
            throw new JellyTagException((Throwable)e);
        }
    }

    private void ensureDependencies(XMLOutput out) throws JellyTagException {
        AdjunctsInPage adjuncts = AdjunctsInPage.get();
        if (adjuncts.isIncluded("org.kohsuke.stapler.framework.prototype.prototype")) {
            return;
        }
        if (adjuncts.isIncluded("org.kohsuke.stapler.jquery")) {
            this.include(out, "org.kohsuke.stapler.json2");
        } else {
            this.include(out, "org.kohsuke.stapler.framework.prototype.prototype");
        }
    }

    private void include(XMLOutput out, String adjunct) throws JellyTagException {
        if (this.varName == null) {
            return;
        }
        AdjunctTag a = new AdjunctTag();
        a.setContext(this.getContext());
        a.setIncludes(adjunct);
        a.doTag(out);
    }
}

