/*
 * Decompiled with CFR 0.152.
 */
package rpc.core;

import ndr.NdrException;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import rpc.core.PresentationSyntax;

public class PresentationContext
extends NdrObject {
    public int contextId;
    public PresentationSyntax abstractSyntax;
    public PresentationSyntax[] transferSyntaxes;

    public PresentationContext() {
        this(0, new PresentationSyntax(), new PresentationSyntax[]{new PresentationSyntax("8a885d04-1ceb-11c9-9fe8-08002b104860:2.0")});
    }

    public PresentationContext(int contextId, PresentationSyntax abstractSyntax) {
        this(contextId, abstractSyntax, new PresentationSyntax[]{new PresentationSyntax("8a885d04-1ceb-11c9-9fe8-08002b104860:2.0")});
    }

    public PresentationContext(int contextId, PresentationSyntax abstractSyntax, PresentationSyntax[] transferSyntaxes) {
        this.contextId = contextId;
        this.abstractSyntax = abstractSyntax;
        this.transferSyntaxes = transferSyntaxes;
    }

    public void read(NetworkDataRepresentation ndr) {
        ndr.getBuffer().align(4);
        this.contextId = ndr.readUnsignedShort();
        int count = ndr.readUnsignedSmall();
        try {
            this.abstractSyntax.decode(ndr, ndr.getBuffer());
            this.transferSyntaxes = new PresentationSyntax[count];
            for (int i = 0; i < count; ++i) {
                this.transferSyntaxes[i] = new PresentationSyntax();
                this.transferSyntaxes[i].decode(ndr, ndr.getBuffer());
            }
        }
        catch (NdrException ndrException) {
            // empty catch block
        }
    }

    public void write(NetworkDataRepresentation ndr) {
        ndr.getBuffer().align(4, (byte)-52);
        ndr.writeUnsignedShort(this.contextId);
        ndr.writeUnsignedShort((short)this.transferSyntaxes.length);
        try {
            this.abstractSyntax.encode(ndr, ndr.getBuffer());
            for (int i = 0; i < this.transferSyntaxes.length; ++i) {
                this.transferSyntaxes[i].encode(ndr, ndr.getBuffer());
            }
        }
        catch (NdrException ndrException) {
            // empty catch block
        }
    }
}

