/*
 * Decompiled with CFR 0.152.
 */
package rpc;

import java.io.IOException;
import java.util.Properties;
import ndr.NdrObject;
import rpc.Endpoint;
import rpc.RpcException;
import rpc.TransportFactory;
import rpc.core.PresentationSyntax;
import rpc.core.UUID;

public abstract class Stub {
    private TransportFactory transportFactory;
    private Endpoint endpoint;
    private String object;
    private String address;
    private Properties properties;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        if (address == null ? this.address == null : address.equals(this.address)) {
            return;
        }
        this.address = address;
        try {
            this.detach();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public TransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    public void setTransportFactory(TransportFactory transportFactory) {
        this.transportFactory = transportFactory;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected Endpoint getEndpoint() {
        return this.endpoint;
    }

    protected void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detach() throws IOException {
        Endpoint endpoint = this.getEndpoint();
        if (endpoint == null) {
            return;
        }
        try {
            endpoint.detach();
        }
        finally {
            this.setEndpoint(null);
        }
    }

    protected void attach() throws IOException {
        Endpoint endpoint = this.getEndpoint();
        if (endpoint != null) {
            return;
        }
        String address = this.getAddress();
        if (address == null) {
            throw new RpcException("No address specified.");
        }
        this.setEndpoint(this.getTransportFactory().createTransport(address, this.getProperties()).attach(new PresentationSyntax(this.getSyntax())));
    }

    protected void call(int semantics, NdrObject ndrobj) throws IOException {
        this.attach();
        String object = this.getObject();
        UUID uuid = object == null ? null : new UUID(object);
        this.getEndpoint().call(semantics, uuid, ndrobj.getOpnum(), ndrobj);
    }

    protected abstract String getSyntax();
}

