/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import com.iwombat.foundation.IdentifierFactory;
import com.iwombat.util.GUIDUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import ndr.NdrBuffer;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.IJICOMRuntimeWorker;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComOxidDetails;
import org.jinterop.dcom.core.JIComOxidRuntime;
import org.jinterop.dcom.core.JIDualStringArray;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;
import org.jinterop.dcom.core.JIObjectId;
import org.jinterop.dcom.core.JIOxid;
import org.jinterop.dcom.core.JISetId;
import rpc.core.UUID;

class OxidResolverImpl
extends NdrObject
implements IJICOMRuntimeWorker {
    private int opnum = -1;
    private NdrBuffer buffer = null;
    private Properties p = null;
    private Random random = new Random(System.currentTimeMillis());

    public OxidResolverImpl(Properties p) {
        this.p = p;
    }

    public void setCurrentObjectID(UUID objectId) {
    }

    public void setOpnum(int opnum) {
        this.opnum = opnum;
    }

    public int getOpnum() {
        return this.opnum;
    }

    public void write(NetworkDataRepresentation ndr) {
        ndr.setBuffer(this.buffer);
    }

    public void read(NetworkDataRepresentation ndr) {
        switch (this.opnum) {
            case 1: {
                this.buffer = this.SimplePing(ndr);
                break;
            }
            case 2: {
                this.buffer = this.ComplexPing(ndr);
                break;
            }
            case 3: {
                this.buffer = this.ServerAlive(ndr);
                break;
            }
            case 5: {
                this.buffer = this.ServerAlive2(ndr);
                break;
            }
            case 4: {
                this.buffer = this.ResolveOxid2(ndr);
                break;
            }
            default: {
                if (JISystem.getLogger().isLoggable(Level.WARNING)) {
                    JISystem.getLogger().warning("Oxid Object: DEFAULTED !!!");
                }
                throw new JIRuntimeException(-1073610706);
            }
        }
    }

    private NdrBuffer SimplePing(NetworkDataRepresentation ndr) {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("Oxid Object: SimplePing");
        }
        byte[] b = JIMarshalUnMarshalHelper.readOctetArrayLE(ndr, 8);
        JIComOxidRuntime.addUpdateSets(new JISetId(b), new ArrayList(), new ArrayList());
        this.buffer = new NdrBuffer(new byte[16], 0);
        this.buffer.enc_ndr_long(0);
        this.buffer.enc_ndr_long(0);
        this.buffer.enc_ndr_long(0);
        this.buffer.enc_ndr_long(0);
        return this.buffer;
    }

    private NdrBuffer ComplexPing(NetworkDataRepresentation ndr) {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("Oxid Object: ComplexPing");
        }
        byte[] b = JIMarshalUnMarshalHelper.readOctetArrayLE(ndr, 8);
        JIMarshalUnMarshalHelper.deSerialize(ndr, Short.class, null, 0, null);
        Short lengthAdds = (Short)JIMarshalUnMarshalHelper.deSerialize(ndr, Short.class, null, 0, null);
        Short lengthDels = (Short)JIMarshalUnMarshalHelper.deSerialize(ndr, Short.class, null, 0, null);
        JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, null, 0, null);
        JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, null, 0, null);
        ArrayList<JIObjectId> listOfAdds = new ArrayList<JIObjectId>();
        for (int i = 0; i < lengthAdds.intValue(); ++i) {
            listOfAdds.add(new JIObjectId(JIMarshalUnMarshalHelper.readOctetArrayLE(ndr, 8), false));
        }
        JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, null, 0, null);
        ArrayList<JIObjectId> listOfDels = new ArrayList<JIObjectId>();
        for (int i = 0; i < lengthDels.intValue(); ++i) {
            listOfDels.add(new JIObjectId(JIMarshalUnMarshalHelper.readOctetArrayLE(ndr, 8), false));
        }
        if (Arrays.equals(b, new byte[]{0, 0, 0, 0, 0, 0, 0, 0})) {
            this.random.nextBytes(b);
        }
        JIComOxidRuntime.addUpdateSets(new JISetId(b), listOfAdds, listOfDels);
        this.buffer = new NdrBuffer(new byte[32], 0);
        NetworkDataRepresentation ndr2 = new NetworkDataRepresentation();
        ndr2.setBuffer(this.buffer);
        JIMarshalUnMarshalHelper.writeOctetArrayLE(ndr2, b);
        JIMarshalUnMarshalHelper.serialize(ndr2, Short.class, new Short(0), null, 0);
        JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, new Integer(0), null, 0);
        return this.buffer;
    }

    private NdrBuffer ServerAlive(NetworkDataRepresentation ndr) {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("Oxid Object: ServerAlive");
        }
        byte[] buffer = new byte[32];
        NdrBuffer ndrBuffer = new NdrBuffer(buffer, 0);
        ndrBuffer.enc_ndr_long(0);
        ndrBuffer.enc_ndr_long(0);
        ndrBuffer.enc_ndr_long(0);
        ndrBuffer.enc_ndr_long(0);
        return ndrBuffer;
    }

    private NdrBuffer ServerAlive2(NetworkDataRepresentation ndr) {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("Oxid Object: ServerAlive2");
        }
        JIDualStringArray dualStringArray = new JIDualStringArray(-1);
        byte[] buffer = new byte[dualStringArray.getLength() + 4 + 16 + 16];
        NdrBuffer ndrBuffer = new NdrBuffer(buffer, 0);
        NetworkDataRepresentation ndr2 = new NetworkDataRepresentation();
        ndr2.setBuffer(ndrBuffer);
        JIMarshalUnMarshalHelper.serialize(ndr2, Short.class, new Short((short)JISystem.getCOMVersion().getMajorVersion()), null, 0);
        JIMarshalUnMarshalHelper.serialize(ndr2, Short.class, new Short((short)JISystem.getCOMVersion().getMinorVersion()), null, 0);
        JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, new Integer(0), null, 0);
        JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, new Integer(dualStringArray.getLength()), null, 0);
        dualStringArray.encode(ndr2);
        JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, new Integer(0), null, 0);
        JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, new Integer(0), null, 0);
        return ndrBuffer;
    }

    private NdrBuffer ResolveOxid2(NetworkDataRepresentation ndr) {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("Oxid Object: ResolveOxid2");
        }
        JIOxid oxid = new JIOxid(JIMarshalUnMarshalHelper.readOctetArrayLE(ndr, 8));
        int length = ((Short)JIMarshalUnMarshalHelper.deSerialize(ndr, Short.class, null, 0, null)).intValue();
        JIArray array = (JIArray)JIMarshalUnMarshalHelper.deSerialize(ndr, new JIArray(Short.class, null, 1, true), null, 8, null);
        JIComOxidDetails details = JIComOxidRuntime.getOxidDetails(oxid);
        if (details == null) {
            throw new JIRuntimeException(-2147022986);
        }
        UUID uuid = details.getRemUnknownIpid() == null ? new UUID(GUIDUtil.guidStringFromHexString((String)IdentifierFactory.createUniqueIdentifier().toHexString())) : new UUID(details.getRemUnknownIpid());
        int port = -1;
        try {
            port = details.getPortForRemUnknown();
            if (port == -1) {
                String remunknownipid = uuid.toString();
                Object[] portandthread = details.getCOMRuntimeHelper().startRemUnknown(details.getIID(), remunknownipid, details.getIpid(), details.getReferent().getSupportedInterfaces());
                port = (Integer)portandthread[0];
                details.setRemUnknownThreadGroup((ThreadGroup)portandthread[1]);
                details.setRemUnknownIpid(remunknownipid);
            }
            details.setPortForRemUnknown(port);
        }
        catch (IOException e) {
            throw new JIRuntimeException(-2147418113);
        }
        JIDualStringArray dualStringArray = new JIDualStringArray(port);
        Integer authnHint = new Integer(details.getProtectionLevel());
        byte[] buffer = new byte[8 + dualStringArray.getLength() + 16 + 4 + 2 + 2 + 4 + 16];
        NdrBuffer ndrBuffer = new NdrBuffer(buffer, 0);
        NetworkDataRepresentation ndr2 = new NetworkDataRepresentation();
        ndr2.setBuffer(ndrBuffer);
        JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, new Integer(new Object().hashCode()), null, 0);
        JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, new Integer((dualStringArray.getLength() - 4) / 2), null, 0);
        dualStringArray.encode(ndr2);
        JIMarshalUnMarshalHelper.serialize(ndr2, UUID.class, uuid, null, 0);
        JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, authnHint, null, 0);
        JIMarshalUnMarshalHelper.serialize(ndr2, Short.class, new Short((short)JISystem.getCOMVersion().getMajorVersion()), null, 0);
        JIMarshalUnMarshalHelper.serialize(ndr2, Short.class, new Short((short)JISystem.getCOMVersion().getMinorVersion()), null, 0);
        JIMarshalUnMarshalHelper.serialize(ndr2, Integer.class, new Integer(0), null, 0);
        return ndrBuffer;
    }

    public List getQIedIIDs() {
        return null;
    }

    public UUID getCurrentObjectID() {
        return null;
    }

    public boolean isResolver() {
        return true;
    }

    public void setCurrentIID(String iid) {
    }

    public boolean workerOver() {
        return false;
    }
}

