/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.IJIUnsigned;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComObjectImpl;
import org.jinterop.dcom.core.JICurrency;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIStruct;
import org.jinterop.dcom.core.JIUnsignedByte;
import org.jinterop.dcom.core.JIUnsignedFactory;
import org.jinterop.dcom.core.JIUnsignedInteger;
import org.jinterop.dcom.core.JIUnsignedShort;
import org.jinterop.dcom.core.VariantBody;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public final class JIVariant
implements Serializable {
    private static final long serialVersionUID = 5101290038004040628L;
    public static final int VT_NULL = 1;
    public static final int VT_EMPTY = 0;
    public static final int VT_I4 = 3;
    public static final int VT_UI1 = 17;
    public static final int VT_I2 = 2;
    public static final int VT_R4 = 4;
    public static final int VT_R8 = 5;
    public static final int VT_VARIANT = 12;
    public static final int VT_BOOL = 11;
    public static final int VT_ERROR = 10;
    public static final int VT_CY = 6;
    public static final int VT_DATE = 7;
    public static final int VT_BSTR = 8;
    public static final int VT_UNKNOWN = 13;
    public static final int VT_DECIMAL = 14;
    public static final int VT_DISPATCH = 9;
    public static final int VT_ARRAY = 8192;
    public static final int VT_BYREF = 16384;
    public static final int VT_BYREF_VT_UI1 = 16401;
    public static final int VT_BYREF_VT_I2 = 16386;
    public static final int VT_BYREF_VT_I4 = 16387;
    public static final int VT_BYREF_VT_R4 = 16388;
    public static final int VT_BYREF_VT_R8 = 16389;
    public static final int VT_BYREF_VT_BOOL = 16395;
    public static final int VT_BYREF_VT_ERROR = 16394;
    public static final int VT_BYREF_VT_CY = 16390;
    public static final int VT_BYREF_VT_DATE = 16391;
    public static final int VT_BYREF_VT_BSTR = 16392;
    public static final int VT_BYREF_VT_UNKNOWN = 16397;
    public static final int VT_BYREF_VT_DISPATCH = 16393;
    public static final int VT_BYREF_VT_ARRAY = 24576;
    public static final int VT_BYREF_VT_VARIANT = 16396;
    public static final int VT_I1 = 16;
    public static final int VT_UI2 = 18;
    public static final int VT_UI4 = 19;
    public static final int VT_I8 = 20;
    public static final int VT_INT = 22;
    public static final int VT_UINT = 23;
    public static final int VT_BYREF_VT_DECIMAL = 16398;
    public static final int VT_BYREF_VT_I1 = 16400;
    public static final int VT_BYREF_VT_UI2 = 16402;
    public static final int VT_BYREF_VT_UI4 = 16403;
    public static final int VT_BYREF_VT_I8 = 16404;
    public static final int VT_BYREF_VT_INT = 16406;
    public static final int VT_BYREF_VT_UINT = 16407;
    public static final int FADF_AUTO = 1;
    public static final int FADF_STATIC = 2;
    public static final int FADF_EMBEDDED = 4;
    public static final int FADF_FIXEDSIZE = 16;
    public static final int FADF_RECORD = 32;
    public static final int FADF_HAVEIID = 64;
    public static final int FADF_HAVEVARTYPE = 128;
    public static final int FADF_BSTR = 256;
    public static final int FADF_UNKNOWN = 512;
    public static final int FADF_DISPATCH = 1024;
    public static final int FADF_VARIANT = 2048;
    public static final int FADF_RESERVED = 61448;
    static HashMap supportedTypes = new HashMap();
    static HashMap supportedTypes_classes = new HashMap();
    static HashMap outTypesMap = new HashMap();
    static final JIVariant EMPTY;
    static final JIVariant EMPTY_BYREF;
    static final JIVariant NULL;
    static final JIVariant OPTIONAL_PARAM;
    public static final SCODE SCODE;
    JIPointer member = null;
    private static final List arryInits;

    public static JIVariant OUTPARAMforType(Class c, boolean isArray) {
        JIVariant variant = null;
        if (!isArray) {
            try {
                variant = JIVariant.makeVariant(outTypesMap.get(c), true);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (c.equals(IJIDispatch.class)) {
                return JIVariant.OUT_IDISPATCH();
            }
            if (c.equals(IJIComObject.class)) {
                return JIVariant.OUT_IUNKNOWN();
            }
            if (c.equals(JIVariant.class)) {
                return JIVariant.EMPTY_BYREF();
            }
            if (c.equals(JIString.class)) {
                return new JIVariant("", true);
            }
        } else {
            IJIComObject[] arry;
            try {
                Object oo = outTypesMap.get(c);
                if (oo != null) {
                    Object x = Array.newInstance(c, 1);
                    Array.set(x, 0, oo);
                    variant = new JIVariant(new JIArray(x, true), true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (c.equals(IJIDispatch.class)) {
                arry = new IJIComObject[]{new JIComObjectImpl(null, new JIInterfacePointer(null, -1, null))};
                variant = new JIVariant(new JIArray(arry, true), true);
                variant.setFlag(0x180000);
            } else if (c.equals(IJIComObject.class)) {
                arry = new IJIComObject[]{new JIComObjectImpl(null, new JIInterfacePointer(null, -1, null))};
                variant = new JIVariant(new JIArray(arry, true), true);
                variant.setFlag(0x140000);
            } else {
                if (c.equals(JIVariant.class)) {
                    return JIVariant.VARIANTARRAY();
                }
                if (c.equals(JIString.class) || c.equals(String.class)) {
                    return JIVariant.BSTRARRAY();
                }
            }
        }
        return variant;
    }

    public static JIVariant makeVariant(Object o) {
        return JIVariant.makeVariant(o, false);
    }

    public static JIVariant makeVariant(Object o, boolean isByRef) {
        if (o == null || o.getClass().equals(Object.class)) {
            if (isByRef) {
                return JIVariant.EMPTY_BYREF();
            }
            return JIVariant.EMPTY();
        }
        Class<?> c = o.getClass();
        if (c.isArray()) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4137));
        }
        if (c.equals(JIVariant.class)) {
            return new JIVariant((JIVariant)o);
        }
        try {
            Constructor ctor = null;
            ctor = c.equals(Boolean.class) ? JIVariant.class.getConstructor(Boolean.TYPE, Boolean.TYPE) : (c.equals(Character.class) ? JIVariant.class.getConstructor(Character.TYPE, Boolean.TYPE) : (c.equals(Byte.class) ? JIVariant.class.getConstructor(Byte.TYPE, Boolean.TYPE) : (c.equals(Short.class) ? JIVariant.class.getConstructor(Short.TYPE, Boolean.TYPE) : (c.equals(Integer.class) ? JIVariant.class.getConstructor(Integer.TYPE, Boolean.TYPE) : (c.equals(Long.class) ? JIVariant.class.getConstructor(Long.TYPE, Boolean.TYPE) : (c.equals(Float.class) ? JIVariant.class.getConstructor(Float.TYPE, Boolean.TYPE) : (c.equals(Double.class) ? JIVariant.class.getConstructor(Double.TYPE, Boolean.TYPE) : (o instanceof IJIComObject ? JIVariant.class.getConstructor(IJIComObject.class, Boolean.TYPE) : JIVariant.class.getConstructor(c, Boolean.TYPE)))))))));
            return (JIVariant)ctor.newInstance(o, isByRef);
        }
        catch (Exception e) {
            if (JISystem.getLogger().isLoggable(Level.WARNING)) {
                JISystem.getLogger().warning("Could not create Variant for " + o + " , isByRef " + isByRef);
            }
            return null;
        }
    }

    static Class getSupportedClass(Integer type) {
        return (Class)supportedTypes_classes.get(type);
    }

    static Integer getSupportedType(Class c, int FLAG) {
        Integer retVal = (Integer)supportedTypes.get(c);
        if (retVal == null && IJIComObject.class.equals((Object)c)) {
            retVal = new Integer(13);
        }
        if (retVal == null && IJIDispatch.class.equals((Object)c)) {
            retVal = new Integer(9);
        }
        if (retVal == 3 && (FLAG & 0x800) == 2048) {
            retVal = new Integer(22);
        } else if (retVal == 19 && (FLAG & 0x1000) == 4096) {
            retVal = new Integer(23);
        }
        return retVal;
    }

    static Integer getSupportedType(Object o, int defaultType) {
        Class<?> c = o.getClass();
        Integer retval = (Integer)supportedTypes.get(c);
        if (retval == null && o instanceof IJIDispatch) {
            retval = new Integer(9);
        }
        if (retval == null && o instanceof IJIComObject) {
            retval = new Integer(13);
        }
        return retval;
    }

    public static JIVariant EMPTY() {
        return new JIVariant(new EMPTY());
    }

    public static JIVariant EMPTY_BYREF() {
        return new JIVariant(JIVariant.EMPTY());
    }

    public static JIVariant OUT_IUNKNOWN() {
        JIVariant retval = new JIVariant(new JIComObjectImpl(null, new JIInterfacePointer(null, -1, null)), true);
        retval.setFlag(0x140000);
        return retval;
    }

    public static JIVariant OUT_IDISPATCH() {
        JIVariant retval = new JIVariant(new JIComObjectImpl(null, new JIInterfacePointer(null, -1, null)), true);
        retval.setFlag(0x180000);
        return retval;
    }

    public static JIVariant NULL() {
        return new JIVariant(new NULL());
    }

    public static JIVariant OPTIONAL_PARAM() {
        return new JIVariant(SCODE, -2147352572);
    }

    public static JIVariant BSTRARRAY() {
        return new JIVariant(new JIArray(new JIString[]{new JIString("")}, true), true);
    }

    public static JIVariant VARIANTARRAY() {
        return new JIVariant(new JIArray(new JIVariant[]{JIVariant.EMPTY()}, true), true);
    }

    private JIVariant() {
    }

    private void init(Object obj) {
        this.init(obj, false);
    }

    private void init(Object obj, boolean isByRef) {
        if (obj != null && obj.getClass().isArray()) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4137));
        }
        if (obj != null && obj.getClass().equals(JIInterfacePointer.class)) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4164));
        }
        if (obj instanceof VariantBody) {
            this.member = new JIPointer(obj);
        } else {
            VariantBody variantBody = new VariantBody(obj, isByRef);
            this.member = new JIPointer(variantBody);
        }
        this.member.setReferent(1919251285);
    }

    void setDeffered(boolean deffered) {
        if (this.member != null && !this.member.isReference()) {
            this.member.setDeffered(deffered);
        }
    }

    public void setFlag(int FLAG) {
        VariantBody variantBody = (VariantBody)this.member.getReferent();
        variantBody.FLAG |= FLAG;
    }

    public int getFlag() {
        VariantBody variantBody = (VariantBody)this.member.getReferent();
        return variantBody.FLAG;
    }

    public boolean isNull() {
        if (this.member == null) {
            return true;
        }
        VariantBody variantBody = (VariantBody)this.member.getReferent();
        return variantBody == null ? true : variantBody.isNull();
    }

    public JIVariant(JIVariant variant) {
        this.init(variant, true);
    }

    public JIVariant(int value, boolean isByRef) {
        this.init(new Integer(value), isByRef);
    }

    public JIVariant(long value, boolean isByRef) {
        this.init(new Long(value), isByRef);
    }

    public JIVariant(float value, boolean isByRef) {
        this.init(new Float(value), isByRef);
    }

    public JIVariant(boolean value, boolean isByRef) {
        this.init(value, isByRef);
    }

    public JIVariant(double value, boolean isByRef) {
        this.init(new Double(value), isByRef);
    }

    public JIVariant(short value, boolean isByRef) {
        this.init(new Short(value), isByRef);
    }

    public JIVariant(char value, boolean isByRef) {
        this.init(new Character(value), isByRef);
    }

    public JIVariant(JIString value, boolean isByRef) {
        this.init(value, isByRef);
    }

    public JIVariant(String value, boolean isByRef) {
        this.init(new JIString(value), isByRef);
    }

    public JIVariant(String value) {
        this(new JIString(value));
    }

    public JIVariant(IJIComObject value, boolean isByRef) {
        this.init(value, isByRef);
        if (value instanceof IJIDispatch) {
            this.setFlag(131072);
        } else {
            this.setFlag(65536);
        }
    }

    public JIVariant(SCODE value, int errorCode, boolean isByRef) {
        this.init(new VariantBody(VariantBody.SCODE, errorCode, isByRef), isByRef);
    }

    public JIVariant(int value) {
        this(value, false);
    }

    public JIVariant(float value) {
        this(value, false);
    }

    public JIVariant(boolean value) {
        this(value, false);
    }

    public JIVariant(double value) {
        this(value, false);
    }

    public JIVariant(short value) {
        this(value, false);
    }

    public JIVariant(char value) {
        this(value, false);
    }

    public JIVariant(JIString value) {
        this(value, false);
    }

    public JIVariant(IJIComObject value) {
        this(value, false);
        if (value instanceof IJIDispatch) {
            this.setFlag(131072);
        } else {
            this.setFlag(65536);
        }
    }

    public JIVariant(Date value) {
        this(value, false);
    }

    public JIVariant(Date value, boolean isByRef) {
        this.init(value, isByRef);
    }

    public JIVariant(JICurrency value) {
        this(value, false);
    }

    public JIVariant(JICurrency value, boolean isByRef) {
        this.init(value, isByRef);
    }

    private JIVariant(EMPTY value) {
        this.init(null);
    }

    private JIVariant(NULL value) {
        this.init(new VariantBody(VariantBody.NULL));
    }

    public JIVariant(SCODE value, int errorCode) {
        this.init(new VariantBody(VariantBody.SCODE, errorCode, false));
    }

    public JIVariant(JIArray array, int FLAG) {
        this(array, false, FLAG);
    }

    public JIVariant(JIArray array, boolean isByRef, int FLAG) {
        this.initArrays(array, isByRef, FLAG);
    }

    public JIVariant(JIArray array, boolean isByRef) {
        this.initArrays(array, isByRef, 0);
    }

    private void initArrays(JIArray array, boolean isByRef, int FLAG) {
        VariantBody variant2 = null;
        JIArray array2 = null;
        Class<?> c = null;
        Object[] newArrayObj = null;
        boolean is2Dim = false;
        if (array == null) {
            this.init(null, false);
            return;
        }
        switch (array.getDimensions()) {
            case 1: {
                Object[] obj;
                newArrayObj = obj = (Object[])array.getArrayInstance();
                c = obj.getClass().getComponentType();
                break;
            }
            case 2: {
                Object[][] obj2 = (Object[][])array.getArrayInstance();
                String name = obj2.getClass().getName();
                Object subArray = obj2;
                name = name.substring(1);
                int firstDim = ((Object[])subArray).length;
                subArray = Array.get(subArray, 0);
                int secondDim = ((Object[])subArray).length;
                int k = 0;
                newArrayObj = (Object[])Array.newInstance(subArray.getClass().getComponentType(), array.getNumElementsInAllDimensions());
                for (int i = 0; i < secondDim; ++i) {
                    for (int j = 0; j < firstDim; ++j) {
                        newArrayObj[k++] = obj2[j][i];
                    }
                }
                c = subArray.getClass().getComponentType();
                is2Dim = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(JISystem.getLocalizedMessage(4135));
            }
        }
        array2 = new JIArray(newArrayObj, true);
        JIStruct safeArray = new JIStruct();
        try {
            safeArray.addMember(new Short((short)array.getDimensions()));
            int elementSize = -1;
            short flags = 128;
            if (c.equals(JIVariant.class)) {
                flags = (short)(flags | 0x800);
                elementSize = 16;
            } else if (arryInits.contains(c)) {
                if (c.equals(JIString.class)) {
                    flags = (short)(flags | 0x100);
                } else if (c.equals(IJIComObject.class)) {
                    flags = (short)(flags | 0x200);
                    FLAG |= 0x10000;
                } else if (c.equals(IJIDispatch.class)) {
                    flags = (short)(flags | 0x400);
                    FLAG |= 0x20000;
                }
                elementSize = 4;
            } else {
                elementSize = JIMarshalUnMarshalHelper.getLengthInBytes(c, null, c == Boolean.class ? 8192 : 0);
            }
            JIStruct safeArrayBound = null;
            int[] upperBounds = array.getUpperBounds();
            JIStruct[] arrayOfSafeArrayBounds = new JIStruct[array.getDimensions()];
            for (int i = 0; i < array.getDimensions(); ++i) {
                safeArrayBound = new JIStruct();
                safeArrayBound.addMember(new Integer(upperBounds[i]));
                safeArrayBound.addMember(new Integer(0));
                arrayOfSafeArrayBounds[i] = safeArrayBound;
            }
            JIArray arrayOfSafeArrayBounds2 = new JIArray(arrayOfSafeArrayBounds, true);
            safeArray.addMember(new Short(flags));
            if (elementSize > 0) {
                safeArray.addMember(new Integer(elementSize));
            } else {
                elementSize = JIMarshalUnMarshalHelper.getLengthInBytes(c, null, FLAG);
                safeArray.addMember(new Integer(elementSize));
            }
            safeArray.addMember(new Short(0));
            safeArray.addMember(new Short(JIVariant.getSupportedType(c, FLAG).shortValue()));
            if (c.equals(JIUnsignedByte.class)) {
                safeArray.addMember(JIVariant.getSupportedType(Byte.class, FLAG));
            } else if (c.equals(JIUnsignedShort.class)) {
                safeArray.addMember(JIVariant.getSupportedType(Short.class, FLAG));
            } else if (c.equals(JIUnsignedInteger.class)) {
                safeArray.addMember(JIVariant.getSupportedType(Integer.class, FLAG));
            } else if (c.equals(Boolean.class)) {
                safeArray.addMember(JIVariant.getSupportedType(Short.class, FLAG));
            } else if (c.equals(Double.class)) {
                safeArray.addMember(JIVariant.getSupportedType(Long.class, FLAG));
            } else if (c.equals(Float.class)) {
                safeArray.addMember(JIVariant.getSupportedType(Integer.class, FLAG));
            } else {
                safeArray.addMember(JIVariant.getSupportedType(c, FLAG));
            }
            safeArray.addMember(new Integer(array2.getNumElementsInAllDimensions()));
            JIPointer ptr2RealArray = new JIPointer(array2);
            safeArray.addMember(ptr2RealArray);
            safeArray.addMember(arrayOfSafeArrayBounds2);
        }
        catch (JIException e) {
            throw new JIRuntimeException(e.getErrorCode());
        }
        variant2 = new VariantBody(safeArray, c, is2Dim, isByRef, FLAG);
        this.init(variant2, false);
    }

    public JIVariant(JIArray array) {
        this(array, false);
    }

    public JIVariant(IJIUnsigned number) {
        this.init(number);
    }

    public JIVariant(IJIUnsigned number, boolean isByRef) {
        this.init(number, isByRef);
    }

    public Object getObject() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObject();
    }

    public int getObjectAsInt() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsInt();
    }

    public float getObjectAsFloat() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsFloat();
    }

    public int getObjectAsSCODE() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsSCODE();
    }

    public double getObjectAsDouble() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsDouble();
    }

    public short getObjectAsShort() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsShort();
    }

    public boolean getObjectAsBoolean() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsBoolean();
    }

    public JIString getObjectAsString() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsString();
    }

    public String getObjectAsString2() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsString().getString();
    }

    public Date getObjectAsDate() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsDate();
    }

    public char getObjectAsChar() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsChar();
    }

    public IJIComObject getObjectAsComObject() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsComObject();
    }

    public JIVariant getObjectAsVariant() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsVariant();
    }

    public JIArray getObjectAsArray() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getArray();
    }

    public long getObjectAsLong() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsLong();
    }

    public IJIUnsigned getObjectAsUnsigned() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getObjectAsUnsigned();
    }

    void encode(NetworkDataRepresentation ndr, List defferedPointers, int FLAG) {
        this.member.setDeffered(true);
        JIMarshalUnMarshalHelper.serialize(ndr, this.member.getClass(), this.member, defferedPointers, FLAG);
    }

    static JIVariant decode(NetworkDataRepresentation ndr, List defferedPointers, int FLAG, Map additionalData) {
        JIVariant variant = new JIVariant();
        JIPointer ref = new JIPointer(VariantBody.class);
        ref.setDeffered(true);
        variant.member = (JIPointer)JIMarshalUnMarshalHelper.deSerialize(ndr, ref, defferedPointers, FLAG, additionalData);
        return variant;
    }

    public boolean isArray() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).isArray();
    }

    int getLengthInBytes(int FLAG) throws JIException {
        this.checkValidity();
        return JIMarshalUnMarshalHelper.getLengthInBytes(this.member.getClass(), this.member, FLAG);
    }

    public boolean isByRefFlagSet() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).isByRef();
    }

    public int getType() throws JIException {
        this.checkValidity();
        return ((VariantBody)this.member.getReferent()).getType();
    }

    private void checkValidity() throws JIException {
        if (this.member == null || this.member.isNull()) {
            throw new JIException(4134);
        }
    }

    public String toString() {
        return this.member == null ? "[null]" : "[" + this.member.toString() + "]";
    }

    static {
        outTypesMap.put(Integer.TYPE, new Integer(0));
        outTypesMap.put(Integer.class, new Integer(0));
        outTypesMap.put(Short.TYPE, new Short(0));
        outTypesMap.put(Short.class, new Short(0));
        outTypesMap.put(Float.TYPE, new Float(0.0));
        outTypesMap.put(Float.class, new Float(0.0));
        outTypesMap.put(Double.TYPE, new Double(0.0));
        outTypesMap.put(Double.class, new Double(0.0));
        outTypesMap.put(Boolean.TYPE, Boolean.FALSE);
        outTypesMap.put(Boolean.class, Boolean.FALSE);
        outTypesMap.put(String.class, "");
        outTypesMap.put(JICurrency.class, new JICurrency("0.0"));
        outTypesMap.put(Date.class, new Date());
        outTypesMap.put(Character.TYPE, new Character('9'));
        outTypesMap.put(Character.class, new Character('9'));
        outTypesMap.put(JIUnsignedByte.class, JIUnsignedFactory.getUnsigned(new Short(0), 256));
        outTypesMap.put(JIUnsignedShort.class, JIUnsignedFactory.getUnsigned(new Integer(0), 512));
        outTypesMap.put(JIUnsignedInteger.class, JIUnsignedFactory.getUnsigned(new Long(0L), 1024));
        outTypesMap.put(Long.TYPE, new Long(0L));
        outTypesMap.put(Long.class, new Long(0L));
        supportedTypes.put(Object.class, new Integer(12));
        supportedTypes.put(JIVariant.class, new Integer(12));
        supportedTypes.put(Integer.class, new Integer(3));
        supportedTypes.put(JIUnsignedInteger.class, new Integer(19));
        supportedTypes.put(Float.class, new Integer(4));
        supportedTypes.put(Boolean.class, new Integer(11));
        supportedTypes.put(Double.class, new Integer(5));
        supportedTypes.put(Short.class, new Integer(2));
        supportedTypes.put(JIUnsignedShort.class, new Integer(18));
        supportedTypes.put(Byte.class, new Integer(16));
        supportedTypes.put(Character.class, new Integer(16));
        supportedTypes.put(JIUnsignedByte.class, new Integer(17));
        supportedTypes.put(JIString.class, new Integer(8));
        supportedTypes.put(SCODE.class, new Integer(10));
        supportedTypes.put(EMPTY.class, new Integer(0));
        supportedTypes.put(NULL.class, new Integer(1));
        supportedTypes.put(VariantBody.SCODE.class, new Integer(10));
        supportedTypes.put(VariantBody.EMPTY.class, new Integer(0));
        supportedTypes.put(VariantBody.NULL.class, new Integer(1));
        supportedTypes.put(JIArray.class, new Integer(8192));
        supportedTypes.put(Date.class, new Integer(7));
        supportedTypes.put(JICurrency.class, new Integer(6));
        supportedTypes.put(Long.class, new Integer(20));
        supportedTypes_classes.put(new Integer(7), Date.class);
        supportedTypes_classes.put(new Integer(6), JICurrency.class);
        supportedTypes_classes.put(new Integer(12), JIVariant.class);
        supportedTypes_classes.put(new Integer(3), Integer.class);
        supportedTypes_classes.put(new Integer(22), Integer.class);
        supportedTypes_classes.put(new Integer(19), JIUnsignedInteger.class);
        supportedTypes_classes.put(new Integer(23), JIUnsignedInteger.class);
        supportedTypes_classes.put(new Integer(4), Float.class);
        supportedTypes_classes.put(new Integer(11), Boolean.class);
        supportedTypes_classes.put(new Integer(5), Double.class);
        supportedTypes_classes.put(new Integer(2), Short.class);
        supportedTypes_classes.put(new Integer(18), JIUnsignedShort.class);
        supportedTypes_classes.put(new Integer(16), Character.class);
        supportedTypes_classes.put(new Integer(17), JIUnsignedByte.class);
        supportedTypes_classes.put(new Integer(8), JIString.class);
        supportedTypes_classes.put(new Integer(10), SCODE.class);
        supportedTypes_classes.put(new Integer(0), EMPTY.class);
        supportedTypes_classes.put(new Integer(1), NULL.class);
        supportedTypes_classes.put(new Integer(8192), JIArray.class);
        supportedTypes_classes.put(new Integer(13), IJIComObject.class);
        supportedTypes_classes.put(new Integer(9), IJIComObject.class);
        supportedTypes_classes.put(new Integer(20), Long.class);
        EMPTY = new JIVariant(new EMPTY());
        EMPTY_BYREF = new JIVariant(EMPTY);
        NULL = new JIVariant(new NULL());
        OPTIONAL_PARAM = new JIVariant(SCODE, -2147352572);
        SCODE = new SCODE();
        arryInits = new ArrayList();
        arryInits.add(JIString.class);
        arryInits.add(JIPointer.class);
        arryInits.add(IJIComObject.class);
        arryInits.add(IJIDispatch.class);
    }

    private static final class SCODE {
        private SCODE() {
        }
    }

    private static final class NULL {
        private NULL() {
        }
    }

    private static final class EMPTY {
        private EMPTY() {
        }
    }
}

