/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIUnion;
import org.jinterop.dcom.core.JIUnsignedInteger;
import org.jinterop.dcom.core.JIUnsignedShort;
import org.jinterop.dcom.core.JIVariant;

public final class JIStruct
implements Serializable {
    private static final long serialVersionUID = 7708214775854162549L;
    private List listOfMembers = new ArrayList();
    private List listOfMaxCounts = new ArrayList();
    private List listOfDimensions = new ArrayList();
    private boolean arrayAdded = false;
    public static final JIStruct MEMBER_IS_EMPTY = new JIStruct();

    public void addMember(Object member) throws JIException {
        this.addMember(this.listOfMembers.size(), member);
    }

    public void addMember(int position, Object member) throws JIException {
        member = member == null ? new Integer(0) : member;
        Class<?> memberClass = member.getClass();
        if (this.arrayAdded && position == this.listOfMembers.size() && !memberClass.equals(JIArray.class)) {
            throw new JIException(4123);
        }
        if (memberClass.equals(JIArray.class)) {
            if (position != this.listOfMembers.size()) {
                throw new JIException(4124);
            }
            this.arrayAdded = true;
            if (((JIArray)member).isConformant() || ((JIArray)member).isVarying()) {
                this.listOfMaxCounts.addAll(((JIArray)member).getConformantMaxCounts());
                this.listOfDimensions.add(new Integer(((JIArray)member).getDimensions()));
            }
        }
        if (memberClass.equals(JIStruct.class)) {
            if (((JIStruct)member).arrayAdded && this.arrayAdded && position != this.listOfMembers.size() - 1) {
                throw new JIException(4125);
            }
            if (this.arrayAdded && ((JIStruct)member).arrayAdded) {
                this.arrayAdded = true;
                this.listOfMaxCounts.addAll(((JIStruct)member).getArrayMaxCounts());
                ((JIStruct)member).listOfMaxCounts.clear();
                this.listOfDimensions.addAll(((JIStruct)member).listOfDimensions);
                ((JIStruct)member).listOfDimensions.clear();
            } else if (!this.arrayAdded && ((JIStruct)member).arrayAdded) {
                if (position == this.listOfMembers.size()) {
                    this.arrayAdded = true;
                    this.listOfMaxCounts.addAll(((JIStruct)member).getArrayMaxCounts());
                    ((JIStruct)member).listOfMaxCounts.clear();
                    this.listOfDimensions.addAll(((JIStruct)member).listOfDimensions);
                    ((JIStruct)member).listOfDimensions.clear();
                } else {
                    throw new JIException(4126);
                }
            }
        }
        if (memberClass.equals(JIPointer.class) && !((JIPointer)member).isReference()) {
            ((JIPointer)member).setDeffered(true);
        } else if (memberClass.equals(JIVariant.class)) {
            ((JIVariant)member).setDeffered(true);
        } else if (memberClass.equals(JIString.class)) {
            ((JIString)member).setDeffered(true);
        } else if (memberClass.equals(IJIComObject.class)) {
            ((IJIComObject)member).internal_setDeffered(true);
        }
        this.listOfMembers.add(position, member);
    }

    public void removeMember(int index) {
        Object member = this.listOfMembers.remove(index);
        if (member instanceof JIArray) {
            this.listOfMaxCounts.removeAll(((JIArray)member).getConformantMaxCounts());
        } else if (member instanceof JIStruct && ((JIStruct)member).arrayAdded) {
            this.listOfMaxCounts.removeAll(((JIStruct)member).getArrayMaxCounts());
        }
        if (this.listOfMaxCounts.size() == 0) {
            this.arrayAdded = false;
        }
    }

    public List getMembers() {
        return this.listOfMembers;
    }

    public Object getMember(int position) {
        return this.listOfMembers.get(position);
    }

    public int getSize() {
        return this.listOfMembers.size();
    }

    void encode(NetworkDataRepresentation ndr, List defferedPointers, int FLAG) {
        int i;
        for (i = 0; i < this.listOfMaxCounts.size(); ++i) {
            JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, (Integer)this.listOfMaxCounts.get(i), null, FLAG);
        }
        for (i = 0; i < this.listOfMembers.size(); ++i) {
            Object o = this.listOfMembers.get(i);
            if (o instanceof JIArray) {
                ((JIArray)o).setConformant(false);
            }
            JIMarshalUnMarshalHelper.serialize(ndr, o.getClass(), o, defferedPointers, FLAG);
            if (!(o instanceof JIArray)) continue;
            ((JIArray)o).setConformant(((JIArray)o).isConformant());
        }
    }

    JIStruct decode(NetworkDataRepresentation ndr, List defferedPointers, int FLAG, Map additionalData) {
        int j;
        int i;
        JIStruct retVal = new JIStruct();
        ArrayList<Object> listOfMaxCounts2 = new ArrayList<Object>();
        for (i = 0; i < this.listOfDimensions.size(); ++i) {
            for (j = 0; j < (Integer)this.listOfDimensions.get(i); ++j) {
                listOfMaxCounts2.add(JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, null, FLAG, additionalData));
            }
        }
        j = 0;
        for (i = 0; i < this.listOfMembers.size(); ++i) {
            Object o = this.listOfMembers.get(i);
            List maxCountTemp = null;
            if (o instanceof JIArray && (((JIArray)o).isConformant() || ((JIArray)o).isVarying())) {
                ((JIArray)o).setConformant(false);
                maxCountTemp = ((JIArray)o).getConformantMaxCounts();
                ((JIArray)o).setMaxCountAndUpperBounds(listOfMaxCounts2.subList(j, (Integer)this.listOfDimensions.get(j)));
                ++j;
            }
            Object o1 = JIMarshalUnMarshalHelper.deSerialize(ndr, o, defferedPointers, FLAG, additionalData);
            if (o instanceof JIArray && (((JIArray)o).isConformant() || ((JIArray)o).isVarying())) {
                ((JIArray)o).setConformant(((JIArray)o).isConformant());
                ((JIArray)o).setMaxCountAndUpperBounds(maxCountTemp);
            }
            try {
                retVal.addMember(o1);
                continue;
            }
            catch (JIException e) {
                throw new JIRuntimeException(e.getErrorCode());
            }
        }
        return retVal;
    }

    int getLength() {
        int length = 0;
        for (int i = 0; i < this.listOfMembers.size(); ++i) {
            Object o = this.listOfMembers.get(i);
            if (o instanceof Class) {
                length += JIMarshalUnMarshalHelper.getLengthInBytes((Class)o, o, 0);
                continue;
            }
            length += JIMarshalUnMarshalHelper.getLengthInBytes(o.getClass(), o, 0);
        }
        return length;
    }

    List getArrayMaxCounts() {
        return this.listOfMaxCounts;
    }

    int getAlignment() {
        int alignment = 0;
        for (int i = 0; i < this.listOfMembers.size(); ++i) {
            int align;
            Class c = this.listOfMembers.get(i).getClass();
            boolean isClass = false;
            if (c.equals(Class.class)) {
                isClass = true;
                c = (Class)this.listOfMembers.get(i);
            }
            if (c.equals(Integer.class) || c.equals(Float.class) || c.equals(String.class) || c.equals(JIString.class) || c.equals(JIPointer.class) || c.equals(JIUnsignedInteger.class) || c.equals(JIVariant.class)) {
                alignment = alignment <= 4 ? 4 : alignment;
            } else if (c.equals(Double.class) || c.equals(Date.class) || c.equals(Long.class)) {
                alignment = alignment <= 8 ? 8 : alignment;
            } else if (c.equals(Short.class) || c.equals(JIUnsignedShort.class)) {
                alignment = alignment <= 2 ? 2 : alignment;
            } else if (c.equals(JIStruct.class)) {
                if (!isClass) {
                    align = ((JIStruct)this.listOfMembers.get(i)).getAlignment();
                    alignment = alignment <= align ? align : alignment;
                }
            } else if (c.equals(JIUnion.class) && !isClass) {
                align = ((JIUnion)this.listOfMembers.get(i)).getAlignment();
                int n = alignment = alignment <= align ? align : alignment;
            }
            if (alignment == 8) break;
        }
        return alignment;
    }
}

