/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import java.util.logging.Level;
import ndr.NdrBuffer;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.transport.JIComEndpoint;
import rpc.Endpoint;
import rpc.ProviderException;
import rpc.RpcException;
import rpc.Transport;
import rpc.core.PresentationSyntax;

final class JIComTransport
implements Transport {
    public static final String PROTOCOL = "ncacn_ip_tcp";
    private static final String LOCALHOST;
    private Properties properties;
    private String host;
    private int port;
    private Socket socket;
    private OutputStream output;
    private InputStream input;
    private boolean attached;
    private boolean timeoutModifiedfrom0 = false;

    public JIComTransport(String address, Properties properties) throws ProviderException {
        this.properties = properties;
        this.parse(address);
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Endpoint attach(PresentationSyntax syntax) throws IOException {
        if (this.attached) {
            throw new RpcException("Transport already attached.");
        }
        try {
            if (JISystem.getLogger().isLoggable(Level.FINEST)) {
                JISystem.getLogger().finest("Opening socket on " + new InetSocketAddress(InetAddress.getByName(this.host), this.port));
            }
            SocketChannel channel = SocketChannel.open(new InetSocketAddress(InetAddress.getByName(this.host), this.port));
            this.socket = channel.socket();
            this.output = null;
            this.input = null;
            this.attached = true;
            this.socket.setKeepAlive(true);
            return new JIComEndpoint(this, syntax);
        }
        catch (IOException ex) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.socket != null) {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
                this.socket.close();
                if (JISystem.getLogger().isLoggable(Level.FINEST)) {
                    JISystem.getLogger().finest("Socket closed... " + this.socket + " host " + this.host + " , port " + this.port);
                }
            }
        }
        finally {
            this.attached = false;
            this.socket = null;
            this.output = null;
            this.input = null;
        }
    }

    public void send(NdrBuffer buffer) throws IOException {
        if (!this.attached) {
            throw new RpcException("Transport not attached.");
        }
        if (this.output == null) {
            this.output = this.socket.getOutputStream();
        }
        this.output.write(buffer.getBuffer(), 0, buffer.getLength());
        this.output.flush();
    }

    public void receive(NdrBuffer buffer) throws IOException {
        if (!this.attached) {
            throw new RpcException("Transport not attached.");
        }
        this.applySocketTimeout();
        if (this.input == null) {
            this.input = this.socket.getInputStream();
        }
        buffer.length = this.input.read(buffer.getBuffer(), 0, buffer.getCapacity());
    }

    private void applySocketTimeout() {
        int timeout = 0;
        try {
            timeout = Integer.parseInt(this.properties.getProperty("rpc.socketTimeout", "0"));
            if (timeout != 0) {
                this.socket.setSoTimeout(timeout);
                this.timeoutModifiedfrom0 = true;
            } else if (this.timeoutModifiedfrom0) {
                this.socket.setSoTimeout(timeout);
                this.timeoutModifiedfrom0 = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void parse(String address) throws ProviderException {
        if (address == null) {
            throw new ProviderException("Null address.");
        }
        if (!address.startsWith("ncacn_ip_tcp:")) {
            throw new ProviderException("Not an ncacn_ip_tcp address.");
        }
        int index = (address = address.substring(13)).indexOf(91);
        if (index == -1) {
            throw new ProviderException("No port specifier present.");
        }
        String server = address.substring(0, index);
        if ((index = (address = address.substring(index + 1)).indexOf(93)) == -1) {
            throw new ProviderException("Port specifier not terminated.");
        }
        address = address.substring(0, index);
        if ("".equals(server)) {
            server = LOCALHOST;
        }
        try {
            this.port = Integer.parseInt(address);
        }
        catch (Exception ex) {
            throw new ProviderException("Invalid port specifier.");
        }
        this.host = server;
    }

    static {
        String localhost = null;
        try {
            localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        LOCALHOST = localhost;
    }
}

