/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHProject;
import org.kohsuke.github.GHProjectColumn;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.Requester;

public class GHProjectCard
extends GHObject {
    private boolean archived;
    private GHProjectColumn column;
    private String contentUrl;
    private String projectUrl;
    private String columnUrl;
    private GHUser creator;
    private String note;
    private GHProject project;

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHProjectColumn getColumn() throws IOException {
        if (this.column == null) {
            try {
                this.column = ((Requester)this.root().createRequest().withUrlPath(this.getColumnUrl().getPath(), new String[0])).fetch(GHProjectColumn.class).lateBind(this.root());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return this.column;
    }

    public URL getColumnUrl() {
        return GitHubClient.parseURL(this.columnUrl);
    }

    public GHIssue getContent() throws IOException {
        if (StringUtils.isEmpty((CharSequence)this.contentUrl)) {
            return null;
        }
        try {
            if (this.contentUrl.contains("/pulls")) {
                return ((Requester)this.root().createRequest().withUrlPath(this.getContentUrl().getPath(), new String[0])).fetch(GHPullRequest.class);
            }
            return ((Requester)this.root().createRequest().withUrlPath(this.getContentUrl().getPath(), new String[0])).fetch(GHIssue.class);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public URL getContentUrl() {
        return GitHubClient.parseURL(this.contentUrl);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHUser getCreator() {
        return this.creator;
    }

    public URL getHtmlUrl() {
        return null;
    }

    public String getNote() {
        return this.note;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHProject getProject() throws IOException {
        if (this.project == null) {
            try {
                this.project = ((Requester)this.root().createRequest().withUrlPath(this.getProjectUrl().getPath(), new String[0])).fetch(GHProject.class);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return this.project;
    }

    public URL getProjectUrl() {
        return GitHubClient.parseURL(this.projectUrl);
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) throws IOException {
        this.edit("archived", archived);
    }

    public void setNote(String note) throws IOException {
        this.edit("note", note);
    }

    private void edit(String key, Object value) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("PATCH")).with(key, value)).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    protected String getApiRoute() {
        return String.format("/projects/columns/cards/%d", this.getId());
    }

    GHProjectCard lateBind(GHProjectColumn column) {
        this.column = column;
        this.project = column.project;
        return this.lateBind(column.root());
    }

    GHProjectCard lateBind(GitHub root) {
        return this;
    }
}

