/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.kohsuke.github.GHThread;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.GitHubPageContentsIterable;
import org.kohsuke.github.GitHubResponse;
import org.kohsuke.github.Requester;

public class GHNotificationStream
extends GitHubInteractiveObject
implements Iterable<GHThread> {
    private static final GHThread[] EMPTY_ARRAY = new GHThread[0];
    private Boolean all;
    private Boolean participating;
    private String apiUrl;
    private boolean nonBlocking = false;
    private String since;

    GHNotificationStream(GitHub root, String apiUrl) {
        super(root);
        this.apiUrl = apiUrl;
    }

    @Override
    public Iterator<GHThread> iterator() {
        final Requester req = (Requester)((Requester)((Requester)this.root().createRequest().with("all", this.all)).with("participating", this.participating)).with("since", this.since);
        return new Iterator<GHThread>(){
            private int idx = -1;
            private String lastModified;
            private long lastUpdated = -1L;
            private GHThread next;
            private long nextCheckTime = -1L;
            private GHThread[] threads = EMPTY_ARRAY;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.next = this.fetch();
                }
                return this.next != null;
            }

            @Override
            public GHThread next() {
                if (this.next == null) {
                    this.next = this.fetch();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                GHThread r = this.next;
                this.next = null;
                return r;
            }

            private long calcNextCheckTime(GitHubResponse<GHThread[]> response) {
                String v = response.header("X-Poll-Interval");
                if (v == null) {
                    v = "60";
                }
                long seconds = Integer.parseInt(v);
                return System.currentTimeMillis() + seconds * 1000L;
            }

            GHThread fetch() {
                try {
                    while (true) {
                        long now;
                        if (this.idx >= 0) {
                            GHThread n;
                            long nt;
                            if ((nt = (n = this.threads[this.idx--]).getUpdatedAt().toEpochMilli()) < this.lastUpdated) continue;
                            this.lastUpdated = nt;
                            return n;
                        }
                        if (GHNotificationStream.this.nonBlocking && this.nextCheckTime >= 0L) {
                            return null;
                        }
                        while (this.nextCheckTime >= (now = System.currentTimeMillis())) {
                            long waitTime = Math.min(Math.max(this.nextCheckTime - now, 1000L), 60000L);
                            Thread.sleep(waitTime);
                        }
                        if (this.lastModified != null) {
                            req.setHeader("If-Modified-Since", this.lastModified);
                        }
                        Requester requester = (Requester)req.withUrlPath(GHNotificationStream.this.apiUrl, new String[0]);
                        GitHubResponse<T[]> response = ((GitHubPageContentsIterable)requester.toIterable(GHThread[].class, null)).toResponse();
                        this.threads = (GHThread[])response.body();
                        if (this.threads == null) {
                            this.threads = EMPTY_ARRAY;
                        } else {
                            ++this.lastUpdated;
                        }
                        this.idx = this.threads.length - 1;
                        this.nextCheckTime = this.calcNextCheckTime(response);
                        this.lastModified = response.header("Last-Modified");
                    }
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void markAsRead() throws IOException {
        this.markAsRead(-1L);
    }

    public void markAsRead(long timestamp) throws IOException {
        Requester req = this.root().createRequest();
        if (timestamp >= 0L) {
            req.with("last_read_at", GitHubClient.printInstant(Instant.ofEpochMilli(timestamp)));
        }
        ((Requester)req.withUrlPath(this.apiUrl, new String[0])).fetchHttpStatusCode();
    }

    public GHNotificationStream nonBlocking(boolean v) {
        this.nonBlocking = v;
        return this;
    }

    public GHNotificationStream participating(boolean v) {
        this.participating = v;
        return this;
    }

    public GHNotificationStream read(boolean v) {
        this.all = v;
        return this;
    }

    @Deprecated
    public GHNotificationStream since(Date dt) {
        return this.since(GitHubClient.toInstantOrNull(dt));
    }

    public GHNotificationStream since(Instant dt) {
        this.since = GitHubClient.printInstant(dt);
        return this;
    }

    public GHNotificationStream since(long timestamp) {
        return this.since(new Date(timestamp));
    }
}

