/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.Requester;

public class GHCommitBuilder {
    private final List<String> parents = new ArrayList<String>();
    private final GHRepository repo;
    private final Requester req;

    GHCommitBuilder(GHRepository repo) {
        this.repo = repo;
        this.req = (Requester)repo.root().createRequest().method("POST");
    }

    @Deprecated
    public GHCommitBuilder author(String name, String email, Date date) {
        return this.author(name, email, GitHubClient.toInstantOrNull(date));
    }

    public GHCommitBuilder author(String name, String email, Instant date) {
        this.req.with("author", new UserInfo(name, email, date));
        return this;
    }

    @Deprecated
    public GHCommitBuilder committer(String name, String email, Date date) {
        return this.committer(name, email, GitHubClient.toInstantOrNull(date));
    }

    public GHCommitBuilder committer(String name, String email, Instant date) {
        this.req.with("committer", new UserInfo(name, email, date));
        return this;
    }

    public GHCommit create() throws IOException {
        this.req.with("parents", this.parents);
        return ((Requester)((Requester)this.req.method("POST")).withUrlPath(this.getApiTail(), new String[0])).fetch(GHCommit.class).wrapUp(this.repo);
    }

    public GHCommitBuilder message(String message) {
        this.req.with("message", message);
        return this;
    }

    public GHCommitBuilder parent(String parent) {
        this.parents.add(parent);
        return this;
    }

    public GHCommitBuilder tree(String tree) {
        this.req.with("tree", tree);
        return this;
    }

    public GHCommitBuilder withSignature(String signature) {
        this.req.with("signature", signature);
        return this;
    }

    private String getApiTail() {
        return String.format("/repos/%s/%s/git/commits", this.repo.getOwnerName(), this.repo.getName());
    }

    private static final class UserInfo {
        private final String date;
        private final String email;
        private final String name;

        private UserInfo(String name, String email, Instant date) {
            this.name = name;
            this.email = email;
            this.date = GitHubClient.printInstant(date);
        }
    }
}

