/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kohsuke.github.BetaApi;
import org.kohsuke.github.GHAppInstallationToken;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.Requester;

public class GHAppCreateTokenBuilder
extends GitHubInteractiveObject {
    private final String apiUrlTail;
    protected final Requester builder;

    @BetaApi
    GHAppCreateTokenBuilder(GitHub root, String apiUrlTail) {
        super(root);
        this.apiUrlTail = apiUrlTail;
        this.builder = root.createRequest();
    }

    public GHAppInstallationToken create() throws IOException {
        return ((Requester)((Requester)this.builder.method("POST")).withUrlPath(this.apiUrlTail, new String[0])).fetch(GHAppInstallationToken.class);
    }

    @BetaApi
    public GHAppCreateTokenBuilder permissions(Map<String, GHPermissionType> permissions) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (Map.Entry<String, GHPermissionType> entry : permissions.entrySet()) {
            retMap.put(entry.getKey(), GitHubRequest.transformEnum(entry.getValue()));
        }
        this.builder.with("permissions", retMap);
        return this;
    }

    @BetaApi
    public GHAppCreateTokenBuilder repositories(List<String> repositories) {
        this.builder.with("repositories", repositories);
        return this;
    }

    @BetaApi
    public GHAppCreateTokenBuilder repositoryIds(List<Long> repositoryIds) {
        this.builder.with("repository_ids", repositoryIds);
        return this;
    }
}

