/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.authorization;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.kohsuke.github.BetaApi;
import org.kohsuke.github.GHApp;
import org.kohsuke.github.GHAppInstallation;
import org.kohsuke.github.GHAppInstallationToken;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.authorization.AuthorizationProvider;

public class AppInstallationAuthorizationProvider
extends GitHub.DependentAuthorizationProvider {
    private final AppInstallationProvider appInstallationProvider;
    private String authorization;
    @Nonnull
    private Instant validUntil = Instant.MIN;

    @BetaApi
    public AppInstallationAuthorizationProvider(AppInstallationProvider appInstallationProvider, AuthorizationProvider authorizationProvider) {
        super(authorizationProvider);
        this.appInstallationProvider = appInstallationProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEncodedAuthorization() throws IOException {
        AppInstallationAuthorizationProvider appInstallationAuthorizationProvider = this;
        synchronized (appInstallationAuthorizationProvider) {
            if (this.authorization == null || Instant.now().isAfter(this.validUntil)) {
                String token = this.refreshToken();
                this.authorization = String.format("token %s", token);
            }
            return this.authorization;
        }
    }

    private String refreshToken() throws IOException {
        GitHub gitHub = this.gitHub();
        GHAppInstallation installationByOrganization = this.appInstallationProvider.getAppInstallation(gitHub.getApp());
        GHAppInstallationToken ghAppInstallationToken = installationByOrganization.createToken().create();
        this.validUntil = ghAppInstallationToken.getExpiresAt().toInstant().minus(Duration.ofMinutes(5L));
        return Objects.requireNonNull(ghAppInstallationToken.getToken());
    }

    @FunctionalInterface
    public static interface AppInstallationProvider {
        public GHAppInstallation getAppInstallation(GHApp var1) throws IOException;
    }
}

