/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.List;
import org.kohsuke.github.GHDeployment;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.Previews;

public class GHDeploymentBuilder {
    private final GHRepository repo;
    private final Requester builder;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Acceptable")
    public GHDeploymentBuilder(GHRepository repo) {
        this.repo = repo;
        this.builder = (Requester)((Requester)((Requester)repo.root().createRequest().withPreview(Previews.ANT_MAN)).withPreview(Previews.FLASH)).method("POST");
    }

    public GHDeploymentBuilder(GHRepository repo, String ref) {
        this(repo);
        this.ref(ref);
    }

    public GHDeploymentBuilder ref(String branch) {
        this.builder.with("ref", branch);
        return this;
    }

    public GHDeploymentBuilder task(String task) {
        this.builder.with("task", task);
        return this;
    }

    public GHDeploymentBuilder autoMerge(boolean autoMerge) {
        this.builder.with("auto_merge", autoMerge);
        return this;
    }

    public GHDeploymentBuilder requiredContexts(List<String> requiredContexts) {
        this.builder.with("required_contexts", requiredContexts);
        return this;
    }

    public GHDeploymentBuilder payload(String payload) {
        this.builder.with("payload", payload);
        return this;
    }

    public GHDeploymentBuilder environment(String environment) {
        this.builder.with("environment", environment);
        return this;
    }

    @Preview(value={Previews.ANT_MAN})
    public GHDeploymentBuilder transientEnvironment(boolean transientEnvironment) {
        this.builder.with("transient_environment", transientEnvironment);
        return this;
    }

    @Preview(value={Previews.ANT_MAN})
    public GHDeploymentBuilder productionEnvironment(boolean productionEnvironment) {
        this.builder.with("production_environment", productionEnvironment);
        return this;
    }

    public GHDeploymentBuilder description(String description) {
        this.builder.with("description", description);
        return this;
    }

    public GHDeployment create() throws IOException {
        return ((Requester)this.builder.withUrlPath(this.repo.getApiTailUrl("deployments"), new String[0])).fetch(GHDeployment.class).wrap(this.repo);
    }
}

