/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.Requester;

public class GHWorkflow
extends GHObject {
    @JsonIgnore
    private GHRepository owner;
    private String name;
    private String path;
    private String state;
    private String htmlUrl;
    private String badgeUrl;

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getState() {
        return this.state;
    }

    @Override
    public URL getHtmlUrl() throws IOException {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public GHRepository getRepository() {
        return this.owner;
    }

    public URL getBadgeUrl() {
        return GitHubClient.parseURL(this.badgeUrl);
    }

    public void disable() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("PUT")).withUrlPath(this.getApiRoute(), "disable")).fetchHttpStatusCode();
    }

    public void enable() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("PUT")).withUrlPath(this.getApiRoute(), "enable")).fetchHttpStatusCode();
    }

    public void dispatch(String ref) throws IOException {
        this.dispatch(ref, Collections.emptyMap());
    }

    public void dispatch(String ref, Map<String, Object> inputs) throws IOException {
        Requester requester = (Requester)((Requester)((Requester)this.root.createRequest().method("POST")).withUrlPath(this.getApiRoute(), "dispatches")).with("ref", ref);
        if (!inputs.isEmpty()) {
            requester.with("inputs", inputs);
        }
        requester.fetchHttpStatusCode();
    }

    private String getApiRoute() {
        if (this.owner == null) {
            URL url = Objects.requireNonNull(this.getUrl(), "Missing instance URL!");
            return StringUtils.prependIfMissing((String)url.toString().replace(this.root.getApiUrl(), ""), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/actions/workflows/" + this.getId();
    }

    GHWorkflow wrapUp(GHRepository owner) {
        this.owner = owner;
        return this.wrapUp(owner.root);
    }

    GHWorkflow wrapUp(GitHub root) {
        this.root = root;
        if (this.owner != null) {
            this.owner.wrap(root);
        }
        return this;
    }
}

