/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.kohsuke.github.EnforcementLevel;
import org.kohsuke.github.GHBranchProtection;
import org.kohsuke.github.GHBranchProtectionBuilder;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.Previews;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
public class GHBranch
extends GitHubInteractiveObject {
    private GHRepository owner;
    private String name;
    private Commit commit;
    @JsonProperty(value="protected")
    private boolean protection;
    private String protection_url;

    @JsonCreator
    GHBranch(@JsonProperty(value="name", required=true) String name) throws Exception {
        Objects.requireNonNull(name);
        this.name = name;
    }

    @Override
    public GitHub getRoot() {
        return this.root;
    }

    public GHRepository getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    @Preview(value={Previews.LUKE_CAGE})
    public boolean isProtected() {
        return this.protection;
    }

    @Preview(value={Previews.LUKE_CAGE})
    public URL getProtectionUrl() {
        return GitHubClient.parseURL(this.protection_url);
    }

    @Preview(value={Previews.LUKE_CAGE})
    public GHBranchProtection getProtection() throws IOException {
        return ((Requester)((Requester)this.root.createRequest().withPreview(Previews.LUKE_CAGE)).setRawUrlPath(this.protection_url)).fetch(GHBranchProtection.class).wrap(this);
    }

    public String getSHA1() {
        return this.commit.sha;
    }

    public void disableProtection() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("DELETE")).setRawUrlPath(this.protection_url)).send();
    }

    @Preview(value={Previews.LUKE_CAGE})
    public GHBranchProtectionBuilder enableProtection() {
        return new GHBranchProtectionBuilder(this);
    }

    @Deprecated
    public void enableProtection(EnforcementLevel level, Collection<String> contexts) throws IOException {
        switch (level) {
            case OFF: {
                this.disableProtection();
                break;
            }
            case NON_ADMINS: 
            case EVERYONE: {
                this.enableProtection().addRequiredChecks(contexts).includeAdmins(level == EnforcementLevel.EVERYONE).enable();
            }
        }
    }

    @CheckForNull
    public GHCommit merge(GHBranch headBranch, String commitMessage) throws IOException {
        return this.merge(headBranch.getName(), commitMessage);
    }

    @CheckForNull
    public GHCommit merge(String head, String commitMessage) throws IOException {
        GHCommit result = ((Requester)((Requester)((Requester)((Requester)((Requester)this.root.createRequest().withUrlPath(this.owner.getApiTailUrl("merges"), new String[0])).method("POST")).with("commit_message", commitMessage)).with("base", this.name)).with("head", head)).fetch(GHCommit.class);
        if (result != null) {
            result.wrapUp(this.owner);
        }
        return result;
    }

    String getApiRoute() {
        return this.owner.getApiTailUrl("/branches/" + this.name);
    }

    public String toString() {
        String url = this.owner != null ? this.owner.getUrl().toString() : "unknown";
        return "Branch:" + this.name + " in " + url;
    }

    GHBranch wrap(GHRepository repo) {
        this.owner = repo;
        this.root = repo.root;
        return this;
    }

    public static class Commit {
        String sha;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String url;
    }
}

