/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubPageIterator;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

public abstract class GHPerson
extends GHObject {
    protected String login;
    protected String avatar_url;
    protected String location;
    protected String blog;
    protected String email;
    protected String bio;
    protected String name;
    protected String company;
    protected String type;
    protected String twitter_username;
    protected String html_url;
    protected int followers;
    protected int following;
    protected int public_repos;
    protected int public_gists;
    protected boolean site_admin;
    protected boolean hireable;
    protected Integer total_private_repos;

    GHPerson wrapUp(GitHub root) {
        this.root = root;
        return this;
    }

    protected synchronized void populate() throws IOException {
        if (super.getCreatedAt() != null) {
            return;
        }
        if (this.root == null || this.root.isOffline()) {
            return;
        }
        URL url = this.getUrl();
        if (url != null) {
            ((Requester)this.root.createRequest().setRawUrlPath(url.toString())).fetchInto(this);
        }
    }

    public synchronized Map<String, GHRepository> getRepositories() throws IOException {
        TreeMap<String, GHRepository> repositories = new TreeMap<String, GHRepository>();
        for (GHRepository r : this.listRepositories(100)) {
            repositories.put(r.getName(), r);
        }
        return Collections.unmodifiableMap(repositories);
    }

    public PagedIterable<GHRepository> listRepositories() {
        return this.listRepositories(30);
    }

    public PagedIterable<GHRepository> listRepositories(int pageSize) {
        return ((Requester)this.root.createRequest().withUrlPath("/users/" + this.login + "/repos", new String[0])).toIterable(GHRepository[].class, item -> item.wrap(this.root)).withPageSize(pageSize);
    }

    @Deprecated
    public synchronized Iterable<List<GHRepository>> iterateRepositories(int pageSize) {
        return () -> {
            PagedIterator<GHRepository> pager;
            try {
                GitHubPageIterator<GHRepository[]> iterator = GitHubPageIterator.create(this.root.getClient(), GHRepository[].class, ((Requester)this.root.createRequest().withUrlPath("users", this.login, "repos")).build(), pageSize);
                pager = new PagedIterator<GHRepository>(iterator, item -> item.wrap(this.root));
            }
            catch (MalformedURLException e) {
                throw new GHException("Unable to build GitHub API URL", e);
            }
            return new Iterator<List<GHRepository>>(){

                @Override
                public boolean hasNext() {
                    return pager.hasNext();
                }

                @Override
                public List<GHRepository> next() {
                    return pager.nextPage();
                }
            };
        };
    }

    public GHRepository getRepository(String name) throws IOException {
        try {
            return GHRepository.read(this.root, this.login, name);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public abstract PagedIterable<GHEventInfo> listEvents() throws IOException;

    @Deprecated
    public String getGravatarId() {
        return "";
    }

    public String getAvatarUrl() {
        return this.avatar_url;
    }

    public String getLogin() {
        return this.login;
    }

    public String getName() throws IOException {
        this.populate();
        return this.name;
    }

    public String getCompany() throws IOException {
        this.populate();
        return this.company;
    }

    public String getLocation() throws IOException {
        this.populate();
        return this.location;
    }

    public String getTwitterUsername() throws IOException {
        this.populate();
        return this.twitter_username;
    }

    @Override
    public Date getCreatedAt() throws IOException {
        this.populate();
        return super.getCreatedAt();
    }

    @Override
    public Date getUpdatedAt() throws IOException {
        this.populate();
        return super.getUpdatedAt();
    }

    public String getBlog() throws IOException {
        this.populate();
        return this.blog;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public String getEmail() throws IOException {
        this.populate();
        return this.email;
    }

    public int getPublicGistCount() throws IOException {
        this.populate();
        return this.public_gists;
    }

    public int getPublicRepoCount() throws IOException {
        this.populate();
        return this.public_repos;
    }

    public int getFollowingCount() throws IOException {
        this.populate();
        return this.following;
    }

    public int getFollowersCount() throws IOException {
        this.populate();
        return this.followers;
    }

    public String getType() throws IOException {
        this.populate();
        return this.type;
    }

    public boolean isSiteAdmin() throws IOException {
        this.populate();
        return this.site_admin;
    }

    public Optional<Integer> getTotalPrivateRepoCount() throws IOException {
        this.populate();
        return Optional.ofNullable(this.total_private_repos);
    }
}

