/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.kucoin.KucoinAdapters;
import org.knowm.xchange.kucoin.KucoinExchange;
import org.knowm.xchange.kucoin.KucoinMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.marketdata.params.Params;

public class KucoinMarketDataService
extends KucoinMarketDataServiceRaw
implements MarketDataService {
    public static final String PARAM_FULL_ORDERBOOK = "Full_Orderbook";

    KucoinMarketDataService(KucoinExchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        return KucoinAdapters.adaptTickerFull(currencyPair, this.getKucoin24hrStats(currencyPair)).build();
    }

    public List<Ticker> getTickers(Params params) throws IOException {
        return KucoinAdapters.adaptAllTickers(this.getKucoinTickers());
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        if (Arrays.asList(args).contains(PARAM_FULL_ORDERBOOK)) {
            return KucoinAdapters.adaptOrderBook(currencyPair, this.getKucoinOrderBookFull(currencyPair));
        }
        return KucoinAdapters.adaptOrderBook(currencyPair, this.getKucoinOrderBookPartial(currencyPair));
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        return KucoinAdapters.adaptTrades(currencyPair, this.getKucoinTrades(currencyPair));
    }
}

