/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import com.google.common.base.Strings;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.kucoin.KucoinExchange;
import org.knowm.xchange.kucoin.service.AccountAPI;
import org.knowm.xchange.kucoin.service.DepositAPI;
import org.knowm.xchange.kucoin.service.FillAPI;
import org.knowm.xchange.kucoin.service.HistOrdersAPI;
import org.knowm.xchange.kucoin.service.HistoryAPI;
import org.knowm.xchange.kucoin.service.KucoinApiException;
import org.knowm.xchange.kucoin.service.KucoinDigest;
import org.knowm.xchange.kucoin.service.OrderAPI;
import org.knowm.xchange.kucoin.service.OrderBookAPI;
import org.knowm.xchange.kucoin.service.SymbolAPI;
import org.knowm.xchange.kucoin.service.WebsocketAPI;
import org.knowm.xchange.kucoin.service.WithdrawalAPI;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import si.mazi.rescu.SynchronizedValueFactory;

public class KucoinBaseService
extends BaseExchangeService<KucoinExchange>
implements BaseService {
    protected final SymbolAPI symbolApi;
    protected final OrderBookAPI orderBookApi;
    protected final HistoryAPI historyApi;
    protected final AccountAPI accountApi;
    protected final WithdrawalAPI withdrawalAPI;
    protected final DepositAPI depositAPI;
    protected final OrderAPI orderApi;
    protected final FillAPI fillApi;
    protected final HistOrdersAPI histOrdersApi;
    protected final WebsocketAPI websocketAPI;
    protected KucoinDigest digest;
    protected String apiKey;
    protected String passphrase;
    protected SynchronizedValueFactory<Long> nonceFactory;

    protected KucoinBaseService(KucoinExchange exchange) {
        super((Exchange)exchange);
        this.symbolApi = this.service(exchange, SymbolAPI.class);
        this.orderBookApi = this.service(exchange, OrderBookAPI.class);
        this.historyApi = this.service(exchange, HistoryAPI.class);
        this.accountApi = this.service(exchange, AccountAPI.class);
        this.withdrawalAPI = this.service(exchange, WithdrawalAPI.class);
        this.depositAPI = this.service(exchange, DepositAPI.class);
        this.orderApi = this.service(exchange, OrderAPI.class);
        this.fillApi = this.service(exchange, FillAPI.class);
        this.histOrdersApi = this.service(exchange, HistOrdersAPI.class);
        this.websocketAPI = this.service(exchange, WebsocketAPI.class);
        this.digest = KucoinDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
        this.apiKey = exchange.getExchangeSpecification().getApiKey();
        this.passphrase = (String)exchange.getExchangeSpecification().getExchangeSpecificParametersItem("passphrase");
        this.nonceFactory = exchange.getNonceFactory();
    }

    private <T> T service(KucoinExchange exchange, Class<T> clazz) {
        return (T)ExchangeRestProxyBuilder.forInterface(clazz, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
    }

    protected void checkAuthenticated() {
        if (Strings.isNullOrEmpty((String)this.apiKey)) {
            throw new KucoinApiException("Missing API key");
        }
        if (this.digest == null) {
            throw new KucoinApiException("Missing secret key");
        }
        if (Strings.isNullOrEmpty((String)this.passphrase)) {
            throw new KucoinApiException("Missing passphrase");
        }
    }
}

