/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.account.futures.BinanceFutureAccountInformation;
import org.knowm.xchange.binance.dto.account.futures.BinancePosition;
import org.knowm.xchange.binance.dto.trade.BinanceCancelledOrder;
import org.knowm.xchange.binance.dto.trade.BinanceDustLog;
import org.knowm.xchange.binance.dto.trade.BinanceListenKey;
import org.knowm.xchange.binance.dto.trade.BinanceNewOrder;
import org.knowm.xchange.binance.dto.trade.BinanceOrder;
import org.knowm.xchange.binance.dto.trade.BinanceTrade;
import org.knowm.xchange.binance.dto.trade.OrderSide;
import org.knowm.xchange.binance.dto.trade.OrderType;
import org.knowm.xchange.binance.dto.trade.TimeInForce;
import org.knowm.xchange.binance.dto.trade.futures.BinanceChangeStatus;
import org.knowm.xchange.binance.dto.trade.futures.BinanceFutureNewOrder;
import org.knowm.xchange.binance.service.BinanceBaseService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.derivative.FuturesContract;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.instrument.Instrument;

public class BinanceTradeServiceRaw
extends BinanceBaseService {
    protected BinanceTradeServiceRaw(BinanceExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public List<BinanceOrder> openOrdersAllProducts() throws BinanceException, IOException {
        switch (((BinanceExchange)this.exchange).getExchangeSpecification().getExchangeSpecificParametersItem(BinanceExchange.EXCHANGE_TYPE).toString()) {
            case "FUTURES": {
                return (List)this.decorateApiCall(() -> this.binanceFutures.futureOpenOrders(null, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("openOrders")).withRateLimiter(this.rateLimiter("requestWeight"), this.openOrdersPermits(null)).call();
            }
            case "INVERSE": {
                return (List)this.decorateApiCall(() -> this.inverseBinanceFutures.futureOpenInverseOrders(null, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("openOrders")).withRateLimiter(this.rateLimiter("requestWeight"), this.openOrdersPermits(null)).call();
            }
            case "PORTFOLIO_MARGIN": {
                return (List)this.decorateApiCall(() -> this.binanceFutures.futureOpenPortfolioMarginOrders(null, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("openOrders")).withRateLimiter(this.rateLimiter("requestWeight"), this.openOrdersPermits(null)).call();
            }
        }
        return (List)this.decorateApiCall(() -> this.binance.openOrders(null, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("openOrders")).withRateLimiter(this.rateLimiter("requestWeight"), this.openOrdersPermits(null)).call();
    }

    public List<BinanceOrder> openOrdersAllProducts(Instrument pair) throws BinanceException, IOException {
        if (((BinanceExchange)this.exchange).isPortfolioMarginEnabled()) {
            return (List)this.decorateApiCall(() -> pair instanceof FuturesContract ? (BinanceAdapters.isInverse(pair).booleanValue() ? this.binanceFutures.futureOpenPortfolioMarginInverseOrders(Optional.of(pair).map(BinanceAdapters::toInverseSymbol).orElse(null), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binanceFutures.futureOpenPortfolioMarginOrders(Optional.of(pair).map(BinanceAdapters::toSymbol).orElse(null), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)) : this.binance.openOrders(Optional.ofNullable(pair).map(BinanceAdapters::toSymbol).orElse(null), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("openOrders")).withRateLimiter(this.rateLimiter("requestWeight"), this.openOrdersPermits(pair)).call();
        }
        return (List)this.decorateApiCall(() -> pair instanceof FuturesContract ? (BinanceAdapters.isInverse(pair).booleanValue() ? this.inverseBinanceFutures.futureOpenInverseOrders(Optional.of(pair).map(BinanceAdapters::toInverseSymbol).orElse(null), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binanceFutures.futureOpenOrders(Optional.of(pair).map(BinanceAdapters::toSymbol).orElse(null), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)) : this.binance.openOrders(Optional.ofNullable(pair).map(BinanceAdapters::toSymbol).orElse(null), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("openOrders")).withRateLimiter(this.rateLimiter("requestWeight"), this.openOrdersPermits(pair)).call();
    }

    public BinanceNewOrder newOrder(Instrument pair, OrderSide side, OrderType type, TimeInForce timeInForce, BigDecimal quantity, BigDecimal quoteOrderQty, BigDecimal price, String newClientOrderId, BigDecimal stopPrice, Long trailingDelta, BigDecimal icebergQty, BinanceNewOrder.NewOrderResponseType newOrderRespType) throws IOException, BinanceException {
        return (BinanceNewOrder)this.decorateApiCall(() -> this.binance.newOrder(BinanceAdapters.toSymbol(pair), side, type, timeInForce, quantity, quoteOrderQty, price, newClientOrderId, stopPrice, trailingDelta, icebergQty, newOrderRespType, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("newOrder", "nonIdempotentCallsBase")).withRateLimiter(this.rateLimiter("ordersPerSecond")).withRateLimiter(this.rateLimiter("rawRequests")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceFutureNewOrder newPortfolioMarginFutureOrder(Instrument pair, OrderSide side, OrderType type, TimeInForce timeInForce, BigDecimal quantity, boolean reduceOnly, BigDecimal price, String newClientOrderId, BinanceNewOrder.NewOrderResponseType newOrderRespType) throws IOException, BinanceException {
        return (BinanceFutureNewOrder)this.decorateApiCall(() -> this.binanceFutures.newPortfolioMarginLinearOrder(BinanceAdapters.toSymbol(pair), side, type, timeInForce, quantity, reduceOnly, price, newClientOrderId, newOrderRespType, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("newFutureOrder", "nonIdempotentCallsBase")).withRateLimiter(this.rateLimiter("ordersPerSecond")).withRateLimiter(this.rateLimiter("rawRequests")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceFutureNewOrder newPortfolioMarginInverseFutureOrder(Instrument pair, OrderSide side, OrderType type, TimeInForce timeInForce, BigDecimal quantity, boolean reduceOnly, BigDecimal price, String newClientOrderId, BinanceNewOrder.NewOrderResponseType newOrderRespType) throws IOException, BinanceException {
        return (BinanceFutureNewOrder)this.decorateApiCall(() -> this.binanceFutures.newPortfolioMarginInverseOrder(BinanceAdapters.toSymbol(pair, true), side, type, timeInForce, quantity, reduceOnly, price, newClientOrderId, newOrderRespType, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("newFutureOrder", "nonIdempotentCallsBase")).withRateLimiter(this.rateLimiter("ordersPerSecond")).withRateLimiter(this.rateLimiter("rawRequests")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceFutureNewOrder newFutureOrder(Instrument pair, OrderSide side, OrderType type, TimeInForce timeInForce, BigDecimal quantity, Boolean reduceOnly, BigDecimal price, String newClientOrderId, BigDecimal stopPrice, boolean closePosition, BigDecimal activationPrice, BigDecimal callbackRate, BinanceNewOrder.NewOrderResponseType newOrderRespType) throws IOException, BinanceException {
        return (BinanceFutureNewOrder)this.decorateApiCall(() -> this.binanceFutures.newOrder(BinanceAdapters.toSymbol(pair), side, type, timeInForce, quantity, reduceOnly, price, newClientOrderId, stopPrice, closePosition, activationPrice, callbackRate, newOrderRespType, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("newFutureOrder", "nonIdempotentCallsBase")).withRateLimiter(this.rateLimiter("ordersPer10Seconds")).withRateLimiter(this.rateLimiter("ordersPerMINUTE")).call();
    }

    public BinanceFutureNewOrder newInverseFutureOrder(Instrument pair, OrderSide side, OrderType type, TimeInForce timeInForce, BigDecimal quantity, boolean reduceOnly, BigDecimal price, String newClientOrderId, BigDecimal stopPrice, boolean closePosition, BigDecimal activationPrice, BigDecimal callbackRate, BinanceNewOrder.NewOrderResponseType newOrderRespType) throws IOException, BinanceException {
        return (BinanceFutureNewOrder)this.decorateApiCall(() -> this.inverseBinanceFutures.newInverseOrder(BinanceAdapters.toSymbol(pair, true), side, type, timeInForce, quantity, reduceOnly, price, newClientOrderId, stopPrice, closePosition, activationPrice, callbackRate, newOrderRespType, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("newFutureOrder", "nonIdempotentCallsBase")).withRateLimiter(this.rateLimiter("ordersPerSecond")).withRateLimiter(this.rateLimiter("rawRequests")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public void testNewOrder(Instrument pair, OrderSide side, OrderType type, TimeInForce timeInForce, BigDecimal quantity, BigDecimal quoteOrderQty, BigDecimal price, String newClientOrderId, BigDecimal stopPrice, Long trailingDelta, BigDecimal icebergQty) throws IOException, BinanceException {
        this.decorateApiCall(() -> this.binance.testNewOrder(BinanceAdapters.toSymbol(pair), side, type, timeInForce, quantity, quoteOrderQty, price, newClientOrderId, stopPrice, trailingDelta, icebergQty, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("testNewOrder")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceOrder orderStatusAllProducts(Instrument pair, Long orderId, String origClientOrderId) throws IOException, BinanceException {
        if (((BinanceExchange)this.exchange).isPortfolioMarginEnabled()) {
            return (BinanceOrder)this.decorateApiCall(() -> pair instanceof FuturesContract ? (BinanceAdapters.isInverse(pair).booleanValue() ? this.binanceFutures.futurePortfolioMarginInverseOrderStatus(BinanceAdapters.toInverseSymbol(pair), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binanceFutures.futurePortfolioMarginOrderStatus(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)) : this.binance.orderStatus(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("orderStatus")).withRateLimiter(this.rateLimiter("requestWeight")).call();
        }
        return (BinanceOrder)this.decorateApiCall(() -> pair instanceof FuturesContract ? (BinanceAdapters.isInverse(pair).booleanValue() ? this.inverseBinanceFutures.futureInverseOrderStatus(BinanceAdapters.toInverseSymbol(pair), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binanceFutures.futureOrderStatus(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)) : this.binance.orderStatus(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("orderStatus")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceCancelledOrder cancelOrderAllProducts(Instrument pair, Long orderId, String origClientOrderId, String newClientOrderId) throws IOException, BinanceException {
        if (((BinanceExchange)this.exchange).isPortfolioMarginEnabled()) {
            return (BinanceCancelledOrder)this.decorateApiCall(() -> pair instanceof FuturesContract ? (BinanceAdapters.isInverse(pair).booleanValue() ? this.binanceFutures.cancelPortfolioMarginInverseFutureOrder(BinanceAdapters.toSymbol(pair, true), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binanceFutures.cancelPortfolioMarginFutureOrder(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)) : this.binance.cancelOrder(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, newClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("cancelOrder")).withRateLimiter(this.rateLimiter("requestWeight")).call();
        }
        return (BinanceCancelledOrder)this.decorateApiCall(() -> pair instanceof FuturesContract ? (BinanceAdapters.isInverse(pair).booleanValue() ? this.binanceFutures.cancelInverseFutureOrder(BinanceAdapters.toSymbol(pair, true), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binanceFutures.cancelFutureOrder(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)) : this.binance.cancelOrder(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, newClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("cancelOrder")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceCancelledOrder> cancelAllOpenOrdersAllProducts(Instrument pair) throws IOException, BinanceException {
        return (List)this.decorateApiCall(() -> this.binance.cancelAllOpenOrders(BinanceAdapters.toSymbol(pair), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("cancelAllOpenOrders")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceChangeStatus cancelAllOpenOrdersAllFuturesProducts(Instrument pair) throws IOException, BinanceException {
        return (BinanceChangeStatus)this.decorateApiCall(() -> this.binanceFutures.cancelAllFutureOpenOrders(BinanceAdapters.toSymbol(pair), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("cancelAllOpenOrders")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceOrder> allOrders(CurrencyPair pair, Long orderId, Integer limit) throws BinanceException, IOException {
        return (List)this.decorateApiCall(() -> this.binance.allOrders(BinanceAdapters.toSymbol((Instrument)pair), orderId, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("allOrders")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceTrade> myTradesAllProducts(Instrument pair, Long orderId, Long startTime, Long endTime, Long fromId, Integer limit) throws BinanceException, IOException {
        if (pair instanceof FuturesContract) {
            return (List)this.decorateApiCall(() -> this.binanceFutures.myFutureTrades(BinanceAdapters.toSymbol(pair), orderId, startTime, endTime, fromId, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("myTrades")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call();
        }
        return (List)this.decorateApiCall(() -> this.binance.myTrades(BinanceAdapters.toSymbol(pair), orderId, startTime, endTime, fromId, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("myTrades")).withRateLimiter(this.rateLimiter("requestWeight"), orderId != null ? 5 : 20).call();
    }

    public List<BinancePosition> openPositions() throws BinanceException, IOException {
        return this.openPositions(false);
    }

    public List<BinancePosition> openPositions(boolean useV3) throws BinanceException, IOException {
        return ((BinanceFutureAccountInformation)this.decorateApiCall(() -> useV3 ? this.binanceFutures.futuresV3Account(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binanceFutures.futuresAccount(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("futures-account")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call()).getPositions();
    }

    public BinanceDustLog getDustLog(Long startTime, Long endTime) throws IOException {
        if (startTime != null && endTime == null || startTime == null && endTime != null) {
            throw new ExchangeException("You need to specify both, the start and the end date, or none of them");
        }
        return (BinanceDustLog)this.decorateApiCall(() -> this.binance.getDustLog(startTime, endTime, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("myDustLog")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceListenKey startUserDataStream() throws IOException {
        return (BinanceListenKey)this.decorateApiCall(() -> this.binance.startUserDataStream(this.apiKey)).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public void keepAliveDataStream(String listenKey) throws IOException {
        this.decorateApiCall(() -> this.binance.keepAliveUserDataStream(this.apiKey, listenKey)).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public void closeDataStream(String listenKey) throws IOException {
        this.decorateApiCall(() -> this.binance.closeUserDataStream(this.apiKey, listenKey)).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    protected int openOrdersPermits(Instrument pair) {
        if (((BinanceExchange)this.exchange).getExchangeSpecification().getExchangeSpecificParametersItem(BinanceExchange.EXCHANGE_TYPE).equals("SPOT")) {
            return pair != null ? 6 : 80;
        }
        return pair != null ? 1 : 40;
    }

    public BinanceFutureNewOrder modifyOrder(Long orderId, String origClientOrderId, Instrument instrument, OrderSide side, BigDecimal quantity, BigDecimal price) throws IOException {
        return (BinanceFutureNewOrder)this.decorateApiCall(() -> this.binanceFutures.modifyOrder(orderId, origClientOrderId, BinanceAdapters.toSymbol(instrument, false), side, quantity, price, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("modifyOrder")).withRateLimiter(this.rateLimiter("ordersPer10Seconds")).withRateLimiter(this.rateLimiter("ordersPerMINUTE")).call();
    }

    public List<BinancePosition> getFuturesPositionRisk(Instrument instrument) throws IOException, BinanceException {
        return this.getFuturesPositionRisk(instrument, false);
    }

    public List<BinancePosition> getFuturesPositionRisk(Instrument instrument, boolean useV3) throws IOException, BinanceException {
        return (List)this.decorateApiCall(() -> useV3 ? this.binanceFutures.getFuturesV3PositionRisk(BinanceAdapters.toSymbol(instrument), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binanceFutures.getFuturesPositionRisk(BinanceAdapters.toSymbol(instrument), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("futuresPositionRisk")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call();
    }

    public List<BinanceOrder> getAllFutureOrders(Instrument instrument, Long orderId, long startTime, long endTime, int limit) throws IOException, BinanceException {
        return (List)this.decorateApiCall(() -> this.binanceFutures.getAllFutureOrders(BinanceAdapters.toSymbol(instrument), orderId, startTime, endTime, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("getAllFutureOrders")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call();
    }
}

