/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.marketdata.BinanceAggTrades;
import org.knowm.xchange.binance.dto.marketdata.BinanceFundingRate;
import org.knowm.xchange.binance.dto.marketdata.BinanceFundingRateInfo;
import org.knowm.xchange.binance.dto.marketdata.BinanceKline;
import org.knowm.xchange.binance.dto.marketdata.BinanceOrderbook;
import org.knowm.xchange.binance.dto.marketdata.BinancePrice;
import org.knowm.xchange.binance.dto.marketdata.BinancePriceQuantity;
import org.knowm.xchange.binance.dto.marketdata.BinanceTicker24h;
import org.knowm.xchange.binance.dto.marketdata.KlineInterval;
import org.knowm.xchange.binance.dto.meta.BinanceTime;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.BinanceExchangeInfo;
import org.knowm.xchange.binance.service.BinanceBaseService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.derivative.FuturesContract;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.utils.StreamUtils;

public class BinanceMarketDataServiceRaw
extends BinanceBaseService {
    protected BinanceMarketDataServiceRaw(BinanceExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public void ping() throws IOException {
        this.decorateApiCall(this.binance::ping).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceTime binanceTime() throws IOException {
        return (BinanceTime)this.decorateApiCall(this.binance::time).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceExchangeInfo getExchangeInfo() throws IOException {
        return (BinanceExchangeInfo)this.decorateApiCall(this.binance::exchangeInfo).withRetry(this.retry("exchangeInfo")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceExchangeInfo getFutureExchangeInfo() throws IOException {
        return (BinanceExchangeInfo)this.decorateApiCall(this.binanceFutures::exchangeInfo).withRetry(this.retry("exchangeInfo")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceOrderbook getBinanceOrderbookAllProducts(Instrument pair, Integer limit) throws IOException {
        boolean isFutures = pair instanceof FuturesContract;
        return (BinanceOrderbook)this.decorateApiCall(() -> isFutures ? this.binanceFutures.depth(BinanceAdapters.toSymbol(pair), limit) : this.binance.depth(BinanceAdapters.toSymbol(pair), limit)).withRetry(this.retry("depth")).withRateLimiter(this.rateLimiter("requestWeight"), isFutures ? this.depthPermitsFutures(limit) : this.depthPermits(limit)).call();
    }

    public List<BinanceAggTrades> aggTradesAllProducts(Instrument pair, Long fromId, Long startTime, Long endTime, Integer limit) throws IOException {
        if (pair instanceof FuturesContract) {
            return (List)this.decorateApiCall(() -> this.binanceFutures.aggTrades(BinanceAdapters.toSymbol(pair), fromId, startTime, endTime, limit)).withRetry(this.retry("aggTrades")).withRateLimiter(this.rateLimiter("requestWeight"), 20).call();
        }
        return (List)this.decorateApiCall(() -> this.binance.aggTrades(BinanceAdapters.toSymbol(pair), fromId, startTime, endTime, limit)).withRetry(this.retry("aggTrades")).withRateLimiter(this.rateLimiter("requestWeight"), 4).call();
    }

    public BinanceKline lastKline(CurrencyPair pair, KlineInterval interval) throws IOException {
        return (BinanceKline)this.klines((Instrument)pair, interval, 1, null, null).stream().collect(StreamUtils.singletonCollector());
    }

    public List<BinanceKline> klines(CurrencyPair pair, KlineInterval interval) throws IOException {
        return this.klines((Instrument)pair, interval, null, null, null);
    }

    public List<BinanceKline> klines(Instrument pair, KlineInterval interval, Integer limit, Long startTime, Long endTime) throws IOException {
        boolean isFutures = pair instanceof FuturesContract;
        List raw = (List)this.decorateApiCall(() -> isFutures ? this.binanceFutures.klines(BinanceAdapters.toSymbol(pair), interval.code(), limit, startTime, endTime) : this.binance.klines(BinanceAdapters.toSymbol(pair), interval.code(), limit, startTime, endTime)).withRetry(this.retry("klines")).withRateLimiter(this.rateLimiter("requestWeight")).call();
        return raw.stream().map(obj -> new BinanceKline(pair, interval, (Object[])obj)).collect(Collectors.toList());
    }

    public List<BinanceTicker24h> ticker24hAllProducts(boolean isFutures) throws IOException {
        if (isFutures) {
            return (List)this.decorateApiCall(this.binanceFutures::ticker24h).withRetry(this.retry("ticker24h")).withRateLimiter(this.rateLimiter("requestWeight"), 40).call();
        }
        return (List)this.decorateApiCall(this.binance::ticker24h).withRetry(this.retry("ticker24h")).withRateLimiter(this.rateLimiter("requestWeight"), 80).call();
    }

    public BinanceTicker24h ticker24hAllProducts(Instrument pair) throws IOException {
        BinanceTicker24h ticker24h = (BinanceTicker24h)this.decorateApiCall(() -> pair instanceof FuturesContract ? this.binanceFutures.ticker24h(BinanceAdapters.toSymbol(pair)) : this.binance.ticker24h(BinanceAdapters.toSymbol(pair))).withRetry(this.retry("ticker24h")).withRateLimiter(this.rateLimiter("requestWeight")).call();
        return ticker24h;
    }

    public List<BinanceFundingRate> getBinanceFundingRates() throws IOException {
        return (List)this.decorateApiCall(this.binanceFutures::fundingRates).withRetry(this.retry("fundingRate")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceFundingRate getBinanceFundingRate(Instrument instrument) throws IOException {
        return (BinanceFundingRate)this.decorateApiCall(() -> this.binanceFutures.fundingRate(BinanceAdapters.toSymbol(instrument))).withRetry(this.retry("fundingRate")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceFundingRateInfo> getBinanceFundingRateInfo() throws IOException {
        return (List)this.decorateApiCall(() -> this.binanceFutures.fundingRateInfo()).withRetry(this.retry("fundingRate")).call();
    }

    public BinancePrice tickerPrice(CurrencyPair pair) throws IOException {
        return (BinancePrice)this.tickerAllPrices().stream().filter(p -> p.getCurrencyPair().equals((Object)pair)).collect(StreamUtils.singletonCollector());
    }

    public List<BinancePrice> tickerAllPrices() throws IOException {
        return (List)this.decorateApiCall(this.binance::tickerAllPrices).withRetry(this.retry("tickerAllPrices")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinancePriceQuantity> tickerAllBookTickers() throws IOException {
        return (List)this.decorateApiCall(this.binance::tickerAllBookTickers).withRetry(this.retry("tickerAllBookTickers")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    protected int depthPermits(Integer limit) {
        if (limit == null || limit <= 100) {
            return 5;
        }
        if (limit <= 500) {
            return 25;
        }
        if (limit <= 1000) {
            return 50;
        }
        return 250;
    }

    protected int depthPermitsFutures(Integer limit) {
        if (limit == null || limit <= 50) {
            return 2;
        }
        if (limit <= 100) {
            return 5;
        }
        if (limit <= 500) {
            return 10;
        }
        return 20;
    }
}

