/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.account.AssetDetail;
import org.knowm.xchange.binance.dto.account.AssetDividendResponse;
import org.knowm.xchange.binance.dto.account.BinanceAccountInformation;
import org.knowm.xchange.binance.dto.account.BinanceCurrencyInfo;
import org.knowm.xchange.binance.dto.account.BinanceDeposit;
import org.knowm.xchange.binance.dto.account.BinanceFiatOrder;
import org.knowm.xchange.binance.dto.account.BinanceFiatOrdersResponse;
import org.knowm.xchange.binance.dto.account.BinanceFlexiblePositionResponse;
import org.knowm.xchange.binance.dto.account.BinanceLockedPositionResponse;
import org.knowm.xchange.binance.dto.account.BinanceSimpleAccount;
import org.knowm.xchange.binance.dto.account.BinanceTradeFee;
import org.knowm.xchange.binance.dto.account.BinanceWithdraw;
import org.knowm.xchange.binance.dto.account.DepositAddress;
import org.knowm.xchange.binance.dto.account.TransferHistory;
import org.knowm.xchange.binance.dto.account.TransferSubUserHistory;
import org.knowm.xchange.binance.dto.account.WithdrawResponse;
import org.knowm.xchange.binance.dto.account.futures.BinanceFutureAccountInformation;
import org.knowm.xchange.binance.dto.account.futures.BinanceFutureCommissionRate;
import org.knowm.xchange.binance.dto.trade.MarginType;
import org.knowm.xchange.binance.dto.trade.futures.BinanceChangeStatus;
import org.knowm.xchange.binance.dto.trade.futures.BinanceSetLeverage;
import org.knowm.xchange.binance.service.BinanceBaseService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.instrument.Instrument;

public class BinanceAccountServiceRaw
extends BinanceBaseService {
    private List<BinanceCurrencyInfo> currencyInfos;
    private final Lock currencyInfoLock = new ReentrantLock();

    public BinanceAccountServiceRaw(BinanceExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public BinanceAccountInformation account() throws BinanceException, IOException {
        return (BinanceAccountInformation)this.decorateApiCall(() -> this.binance.account(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("account")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call();
    }

    public List<BinanceCurrencyInfo> currencyInfos() throws BinanceException, IOException {
        return (List)this.decorateApiCall(() -> this.binance.getCurrencyInfos(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("currencyInfo")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call();
    }

    public BinanceFutureAccountInformation futuresAccount() throws BinanceException, IOException {
        return this.futuresAccount(false);
    }

    public BinanceFutureAccountInformation futuresAccount(boolean useV3) throws BinanceException, IOException {
        return (BinanceFutureAccountInformation)this.decorateApiCall(() -> useV3 ? this.binanceFutures.futuresV3Account(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binanceFutures.futuresAccount(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("futures-account")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call();
    }

    public WithdrawResponse withdraw(String coin, String address, BigDecimal amount) throws IOException, BinanceException {
        String name = address.length() <= 10 ? address : address.substring(0, 10);
        return this.withdraw(coin, address, null, amount, name, null);
    }

    public WithdrawResponse withdraw(String coin, String address, String addressTag, BigDecimal amount, String network) throws IOException, BinanceException {
        String name = address.length() <= 10 ? address : address.substring(0, 10);
        return this.withdraw(coin, address, addressTag, amount, name, network);
    }

    private WithdrawResponse withdraw(String coin, String address, String addressTag, BigDecimal amount, String name, String network) throws IOException, BinanceException {
        return (WithdrawResponse)this.decorateApiCall(() -> this.binance.withdraw(coin, address, addressTag, amount, name, network, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("withdraw", "nonIdempotentCallsBase")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call();
    }

    public DepositAddress requestDepositAddress(Currency currency) throws IOException {
        return this.requestDepositAddressWithNetwork(currency, null);
    }

    public DepositAddress requestDepositAddressWithNetwork(Currency currency, String network) throws IOException {
        return (DepositAddress)this.decorateApiCall(() -> this.binance.depositAddress(BinanceAdapters.toSymbol(currency), network, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("depositAddress")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public Map<String, AssetDetail> requestAssetDetail() throws IOException {
        return (Map)this.decorateApiCall(() -> this.binance.assetDetail(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("assetDetail")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceDeposit> depositHistory(String asset, Long startTime, Long endTime) throws BinanceException, IOException {
        return (List)this.decorateApiCall(() -> this.binance.depositHistory(asset, startTime, endTime, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("depositHistory")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceWithdraw> withdrawHistory(String asset, Long startTime, Long endTime) throws BinanceException, IOException {
        return (List)this.decorateApiCall(() -> this.binance.withdrawHistory(asset, startTime, endTime, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("withdrawHistory")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<AssetDividendResponse.AssetDividend> getAssetDividend(Long startTime, Long endTime) throws BinanceException, IOException {
        return this.getAssetDividend("", startTime, endTime);
    }

    public List<AssetDividendResponse.AssetDividend> getAssetDividend(String asset, Long startTime, Long endTime) throws BinanceException, IOException {
        return ((AssetDividendResponse)this.decorateApiCall(() -> this.binance.assetDividend(asset, startTime, endTime, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("assetDividend")).withRateLimiter(this.rateLimiter("requestWeight")).call()).getData();
    }

    public List<TransferHistory> getTransferHistory(String fromEmail, Long startTime, Long endTime, Integer page, Integer limit) throws BinanceException, IOException {
        return (List)this.decorateApiCall(() -> this.binance.transferHistory(fromEmail, startTime, endTime, page, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("transferHistory")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<TransferSubUserHistory> getSubUserHistory(String asset, Integer type, Long startTime, Long endTime, Integer limit) throws BinanceException, IOException {
        return (List)this.decorateApiCall(() -> this.binance.transferSubUserHistory(asset, type, startTime, endTime, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("transferSubUserHistory")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceFiatOrder> getFiatOrders(String transactionType, Long beginTime, Long endTime, Integer page, Integer rows) throws BinanceException, IOException {
        BinanceFiatOrdersResponse response = (BinanceFiatOrdersResponse)this.decorateApiCall(() -> this.binance.fiatOrders(transactionType, beginTime, endTime, page, rows, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("fiatOrders")).withRateLimiter(this.rateLimiter("requestWeight")).call();
        return response != null ? response.getData() : List.of();
    }

    protected List<BinanceCurrencyInfo> getCurrencyInfoCached() throws IOException {
        this.currencyInfoLock.lock();
        try {
            if (this.currencyInfos == null) {
                this.currencyInfos = this.currencyInfos();
            }
            this.currencyInfos = this.currencyInfos();
        }
        finally {
            this.currencyInfoLock.unlock();
        }
        return this.currencyInfos;
    }

    protected Optional<BinanceCurrencyInfo> getCurrencyInfo(Currency currency) throws IOException {
        return this.getCurrencyInfoCached().stream().filter(info -> currency.equals((Object)info.getCurrency())).findFirst();
    }

    protected List<BinanceTradeFee> getTradeFee() throws IOException {
        return (List)this.decorateApiCall(() -> this.binance.getTradeFee(null, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("tradeFee")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    protected BinanceFutureCommissionRate getCommissionRate(String symbol) throws IOException {
        return (BinanceFutureCommissionRate)this.decorateApiCall(() -> this.binanceFutures.getFutureCommissionRate(symbol, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("commissionRate")).withRateLimiter(this.rateLimiter("requestWeight"), 20).call();
    }

    public BinanceChangeStatus setMarginType(Instrument instrument, MarginType marginType) throws IOException {
        return (BinanceChangeStatus)this.decorateApiCall(() -> this.binanceFutures.setMarginType(BinanceAdapters.toSymbol(instrument, false), marginType, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("setMarginType")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceChangeStatus setDualSidePosition(boolean dualSidePosition) throws IOException {
        return (BinanceChangeStatus)this.decorateApiCall(() -> this.binanceFutures.setDualSidePosition(dualSidePosition, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("setDualSidePosition")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceSetLeverage setLeverageRaw(Instrument instrument, int leverage) throws IOException {
        return (BinanceSetLeverage)this.decorateApiCall(() -> this.binanceFutures.setLeverage(BinanceAdapters.toSymbol(instrument, false), leverage, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("setLeverage")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceSimpleAccount getSimpleAccount() throws BinanceException, IOException {
        return (BinanceSimpleAccount)this.decorateApiCall(() -> this.binance.simpleAccount(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("simpleAccount")).withRateLimiter(this.rateLimiter("requestWeight"), 150).call();
    }

    protected BinanceFlexiblePositionResponse getFlexiblePositionsRaw(String asset, String productId, Long current, Long size) throws BinanceException, IOException {
        return (BinanceFlexiblePositionResponse)this.decorateApiCall(() -> this.binance.flexiblePosition(asset, productId, current, size, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("flexiblePosition")).withRateLimiter(this.rateLimiter("requestWeight"), 150).call();
    }

    protected BinanceLockedPositionResponse getLockedPositionsRaw(String asset, Long positionId, String projectId, Long current, Long size) throws BinanceException, IOException {
        return (BinanceLockedPositionResponse)this.decorateApiCall(() -> this.binance.lockedPosition(asset, positionId, projectId, current, size, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("lockedPosition")).withRateLimiter(this.rateLimiter("requestWeight"), 150).call();
    }
}

