/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import org.knowm.xchange.currency.Currency;

public final class BinanceBalance {
    private final Currency currency;
    private final BigDecimal free;
    private final BigDecimal locked;

    public BinanceBalance(@JsonProperty(value="asset") String asset, @JsonProperty(value="free") BigDecimal free, @JsonProperty(value="locked") BigDecimal locked) {
        this.currency = Currency.getInstance((String)asset);
        this.locked = locked;
        this.free = free;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getTotal() {
        return this.free.add(this.locked);
    }

    public BigDecimal getAvailable() {
        return this.free;
    }

    public BigDecimal getLocked() {
        return this.locked;
    }

    public String toString() {
        return "[" + String.valueOf(this.currency) + ", free=" + String.valueOf(this.free) + ", locked=" + String.valueOf(this.locked) + "]";
    }
}

