/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.binance.Binance;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.account.AssetDetail;
import org.knowm.xchange.binance.dto.account.AssetDividendResponse;
import org.knowm.xchange.binance.dto.account.BinanceAccountInformation;
import org.knowm.xchange.binance.dto.account.BinanceCurrencyInfo;
import org.knowm.xchange.binance.dto.account.BinanceDeposit;
import org.knowm.xchange.binance.dto.account.BinanceWithdraw;
import org.knowm.xchange.binance.dto.account.DepositAddress;
import org.knowm.xchange.binance.dto.account.TransferHistory;
import org.knowm.xchange.binance.dto.account.TransferSubUserHistory;
import org.knowm.xchange.binance.dto.account.WithdrawResponse;
import org.knowm.xchange.binance.dto.trade.BinanceCancelledOrder;
import org.knowm.xchange.binance.dto.trade.BinanceDustLog;
import org.knowm.xchange.binance.dto.trade.BinanceListenKey;
import org.knowm.xchange.binance.dto.trade.BinanceNewOrder;
import org.knowm.xchange.binance.dto.trade.BinanceOrder;
import org.knowm.xchange.binance.dto.trade.BinanceTrade;
import org.knowm.xchange.binance.dto.trade.OrderSide;
import org.knowm.xchange.binance.dto.trade.OrderType;
import org.knowm.xchange.binance.dto.trade.TimeInForce;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="")
@Produces(value={"application/json"})
public interface BinanceAuthenticated
extends Binance {
    public static final String SIGNATURE = "signature";
    public static final String X_MBX_APIKEY = "X-MBX-APIKEY";

    @POST
    @Path(value="api/v3/order")
    public BinanceNewOrder newOrder(@FormParam(value="symbol") String var1, @FormParam(value="side") OrderSide var2, @FormParam(value="type") OrderType var3, @FormParam(value="timeInForce") TimeInForce var4, @FormParam(value="quantity") BigDecimal var5, @FormParam(value="quoteOrderQty") BigDecimal var6, @FormParam(value="price") BigDecimal var7, @FormParam(value="newClientOrderId") String var8, @FormParam(value="stopPrice") BigDecimal var9, @FormParam(value="trailingDelta") Long var10, @FormParam(value="icebergQty") BigDecimal var11, @FormParam(value="newOrderRespType") BinanceNewOrder.NewOrderResponseType var12, @FormParam(value="recvWindow") Long var13, @FormParam(value="timestamp") SynchronizedValueFactory<Long> var14, @HeaderParam(value="X-MBX-APIKEY") String var15, @QueryParam(value="signature") ParamsDigest var16) throws IOException, BinanceException;

    @POST
    @Path(value="api/v3/order/test")
    public Object testNewOrder(@FormParam(value="symbol") String var1, @FormParam(value="side") OrderSide var2, @FormParam(value="type") OrderType var3, @FormParam(value="timeInForce") TimeInForce var4, @FormParam(value="quantity") BigDecimal var5, @FormParam(value="quoteOrderQty") BigDecimal var6, @FormParam(value="price") BigDecimal var7, @FormParam(value="newClientOrderId") String var8, @FormParam(value="stopPrice") BigDecimal var9, @FormParam(value="trailingDelta") Long var10, @FormParam(value="icebergQty") BigDecimal var11, @FormParam(value="recvWindow") Long var12, @FormParam(value="timestamp") SynchronizedValueFactory<Long> var13, @HeaderParam(value="X-MBX-APIKEY") String var14, @QueryParam(value="signature") ParamsDigest var15) throws IOException, BinanceException;

    @GET
    @Path(value="api/v3/order")
    public BinanceOrder orderStatus(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") long var2, @QueryParam(value="origClientOrderId") String var4, @QueryParam(value="recvWindow") Long var5, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var6, @HeaderParam(value="X-MBX-APIKEY") String var7, @QueryParam(value="signature") ParamsDigest var8) throws IOException, BinanceException;

    @DELETE
    @Path(value="api/v3/order")
    public BinanceCancelledOrder cancelOrder(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") long var2, @QueryParam(value="origClientOrderId") String var4, @QueryParam(value="newClientOrderId") String var5, @QueryParam(value="recvWindow") Long var6, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var7, @HeaderParam(value="X-MBX-APIKEY") String var8, @QueryParam(value="signature") ParamsDigest var9) throws IOException, BinanceException;

    @DELETE
    @Path(value="api/v3/openOrders")
    public List<BinanceCancelledOrder> cancelAllOpenOrders(@QueryParam(value="symbol") String var1, @QueryParam(value="recvWindow") Long var2, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var3, @HeaderParam(value="X-MBX-APIKEY") String var4, @QueryParam(value="signature") ParamsDigest var5) throws IOException, BinanceException;

    @GET
    @Path(value="api/v3/openOrders")
    public List<BinanceOrder> openOrders(@QueryParam(value="symbol") String var1, @QueryParam(value="recvWindow") Long var2, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var3, @HeaderParam(value="X-MBX-APIKEY") String var4, @QueryParam(value="signature") ParamsDigest var5) throws IOException, BinanceException;

    @GET
    @Path(value="api/v3/allOrders")
    public List<BinanceOrder> allOrders(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") Long var2, @QueryParam(value="limit") Integer var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var5, @HeaderParam(value="X-MBX-APIKEY") String var6, @QueryParam(value="signature") ParamsDigest var7) throws IOException, BinanceException;

    @GET
    @Path(value="api/v3/account")
    public BinanceAccountInformation account(@QueryParam(value="recvWindow") Long var1, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-MBX-APIKEY") String var3, @QueryParam(value="signature") ParamsDigest var4) throws IOException, BinanceException;

    @GET
    @Path(value="api/v3/myTrades")
    public List<BinanceTrade> myTrades(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") Long var2, @QueryParam(value="startTime") Long var3, @QueryParam(value="endTime") Long var4, @QueryParam(value="fromId") Long var5, @QueryParam(value="limit") Integer var6, @QueryParam(value="recvWindow") Long var7, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var8, @HeaderParam(value="X-MBX-APIKEY") String var9, @QueryParam(value="signature") ParamsDigest var10) throws IOException, BinanceException;

    @GET
    @Path(value="/sapi/v1/asset/dribblet")
    public BinanceDustLog getDustLog(@QueryParam(value="startTime") Long var1, @QueryParam(value="endTime") Long var2, @QueryParam(value="recvWindow") Long var3, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var4, @HeaderParam(value="X-MBX-APIKEY") String var5, @QueryParam(value="signature") ParamsDigest var6) throws IOException, BinanceException;

    @GET
    @Path(value="/sapi/v1/capital/config/getall")
    public List<BinanceCurrencyInfo> getCurrencyInfos(@QueryParam(value="recvWindow") Long var1, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-MBX-APIKEY") String var3, @QueryParam(value="signature") ParamsDigest var4) throws IOException, BinanceException;

    @POST
    @Path(value="/sapi/v1/capital/withdraw/apply")
    public WithdrawResponse withdraw(@QueryParam(value="coin") String var1, @QueryParam(value="address") String var2, @QueryParam(value="addressTag") String var3, @QueryParam(value="amount") BigDecimal var4, @QueryParam(value="name") String var5, @QueryParam(value="network") String var6, @QueryParam(value="recvWindow") Long var7, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var8, @HeaderParam(value="X-MBX-APIKEY") String var9, @QueryParam(value="signature") ParamsDigest var10) throws IOException, BinanceException;

    @GET
    @Path(value="/sapi/v1/capital/deposit/hisrec")
    public List<BinanceDeposit> depositHistory(@QueryParam(value="coin") String var1, @QueryParam(value="startTime") Long var2, @QueryParam(value="endTime") Long var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var5, @HeaderParam(value="X-MBX-APIKEY") String var6, @QueryParam(value="signature") ParamsDigest var7) throws IOException, BinanceException;

    @GET
    @Path(value="/sapi/v1/capital/withdraw/history")
    public List<BinanceWithdraw> withdrawHistory(@QueryParam(value="coin") String var1, @QueryParam(value="startTime") Long var2, @QueryParam(value="endTime") Long var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var5, @HeaderParam(value="X-MBX-APIKEY") String var6, @QueryParam(value="signature") ParamsDigest var7) throws IOException, BinanceException;

    @GET
    @Path(value="/sapi/v1/asset/assetDividend")
    public AssetDividendResponse assetDividend(@QueryParam(value="asset") String var1, @QueryParam(value="startTime") Long var2, @QueryParam(value="endTime") Long var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var5, @HeaderParam(value="X-MBX-APIKEY") String var6, @QueryParam(value="signature") ParamsDigest var7) throws IOException, BinanceException;

    @GET
    @Path(value="/sapi/v1/sub-account/sub/transfer/history")
    public List<TransferHistory> transferHistory(@QueryParam(value="fromEmail") String var1, @QueryParam(value="startTime") Long var2, @QueryParam(value="endTime") Long var3, @QueryParam(value="page") Integer var4, @QueryParam(value="limit") Integer var5, @QueryParam(value="recvWindow") Long var6, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var7, @HeaderParam(value="X-MBX-APIKEY") String var8, @QueryParam(value="signature") ParamsDigest var9) throws IOException, BinanceException;

    @GET
    @Path(value="/sapi/v1/sub-account/transfer/subUserHistory")
    public List<TransferSubUserHistory> transferSubUserHistory(@QueryParam(value="asset") String var1, @QueryParam(value="type") Integer var2, @QueryParam(value="startTime") Long var3, @QueryParam(value="endTime") Long var4, @QueryParam(value="limit") Integer var5, @QueryParam(value="recvWindow") Long var6, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var7, @HeaderParam(value="X-MBX-APIKEY") String var8, @QueryParam(value="signature") ParamsDigest var9) throws IOException, BinanceException;

    @GET
    @Path(value="/sapi/v1/capital/deposit/address")
    public DepositAddress depositAddress(@QueryParam(value="coin") String var1, @QueryParam(value="network") String var2, @QueryParam(value="recvWindow") Long var3, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var4, @HeaderParam(value="X-MBX-APIKEY") String var5, @QueryParam(value="signature") ParamsDigest var6) throws IOException, BinanceException;

    @GET
    @Path(value="/sapi/v1/asset/assetDetail")
    public Map<String, AssetDetail> assetDetail(@QueryParam(value="recvWindow") Long var1, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-MBX-APIKEY") String var3, @QueryParam(value="signature") ParamsDigest var4) throws IOException, BinanceException;

    @POST
    @Path(value="/api/v3/userDataStream")
    public BinanceListenKey startUserDataStream(@HeaderParam(value="X-MBX-APIKEY") String var1) throws IOException, BinanceException;

    @PUT
    @Path(value="/api/v3/userDataStream?listenKey={listenKey}")
    public Map<?, ?> keepAliveUserDataStream(@HeaderParam(value="X-MBX-APIKEY") String var1, @PathParam(value="listenKey") String var2) throws IOException, BinanceException;

    @DELETE
    @Path(value="/api/v3/userDataStream?listenKey={listenKey}")
    public Map<?, ?> closeUserDataStream(@HeaderParam(value="X-MBX-APIKEY") String var1, @PathParam(value="listenKey") String var2) throws IOException, BinanceException;
}

