/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import org.knowm.xchange.binance.config.converter.StringToCurrencyPairConverter;
import org.knowm.xchange.currency.CurrencyPair;

@JsonDeserialize(builder=BinanceTicker24hBuilder.class)
public final class BinanceTicker24h {
    private BigDecimal priceChange;
    private BigDecimal priceChangePercent;
    private BigDecimal weightedAvgPrice;
    private BigDecimal prevClosePrice;
    private BigDecimal lastPrice;
    private BigDecimal lastQty;
    private BigDecimal bidPrice;
    private BigDecimal bidQty;
    private BigDecimal askPrice;
    private BigDecimal askQty;
    private BigDecimal openPrice;
    private BigDecimal highPrice;
    private BigDecimal lowPrice;
    private BigDecimal volume;
    private BigDecimal quoteVolume;
    private long openTime;
    private long closeTime;
    private long firstId;
    private long lastId;
    private long count;
    @JsonProperty(value="symbol")
    @JsonDeserialize(converter=StringToCurrencyPairConverter.class)
    private CurrencyPair currencyPair;

    public boolean isValid() {
        return this.currencyPair != null;
    }

    public static BinanceTicker24hBuilder builder() {
        return new BinanceTicker24hBuilder();
    }

    public BigDecimal getPriceChange() {
        return this.priceChange;
    }

    public BigDecimal getPriceChangePercent() {
        return this.priceChangePercent;
    }

    public BigDecimal getWeightedAvgPrice() {
        return this.weightedAvgPrice;
    }

    public BigDecimal getPrevClosePrice() {
        return this.prevClosePrice;
    }

    public BigDecimal getLastPrice() {
        return this.lastPrice;
    }

    public BigDecimal getLastQty() {
        return this.lastQty;
    }

    public BigDecimal getBidPrice() {
        return this.bidPrice;
    }

    public BigDecimal getBidQty() {
        return this.bidQty;
    }

    public BigDecimal getAskPrice() {
        return this.askPrice;
    }

    public BigDecimal getAskQty() {
        return this.askQty;
    }

    public BigDecimal getOpenPrice() {
        return this.openPrice;
    }

    public BigDecimal getHighPrice() {
        return this.highPrice;
    }

    public BigDecimal getLowPrice() {
        return this.lowPrice;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getQuoteVolume() {
        return this.quoteVolume;
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public long getCloseTime() {
        return this.closeTime;
    }

    public long getFirstId() {
        return this.firstId;
    }

    public long getLastId() {
        return this.lastId;
    }

    public long getCount() {
        return this.count;
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public void setPriceChange(BigDecimal priceChange) {
        this.priceChange = priceChange;
    }

    public void setPriceChangePercent(BigDecimal priceChangePercent) {
        this.priceChangePercent = priceChangePercent;
    }

    public void setWeightedAvgPrice(BigDecimal weightedAvgPrice) {
        this.weightedAvgPrice = weightedAvgPrice;
    }

    public void setPrevClosePrice(BigDecimal prevClosePrice) {
        this.prevClosePrice = prevClosePrice;
    }

    public void setLastPrice(BigDecimal lastPrice) {
        this.lastPrice = lastPrice;
    }

    public void setLastQty(BigDecimal lastQty) {
        this.lastQty = lastQty;
    }

    public void setBidPrice(BigDecimal bidPrice) {
        this.bidPrice = bidPrice;
    }

    public void setBidQty(BigDecimal bidQty) {
        this.bidQty = bidQty;
    }

    public void setAskPrice(BigDecimal askPrice) {
        this.askPrice = askPrice;
    }

    public void setAskQty(BigDecimal askQty) {
        this.askQty = askQty;
    }

    public void setOpenPrice(BigDecimal openPrice) {
        this.openPrice = openPrice;
    }

    public void setHighPrice(BigDecimal highPrice) {
        this.highPrice = highPrice;
    }

    public void setLowPrice(BigDecimal lowPrice) {
        this.lowPrice = lowPrice;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public void setQuoteVolume(BigDecimal quoteVolume) {
        this.quoteVolume = quoteVolume;
    }

    public void setOpenTime(long openTime) {
        this.openTime = openTime;
    }

    public void setCloseTime(long closeTime) {
        this.closeTime = closeTime;
    }

    public void setFirstId(long firstId) {
        this.firstId = firstId;
    }

    public void setLastId(long lastId) {
        this.lastId = lastId;
    }

    public void setCount(long count) {
        this.count = count;
    }

    @JsonProperty(value="symbol")
    @JsonDeserialize(converter=StringToCurrencyPairConverter.class)
    public void setCurrencyPair(CurrencyPair currencyPair) {
        this.currencyPair = currencyPair;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinanceTicker24h)) {
            return false;
        }
        BinanceTicker24h other = (BinanceTicker24h)o;
        if (this.getOpenTime() != other.getOpenTime()) {
            return false;
        }
        if (this.getCloseTime() != other.getCloseTime()) {
            return false;
        }
        if (this.getFirstId() != other.getFirstId()) {
            return false;
        }
        if (this.getLastId() != other.getLastId()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        BigDecimal this$priceChange = this.getPriceChange();
        BigDecimal other$priceChange = other.getPriceChange();
        if (this$priceChange == null ? other$priceChange != null : !((Object)this$priceChange).equals(other$priceChange)) {
            return false;
        }
        BigDecimal this$priceChangePercent = this.getPriceChangePercent();
        BigDecimal other$priceChangePercent = other.getPriceChangePercent();
        if (this$priceChangePercent == null ? other$priceChangePercent != null : !((Object)this$priceChangePercent).equals(other$priceChangePercent)) {
            return false;
        }
        BigDecimal this$weightedAvgPrice = this.getWeightedAvgPrice();
        BigDecimal other$weightedAvgPrice = other.getWeightedAvgPrice();
        if (this$weightedAvgPrice == null ? other$weightedAvgPrice != null : !((Object)this$weightedAvgPrice).equals(other$weightedAvgPrice)) {
            return false;
        }
        BigDecimal this$prevClosePrice = this.getPrevClosePrice();
        BigDecimal other$prevClosePrice = other.getPrevClosePrice();
        if (this$prevClosePrice == null ? other$prevClosePrice != null : !((Object)this$prevClosePrice).equals(other$prevClosePrice)) {
            return false;
        }
        BigDecimal this$lastPrice = this.getLastPrice();
        BigDecimal other$lastPrice = other.getLastPrice();
        if (this$lastPrice == null ? other$lastPrice != null : !((Object)this$lastPrice).equals(other$lastPrice)) {
            return false;
        }
        BigDecimal this$lastQty = this.getLastQty();
        BigDecimal other$lastQty = other.getLastQty();
        if (this$lastQty == null ? other$lastQty != null : !((Object)this$lastQty).equals(other$lastQty)) {
            return false;
        }
        BigDecimal this$bidPrice = this.getBidPrice();
        BigDecimal other$bidPrice = other.getBidPrice();
        if (this$bidPrice == null ? other$bidPrice != null : !((Object)this$bidPrice).equals(other$bidPrice)) {
            return false;
        }
        BigDecimal this$bidQty = this.getBidQty();
        BigDecimal other$bidQty = other.getBidQty();
        if (this$bidQty == null ? other$bidQty != null : !((Object)this$bidQty).equals(other$bidQty)) {
            return false;
        }
        BigDecimal this$askPrice = this.getAskPrice();
        BigDecimal other$askPrice = other.getAskPrice();
        if (this$askPrice == null ? other$askPrice != null : !((Object)this$askPrice).equals(other$askPrice)) {
            return false;
        }
        BigDecimal this$askQty = this.getAskQty();
        BigDecimal other$askQty = other.getAskQty();
        if (this$askQty == null ? other$askQty != null : !((Object)this$askQty).equals(other$askQty)) {
            return false;
        }
        BigDecimal this$openPrice = this.getOpenPrice();
        BigDecimal other$openPrice = other.getOpenPrice();
        if (this$openPrice == null ? other$openPrice != null : !((Object)this$openPrice).equals(other$openPrice)) {
            return false;
        }
        BigDecimal this$highPrice = this.getHighPrice();
        BigDecimal other$highPrice = other.getHighPrice();
        if (this$highPrice == null ? other$highPrice != null : !((Object)this$highPrice).equals(other$highPrice)) {
            return false;
        }
        BigDecimal this$lowPrice = this.getLowPrice();
        BigDecimal other$lowPrice = other.getLowPrice();
        if (this$lowPrice == null ? other$lowPrice != null : !((Object)this$lowPrice).equals(other$lowPrice)) {
            return false;
        }
        BigDecimal this$volume = this.getVolume();
        BigDecimal other$volume = other.getVolume();
        if (this$volume == null ? other$volume != null : !((Object)this$volume).equals(other$volume)) {
            return false;
        }
        BigDecimal this$quoteVolume = this.getQuoteVolume();
        BigDecimal other$quoteVolume = other.getQuoteVolume();
        if (this$quoteVolume == null ? other$quoteVolume != null : !((Object)this$quoteVolume).equals(other$quoteVolume)) {
            return false;
        }
        CurrencyPair this$currencyPair = this.getCurrencyPair();
        CurrencyPair other$currencyPair = other.getCurrencyPair();
        return !(this$currencyPair == null ? other$currencyPair != null : !this$currencyPair.equals(other$currencyPair));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $openTime = this.getOpenTime();
        result = result * 59 + (int)($openTime >>> 32 ^ $openTime);
        long $closeTime = this.getCloseTime();
        result = result * 59 + (int)($closeTime >>> 32 ^ $closeTime);
        long $firstId = this.getFirstId();
        result = result * 59 + (int)($firstId >>> 32 ^ $firstId);
        long $lastId = this.getLastId();
        result = result * 59 + (int)($lastId >>> 32 ^ $lastId);
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        BigDecimal $priceChange = this.getPriceChange();
        result = result * 59 + ($priceChange == null ? 43 : ((Object)$priceChange).hashCode());
        BigDecimal $priceChangePercent = this.getPriceChangePercent();
        result = result * 59 + ($priceChangePercent == null ? 43 : ((Object)$priceChangePercent).hashCode());
        BigDecimal $weightedAvgPrice = this.getWeightedAvgPrice();
        result = result * 59 + ($weightedAvgPrice == null ? 43 : ((Object)$weightedAvgPrice).hashCode());
        BigDecimal $prevClosePrice = this.getPrevClosePrice();
        result = result * 59 + ($prevClosePrice == null ? 43 : ((Object)$prevClosePrice).hashCode());
        BigDecimal $lastPrice = this.getLastPrice();
        result = result * 59 + ($lastPrice == null ? 43 : ((Object)$lastPrice).hashCode());
        BigDecimal $lastQty = this.getLastQty();
        result = result * 59 + ($lastQty == null ? 43 : ((Object)$lastQty).hashCode());
        BigDecimal $bidPrice = this.getBidPrice();
        result = result * 59 + ($bidPrice == null ? 43 : ((Object)$bidPrice).hashCode());
        BigDecimal $bidQty = this.getBidQty();
        result = result * 59 + ($bidQty == null ? 43 : ((Object)$bidQty).hashCode());
        BigDecimal $askPrice = this.getAskPrice();
        result = result * 59 + ($askPrice == null ? 43 : ((Object)$askPrice).hashCode());
        BigDecimal $askQty = this.getAskQty();
        result = result * 59 + ($askQty == null ? 43 : ((Object)$askQty).hashCode());
        BigDecimal $openPrice = this.getOpenPrice();
        result = result * 59 + ($openPrice == null ? 43 : ((Object)$openPrice).hashCode());
        BigDecimal $highPrice = this.getHighPrice();
        result = result * 59 + ($highPrice == null ? 43 : ((Object)$highPrice).hashCode());
        BigDecimal $lowPrice = this.getLowPrice();
        result = result * 59 + ($lowPrice == null ? 43 : ((Object)$lowPrice).hashCode());
        BigDecimal $volume = this.getVolume();
        result = result * 59 + ($volume == null ? 43 : ((Object)$volume).hashCode());
        BigDecimal $quoteVolume = this.getQuoteVolume();
        result = result * 59 + ($quoteVolume == null ? 43 : ((Object)$quoteVolume).hashCode());
        CurrencyPair $currencyPair = this.getCurrencyPair();
        result = result * 59 + ($currencyPair == null ? 43 : $currencyPair.hashCode());
        return result;
    }

    public String toString() {
        return "BinanceTicker24h(priceChange=" + this.getPriceChange() + ", priceChangePercent=" + this.getPriceChangePercent() + ", weightedAvgPrice=" + this.getWeightedAvgPrice() + ", prevClosePrice=" + this.getPrevClosePrice() + ", lastPrice=" + this.getLastPrice() + ", lastQty=" + this.getLastQty() + ", bidPrice=" + this.getBidPrice() + ", bidQty=" + this.getBidQty() + ", askPrice=" + this.getAskPrice() + ", askQty=" + this.getAskQty() + ", openPrice=" + this.getOpenPrice() + ", highPrice=" + this.getHighPrice() + ", lowPrice=" + this.getLowPrice() + ", volume=" + this.getVolume() + ", quoteVolume=" + this.getQuoteVolume() + ", openTime=" + this.getOpenTime() + ", closeTime=" + this.getCloseTime() + ", firstId=" + this.getFirstId() + ", lastId=" + this.getLastId() + ", count=" + this.getCount() + ", currencyPair=" + this.getCurrencyPair() + ")";
    }

    public BinanceTicker24h(BigDecimal priceChange, BigDecimal priceChangePercent, BigDecimal weightedAvgPrice, BigDecimal prevClosePrice, BigDecimal lastPrice, BigDecimal lastQty, BigDecimal bidPrice, BigDecimal bidQty, BigDecimal askPrice, BigDecimal askQty, BigDecimal openPrice, BigDecimal highPrice, BigDecimal lowPrice, BigDecimal volume, BigDecimal quoteVolume, long openTime, long closeTime, long firstId, long lastId, long count, CurrencyPair currencyPair) {
        this.priceChange = priceChange;
        this.priceChangePercent = priceChangePercent;
        this.weightedAvgPrice = weightedAvgPrice;
        this.prevClosePrice = prevClosePrice;
        this.lastPrice = lastPrice;
        this.lastQty = lastQty;
        this.bidPrice = bidPrice;
        this.bidQty = bidQty;
        this.askPrice = askPrice;
        this.askQty = askQty;
        this.openPrice = openPrice;
        this.highPrice = highPrice;
        this.lowPrice = lowPrice;
        this.volume = volume;
        this.quoteVolume = quoteVolume;
        this.openTime = openTime;
        this.closeTime = closeTime;
        this.firstId = firstId;
        this.lastId = lastId;
        this.count = count;
        this.currencyPair = currencyPair;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class BinanceTicker24hBuilder {
        private BigDecimal priceChange;
        private BigDecimal priceChangePercent;
        private BigDecimal weightedAvgPrice;
        private BigDecimal prevClosePrice;
        private BigDecimal lastPrice;
        private BigDecimal lastQty;
        private BigDecimal bidPrice;
        private BigDecimal bidQty;
        private BigDecimal askPrice;
        private BigDecimal askQty;
        private BigDecimal openPrice;
        private BigDecimal highPrice;
        private BigDecimal lowPrice;
        private BigDecimal volume;
        private BigDecimal quoteVolume;
        private long openTime;
        private long closeTime;
        private long firstId;
        private long lastId;
        private long count;
        private CurrencyPair currencyPair;

        BinanceTicker24hBuilder() {
        }

        public BinanceTicker24hBuilder priceChange(BigDecimal priceChange) {
            this.priceChange = priceChange;
            return this;
        }

        public BinanceTicker24hBuilder priceChangePercent(BigDecimal priceChangePercent) {
            this.priceChangePercent = priceChangePercent;
            return this;
        }

        public BinanceTicker24hBuilder weightedAvgPrice(BigDecimal weightedAvgPrice) {
            this.weightedAvgPrice = weightedAvgPrice;
            return this;
        }

        public BinanceTicker24hBuilder prevClosePrice(BigDecimal prevClosePrice) {
            this.prevClosePrice = prevClosePrice;
            return this;
        }

        public BinanceTicker24hBuilder lastPrice(BigDecimal lastPrice) {
            this.lastPrice = lastPrice;
            return this;
        }

        public BinanceTicker24hBuilder lastQty(BigDecimal lastQty) {
            this.lastQty = lastQty;
            return this;
        }

        public BinanceTicker24hBuilder bidPrice(BigDecimal bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        public BinanceTicker24hBuilder bidQty(BigDecimal bidQty) {
            this.bidQty = bidQty;
            return this;
        }

        public BinanceTicker24hBuilder askPrice(BigDecimal askPrice) {
            this.askPrice = askPrice;
            return this;
        }

        public BinanceTicker24hBuilder askQty(BigDecimal askQty) {
            this.askQty = askQty;
            return this;
        }

        public BinanceTicker24hBuilder openPrice(BigDecimal openPrice) {
            this.openPrice = openPrice;
            return this;
        }

        public BinanceTicker24hBuilder highPrice(BigDecimal highPrice) {
            this.highPrice = highPrice;
            return this;
        }

        public BinanceTicker24hBuilder lowPrice(BigDecimal lowPrice) {
            this.lowPrice = lowPrice;
            return this;
        }

        public BinanceTicker24hBuilder volume(BigDecimal volume) {
            this.volume = volume;
            return this;
        }

        public BinanceTicker24hBuilder quoteVolume(BigDecimal quoteVolume) {
            this.quoteVolume = quoteVolume;
            return this;
        }

        public BinanceTicker24hBuilder openTime(long openTime) {
            this.openTime = openTime;
            return this;
        }

        public BinanceTicker24hBuilder closeTime(long closeTime) {
            this.closeTime = closeTime;
            return this;
        }

        public BinanceTicker24hBuilder firstId(long firstId) {
            this.firstId = firstId;
            return this;
        }

        public BinanceTicker24hBuilder lastId(long lastId) {
            this.lastId = lastId;
            return this;
        }

        public BinanceTicker24hBuilder count(long count) {
            this.count = count;
            return this;
        }

        @JsonProperty(value="symbol")
        @JsonDeserialize(converter=StringToCurrencyPairConverter.class)
        public BinanceTicker24hBuilder currencyPair(CurrencyPair currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public BinanceTicker24h build() {
            return new BinanceTicker24h(this.priceChange, this.priceChangePercent, this.weightedAvgPrice, this.prevClosePrice, this.lastPrice, this.lastQty, this.bidPrice, this.bidQty, this.askPrice, this.askQty, this.openPrice, this.highPrice, this.lowPrice, this.volume, this.quoteVolume, this.openTime, this.closeTime, this.firstId, this.lastId, this.count, this.currencyPair);
        }

        public String toString() {
            return "BinanceTicker24h.BinanceTicker24hBuilder(priceChange=" + this.priceChange + ", priceChangePercent=" + this.priceChangePercent + ", weightedAvgPrice=" + this.weightedAvgPrice + ", prevClosePrice=" + this.prevClosePrice + ", lastPrice=" + this.lastPrice + ", lastQty=" + this.lastQty + ", bidPrice=" + this.bidPrice + ", bidQty=" + this.bidQty + ", askPrice=" + this.askPrice + ", askQty=" + this.askQty + ", openPrice=" + this.openPrice + ", highPrice=" + this.highPrice + ", lowPrice=" + this.lowPrice + ", volume=" + this.volume + ", quoteVolume=" + this.quoteVolume + ", openTime=" + this.openTime + ", closeTime=" + this.closeTime + ", firstId=" + this.firstId + ", lastId=" + this.lastId + ", count=" + this.count + ", currencyPair=" + this.currencyPair + ")";
        }
    }
}

