/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.binance.BinanceAuthenticated;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.BinanceFuturesAuthenticated;
import org.knowm.xchange.binance.dto.meta.BinanceSystemStatus;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.BinanceExchangeInfo;
import org.knowm.xchange.binance.service.BinanceHmacDigest;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.service.BaseResilientExchangeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class BinanceBaseService
extends BaseResilientExchangeService<BinanceExchange> {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final String apiKey;
    protected final BinanceAuthenticated binance;
    protected final BinanceFuturesAuthenticated binanceFutures;
    protected final BinanceFuturesAuthenticated inverseBinanceFutures;
    protected final ParamsDigest signatureCreator;

    protected BinanceBaseService(BinanceExchange exchange, ResilienceRegistries resilienceRegistries) {
        super((Exchange)exchange, resilienceRegistries);
        ExchangeSpecification futuresSpec;
        this.binance = (BinanceAuthenticated)ExchangeRestProxyBuilder.forInterface(BinanceAuthenticated.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        ExchangeSpecification inverseFuturesSpec = futuresSpec = exchange.getDefaultExchangeSpecification();
        futuresSpec.setSslUri(exchange.usingSandbox() ? "https://testnet.binancefuture.com" : (exchange.isPortfolioMarginEnabled() ? "https://papi.binance.com" : "https://dapi.binance.com"));
        if (!exchange.isPortfolioMarginEnabled()) {
            inverseFuturesSpec.setSslUri(exchange.usingSandbox() ? "https://testnet.binancefuture.com" : "https://dapi.binance.com");
            this.inverseBinanceFutures = (BinanceFuturesAuthenticated)ExchangeRestProxyBuilder.forInterface(BinanceFuturesAuthenticated.class, (ExchangeSpecification)inverseFuturesSpec).build();
        } else {
            this.inverseBinanceFutures = null;
        }
        this.binanceFutures = (BinanceFuturesAuthenticated)ExchangeRestProxyBuilder.forInterface(BinanceFuturesAuthenticated.class, (ExchangeSpecification)futuresSpec).build();
        this.apiKey = exchange.getExchangeSpecification().getApiKey();
        this.signatureCreator = BinanceHmacDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
    }

    public Long getRecvWindow() {
        Object obj = ((BinanceExchange)this.exchange).getExchangeSpecification().getExchangeSpecificParametersItem("recvWindow");
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            long value = ((Number)obj).longValue();
            if (value < 0L || value > 60000L) {
                throw new IllegalArgumentException("Exchange-specific parameter \"recvWindow\" must be in the range [0, 60000].");
            }
            return value;
        }
        if (obj.getClass().equals(String.class)) {
            try {
                return Long.parseLong((String)obj, 10);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Exchange-specific parameter \"recvWindow\" could not be parsed.", e);
            }
        }
        throw new IllegalArgumentException("Exchange-specific parameter \"recvWindow\" could not be parsed.");
    }

    public SynchronizedValueFactory<Long> getTimestampFactory() {
        return ((BinanceExchange)this.exchange).getTimestampFactory();
    }

    public BinanceExchangeInfo getExchangeInfo() throws IOException {
        return (BinanceExchangeInfo)this.decorateApiCall(this.binance::exchangeInfo).withRetry(this.retry("exchangeInfo")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceExchangeInfo getFutureExchangeInfo() throws IOException {
        return (BinanceExchangeInfo)this.decorateApiCall(this.binanceFutures::exchangeInfo).withRetry(this.retry("exchangeInfo")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceSystemStatus getSystemStatus() throws IOException {
        return (BinanceSystemStatus)this.decorateApiCall(this.binance::systemStatus).call();
    }
}

