/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.knowm.xchange.binance.dto.account.WapiResponse;

public final class DepositList
extends WapiResponse<List<BinanceDeposit>> {
    private final BinanceDeposit[] depositList;

    public DepositList(@JsonProperty(value="depositList") BinanceDeposit[] depositList, @JsonProperty(value="success") boolean success, @JsonProperty(value="msg") String msg) {
        super(success, msg);
        this.depositList = depositList;
    }

    @Override
    public List<BinanceDeposit> getData() {
        return Arrays.asList(this.depositList);
    }

    public String toString() {
        return "DepositList [depositList=" + Arrays.toString(this.depositList) + "]";
    }

    public static final class BinanceDeposit {
        private long insertTime;
        private BigDecimal amount;
        private String asset;
        private String txId;
        private String address;
        private String addressTag;
        private int status;

        public long getInsertTime() {
            return this.insertTime;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public String getAsset() {
            return this.asset;
        }

        public String getTxId() {
            return this.txId;
        }

        public String getAddress() {
            return this.address;
        }

        public String getAddressTag() {
            return this.addressTag;
        }

        public int getStatus() {
            return this.status;
        }

        public void setInsertTime(long insertTime) {
            this.insertTime = insertTime;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public void setAsset(String asset) {
            this.asset = asset;
        }

        public void setTxId(String txId) {
            this.txId = txId;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setAddressTag(String addressTag) {
            this.addressTag = addressTag;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BinanceDeposit)) {
                return false;
            }
            BinanceDeposit other = (BinanceDeposit)o;
            if (this.getInsertTime() != other.getInsertTime()) {
                return false;
            }
            if (this.getStatus() != other.getStatus()) {
                return false;
            }
            BigDecimal this$amount = this.getAmount();
            BigDecimal other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$asset = this.getAsset();
            String other$asset = other.getAsset();
            if (this$asset == null ? other$asset != null : !this$asset.equals(other$asset)) {
                return false;
            }
            String this$txId = this.getTxId();
            String other$txId = other.getTxId();
            if (this$txId == null ? other$txId != null : !this$txId.equals(other$txId)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$addressTag = this.getAddressTag();
            String other$addressTag = other.getAddressTag();
            return !(this$addressTag == null ? other$addressTag != null : !this$addressTag.equals(other$addressTag));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $insertTime = this.getInsertTime();
            result = result * 59 + (int)($insertTime >>> 32 ^ $insertTime);
            result = result * 59 + this.getStatus();
            BigDecimal $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $asset = this.getAsset();
            result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
            String $txId = this.getTxId();
            result = result * 59 + ($txId == null ? 43 : $txId.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $addressTag = this.getAddressTag();
            result = result * 59 + ($addressTag == null ? 43 : $addressTag.hashCode());
            return result;
        }

        public String toString() {
            return "DepositList.BinanceDeposit(insertTime=" + this.getInsertTime() + ", amount=" + this.getAmount() + ", asset=" + this.getAsset() + ", txId=" + this.getTxId() + ", address=" + this.getAddress() + ", addressTag=" + this.getAddressTag() + ", status=" + this.getStatus() + ")";
        }
    }
}

