/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.trade.BinanceCancelledOrder;
import org.knowm.xchange.binance.dto.trade.BinanceListenKey;
import org.knowm.xchange.binance.dto.trade.BinanceNewOrder;
import org.knowm.xchange.binance.dto.trade.BinanceOrder;
import org.knowm.xchange.binance.dto.trade.BinanceTrade;
import org.knowm.xchange.binance.dto.trade.OrderSide;
import org.knowm.xchange.binance.dto.trade.OrderType;
import org.knowm.xchange.binance.dto.trade.TimeInForce;
import org.knowm.xchange.binance.service.BinanceBaseService;
import org.knowm.xchange.currency.CurrencyPair;

public class BinanceTradeServiceRaw
extends BinanceBaseService {
    protected BinanceTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public List<BinanceOrder> openOrders(Long recvWindow, long timestamp) throws BinanceException, IOException {
        return this.binance.openOrders(null, recvWindow, timestamp, this.apiKey, this.signatureCreator);
    }

    public List<BinanceOrder> openOrders(CurrencyPair pair, Long recvWindow, long timestamp) throws BinanceException, IOException {
        return this.binance.openOrders(BinanceAdapters.toSymbol(pair), recvWindow, timestamp, this.apiKey, this.signatureCreator);
    }

    public BinanceNewOrder newOrder(CurrencyPair pair, OrderSide side, OrderType type, TimeInForce timeInForce, BigDecimal quantity, BigDecimal price, String newClientOrderId, BigDecimal stopPrice, BigDecimal icebergQty, Long recvWindow, long timestamp) throws IOException, BinanceException {
        return this.binance.newOrder(BinanceAdapters.toSymbol(pair), side, type, timeInForce, quantity, price, newClientOrderId, stopPrice, icebergQty, recvWindow, timestamp, this.apiKey, this.signatureCreator);
    }

    public void testNewOrder(CurrencyPair pair, OrderSide side, OrderType type, TimeInForce timeInForce, BigDecimal quantity, BigDecimal price, String newClientOrderId, BigDecimal stopPrice, BigDecimal icebergQty, Long recvWindow, long timestamp) throws IOException, BinanceException {
        this.binance.testNewOrder(BinanceAdapters.toSymbol(pair), side, type, timeInForce, quantity, price, newClientOrderId, stopPrice, icebergQty, recvWindow, timestamp, this.apiKey, this.signatureCreator);
    }

    public BinanceOrder orderStatus(CurrencyPair pair, long orderId, String origClientOrderId, Long recvWindow, long timestamp) throws IOException, BinanceException {
        return this.binance.orderStatus(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, recvWindow, timestamp, this.apiKey, this.signatureCreator);
    }

    public BinanceCancelledOrder cancelOrder(CurrencyPair pair, long orderId, String origClientOrderId, String newClientOrderId, Long recvWindow, long timestamp) throws IOException, BinanceException {
        return this.binance.cancelOrder(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, newClientOrderId, recvWindow, timestamp, this.apiKey, this.signatureCreator);
    }

    public List<BinanceOrder> allOrders(CurrencyPair pair, Long orderId, Integer limit, Long recvWindow, long timestamp) throws BinanceException, IOException {
        return this.binance.allOrders(BinanceAdapters.toSymbol(pair), orderId, limit, recvWindow, timestamp, this.apiKey, this.signatureCreator);
    }

    public List<BinanceTrade> myTrades(CurrencyPair pair, Integer limit, Long fromId, Long recvWindow, long timestamp) throws BinanceException, IOException {
        return this.binance.myTrades(BinanceAdapters.toSymbol(pair), limit, fromId, recvWindow, timestamp, this.apiKey, this.signatureCreator);
    }

    public BinanceListenKey startUserDataStream() throws IOException {
        return this.binance.startUserDataStream(this.apiKey);
    }

    public void keepAliveDataStream(String listenKey) throws IOException {
        this.binance.keepAliveUserDataStream(this.apiKey, listenKey);
    }

    public void closeDataStream(String listenKey) throws IOException {
        this.binance.closeUserDataStream(this.apiKey, listenKey);
    }
}

