/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.binance.Binance;
import org.knowm.xchange.binance.dto.marketdata.BinancePrice;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.BinanceExchangeInfo;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.Filter;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.Symbol;
import org.knowm.xchange.binance.service.BinanceAccountService;
import org.knowm.xchange.binance.service.BinanceMarketDataService;
import org.knowm.xchange.binance.service.BinanceTradeService;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.utils.AuthUtils;
import org.knowm.xchange.utils.nonce.AtomicLongCurrentTimeIncrementalNonceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.RestProxyFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class BinanceExchange
extends BaseExchange {
    private static final Logger LOG = LoggerFactory.getLogger(BinanceExchange.class);
    private static final int DEFAULT_PRECISION = 8;
    private SynchronizedValueFactory<Long> nonceFactory = new AtomicLongCurrentTimeIncrementalNonceFactory();
    private BinanceExchangeInfo exchangeInfo;
    private Long deltaServerTimeExpire;
    private Long deltaServerTime;

    protected void initServices() {
        this.marketDataService = new BinanceMarketDataService((Exchange)this);
        this.tradeService = new BinanceTradeService((Exchange)this);
        this.accountService = new BinanceAccountService((Exchange)this);
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification spec = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        spec.setSslUri("https://api.binance.com");
        spec.setHost("www.binance.com");
        spec.setPort(80);
        spec.setExchangeName("Binance");
        spec.setExchangeDescription("Binance Exchange.");
        AuthUtils.setApiAndSecretKey((ExchangeSpecification)spec, (String)"binance");
        return spec;
    }

    public BinanceExchangeInfo getExchangeInfo() {
        return this.exchangeInfo;
    }

    public void remoteInit() {
        try {
            Map currencyPairs = this.exchangeMetaData.getCurrencyPairs();
            Map currencies = this.exchangeMetaData.getCurrencies();
            BinanceMarketDataService marketDataService = (BinanceMarketDataService)this.marketDataService;
            this.exchangeInfo = marketDataService.getExchangeInfo();
            Symbol[] symbols = this.exchangeInfo.getSymbols();
            for (BinancePrice price : marketDataService.tickerAllPrices()) {
                CurrencyPair pair = price.getCurrencyPair();
                for (Symbol symbol : symbols) {
                    Filter[] filters;
                    if (!symbol.getSymbol().equals(pair.base.getCurrencyCode() + pair.counter.getCurrencyCode())) continue;
                    int basePrecision = Integer.parseInt(symbol.getBaseAssetPrecision());
                    int counterPrecision = Integer.parseInt(symbol.getQuotePrecision());
                    int pairPrecision = 8;
                    int amountPrecision = 8;
                    BigDecimal minQty = null;
                    BigDecimal maxQty = null;
                    for (Filter filter : filters = symbol.getFilters()) {
                        if (filter.getFilterType().equals("PRICE_FILTER")) {
                            pairPrecision = Math.min(pairPrecision, this.numberOfDecimals(filter.getTickSize()));
                            continue;
                        }
                        if (!filter.getFilterType().equals("LOT_SIZE")) continue;
                        amountPrecision = Math.min(amountPrecision, this.numberOfDecimals(filter.getMinQty()));
                        minQty = new BigDecimal(filter.getMinQty()).stripTrailingZeros();
                        maxQty = new BigDecimal(filter.getMaxQty()).stripTrailingZeros();
                    }
                    currencyPairs.put(price.getCurrencyPair(), new CurrencyPairMetaData(new BigDecimal("0.1"), minQty, maxQty, Integer.valueOf(pairPrecision), null));
                    currencies.put(pair.base, new CurrencyMetaData(Integer.valueOf(basePrecision), currencies.containsKey(pair.base) ? ((CurrencyMetaData)currencies.get(pair.base)).getWithdrawalFee() : null));
                    currencies.put(pair.counter, new CurrencyMetaData(Integer.valueOf(counterPrecision), currencies.containsKey(pair.counter) ? ((CurrencyMetaData)currencies.get(pair.counter)).getWithdrawalFee() : null));
                }
            }
        }
        catch (Exception e) {
            throw new ExchangeException("Failed to initialize: " + e.getMessage(), (Throwable)e);
        }
    }

    private int numberOfDecimals(String value) {
        return new BigDecimal(value).stripTrailingZeros().scale();
    }

    public void clearDeltaServerTime() {
        this.deltaServerTime = null;
    }

    public long deltaServerTime() throws IOException {
        if (this.deltaServerTime == null || this.deltaServerTimeExpire <= System.currentTimeMillis()) {
            Binance binance = (Binance)RestProxyFactory.createProxy(Binance.class, (String)this.getExchangeSpecification().getSslUri());
            Date serverTime = new Date(binance.time().getServerTime().getTime());
            Date systemTime = new Date(System.currentTimeMillis());
            this.deltaServerTimeExpire = systemTime.getTime() + TimeUnit.MINUTES.toMillis(10L);
            this.deltaServerTime = serverTime.getTime() - systemTime.getTime();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            LOG.trace("deltaServerTime: {} - {} => {}", new Object[]{df.format(serverTime), df.format(systemTime), this.deltaServerTime});
        }
        return this.deltaServerTime;
    }
}

