/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.binance.Binance;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.account.BinanceAccountInformation;
import org.knowm.xchange.binance.dto.account.DepositAddress;
import org.knowm.xchange.binance.dto.account.DepositList;
import org.knowm.xchange.binance.dto.account.WithdrawList;
import org.knowm.xchange.binance.dto.account.WithdrawRequest;
import org.knowm.xchange.binance.dto.trade.BinanceCancelledOrder;
import org.knowm.xchange.binance.dto.trade.BinanceListenKey;
import org.knowm.xchange.binance.dto.trade.BinanceNewOrder;
import org.knowm.xchange.binance.dto.trade.BinanceOrder;
import org.knowm.xchange.binance.dto.trade.BinanceTrade;
import org.knowm.xchange.binance.dto.trade.OrderSide;
import org.knowm.xchange.binance.dto.trade.OrderType;
import org.knowm.xchange.binance.dto.trade.TimeInForce;
import si.mazi.rescu.ParamsDigest;

@Path(value="")
@Produces(value={"application/json"})
public interface BinanceAuthenticated
extends Binance {
    public static final String SIGNATURE = "signature";
    public static final String X_MBX_APIKEY = "X-MBX-APIKEY";

    @POST
    @Path(value="api/v3/order")
    public BinanceNewOrder newOrder(@FormParam(value="symbol") String var1, @FormParam(value="side") OrderSide var2, @FormParam(value="type") OrderType var3, @FormParam(value="timeInForce") TimeInForce var4, @FormParam(value="quantity") BigDecimal var5, @FormParam(value="price") BigDecimal var6, @FormParam(value="newClientOrderId") String var7, @FormParam(value="stopPrice") BigDecimal var8, @FormParam(value="icebergQty") BigDecimal var9, @FormParam(value="recvWindow") Long var10, @FormParam(value="timestamp") long var11, @HeaderParam(value="X-MBX-APIKEY") String var13, @QueryParam(value="signature") ParamsDigest var14) throws IOException, BinanceException;

    @POST
    @Path(value="api/v3/order/test")
    public Object testNewOrder(@FormParam(value="symbol") String var1, @FormParam(value="side") OrderSide var2, @FormParam(value="type") OrderType var3, @FormParam(value="timeInForce") TimeInForce var4, @FormParam(value="quantity") BigDecimal var5, @FormParam(value="price") BigDecimal var6, @FormParam(value="newClientOrderId") String var7, @FormParam(value="stopPrice") BigDecimal var8, @FormParam(value="icebergQty") BigDecimal var9, @FormParam(value="recvWindow") Long var10, @FormParam(value="timestamp") long var11, @HeaderParam(value="X-MBX-APIKEY") String var13, @QueryParam(value="signature") ParamsDigest var14) throws IOException, BinanceException;

    @GET
    @Path(value="api/v3/order")
    public BinanceOrder orderStatus(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") long var2, @QueryParam(value="origClientOrderId") String var4, @QueryParam(value="recvWindow") Long var5, @QueryParam(value="timestamp") long var6, @HeaderParam(value="X-MBX-APIKEY") String var8, @QueryParam(value="signature") ParamsDigest var9) throws IOException, BinanceException;

    @DELETE
    @Path(value="api/v3/order")
    public BinanceCancelledOrder cancelOrder(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") long var2, @QueryParam(value="origClientOrderId") String var4, @QueryParam(value="newClientOrderId") String var5, @QueryParam(value="recvWindow") Long var6, @QueryParam(value="timestamp") long var7, @HeaderParam(value="X-MBX-APIKEY") String var9, @QueryParam(value="signature") ParamsDigest var10) throws IOException, BinanceException;

    @GET
    @Path(value="api/v3/openOrders")
    public List<BinanceOrder> openOrders(@QueryParam(value="symbol") String var1, @QueryParam(value="recvWindow") Long var2, @QueryParam(value="timestamp") long var3, @HeaderParam(value="X-MBX-APIKEY") String var5, @QueryParam(value="signature") ParamsDigest var6) throws IOException, BinanceException;

    @GET
    @Path(value="api/v3/openOrders")
    public List<BinanceOrder> openOrders(@QueryParam(value="recvWindow") Long var1, @QueryParam(value="timestamp") long var2, @HeaderParam(value="X-MBX-APIKEY") String var4, @QueryParam(value="signature") ParamsDigest var5) throws IOException, BinanceException;

    @GET
    @Path(value="api/v3/allOrders")
    public List<BinanceOrder> allOrders(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") Long var2, @QueryParam(value="limit") Integer var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") long var5, @HeaderParam(value="X-MBX-APIKEY") String var7, @QueryParam(value="signature") ParamsDigest var8) throws IOException, BinanceException;

    @GET
    @Path(value="api/v3/account")
    public BinanceAccountInformation account(@QueryParam(value="recvWindow") Long var1, @QueryParam(value="timestamp") long var2, @HeaderParam(value="X-MBX-APIKEY") String var4, @QueryParam(value="signature") ParamsDigest var5) throws IOException, BinanceException;

    @GET
    @Path(value="api/v3/myTrades")
    public List<BinanceTrade> myTrades(@QueryParam(value="symbol") String var1, @QueryParam(value="limit") Integer var2, @QueryParam(value="fromId") Long var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") long var5, @HeaderParam(value="X-MBX-APIKEY") String var7, @QueryParam(value="signature") ParamsDigest var8) throws IOException, BinanceException;

    @POST
    @Path(value="wapi/v3/withdraw.html")
    public WithdrawRequest withdraw(@FormParam(value="asset") String var1, @FormParam(value="address") String var2, @FormParam(value="addressTag") String var3, @FormParam(value="amount") BigDecimal var4, @FormParam(value="name") String var5, @FormParam(value="recvWindow") Long var6, @FormParam(value="timestamp") long var7, @HeaderParam(value="X-MBX-APIKEY") String var9, @QueryParam(value="signature") ParamsDigest var10) throws IOException, BinanceException;

    @GET
    @Path(value="wapi/v3/depositHistory.html")
    public DepositList depositHistory(@QueryParam(value="asset") String var1, @QueryParam(value="startTime") Long var2, @QueryParam(value="endTime") Long var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") long var5, @HeaderParam(value="X-MBX-APIKEY") String var7, @QueryParam(value="signature") ParamsDigest var8) throws IOException, BinanceException;

    @GET
    @Path(value="wapi/v3/withdrawHistory.html")
    public WithdrawList withdrawHistory(@QueryParam(value="asset") String var1, @QueryParam(value="startTime") Long var2, @QueryParam(value="endTime") Long var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") long var5, @HeaderParam(value="X-MBX-APIKEY") String var7, @QueryParam(value="signature") ParamsDigest var8) throws IOException, BinanceException;

    @GET
    @Path(value="wapi/v3/depositAddress.html")
    public DepositAddress depositAddress(@QueryParam(value="asset") String var1, @QueryParam(value="recvWindow") Long var2, @QueryParam(value="timestamp") long var3, @HeaderParam(value="X-MBX-APIKEY") String var5, @QueryParam(value="signature") ParamsDigest var6) throws IOException, BinanceException;

    @POST
    @Path(value="/api/v1/userDataStream")
    public BinanceListenKey startUserDataStream(@HeaderParam(value="X-MBX-APIKEY") String var1) throws IOException, BinanceException;

    @PUT
    @Path(value="/api/v1/userDataStream?listenKey={listenKey}")
    public Map<?, ?> keepAliveUserDataStream(@HeaderParam(value="X-MBX-APIKEY") String var1, @PathParam(value="listenKey") String var2) throws IOException, BinanceException;

    @DELETE
    @Path(value="/api/v1/userDataStream?listenKey={listenKey}")
    public Map<?, ?> closeUserDataStream(@HeaderParam(value="X-MBX-APIKEY") String var1, @PathParam(value="listenKey") String var2) throws IOException, BinanceException;
}

