/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import org.knowm.xchange.binance.dto.trade.BinanceOrder;
import org.knowm.xchange.binance.dto.trade.OrderSide;
import org.knowm.xchange.binance.dto.trade.OrderStatus;
import org.knowm.xchange.binance.dto.trade.OrderType;
import org.knowm.xchange.binance.service.BinanceTradeService;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.StopOrder;

public class BinanceAdapters {
    private BinanceAdapters() {
    }

    public static String toSymbol(CurrencyPair pair) {
        if (pair.equals((Object)CurrencyPair.IOTA_BTC)) {
            return "IOTABTC";
        }
        return pair.base.getCurrencyCode() + pair.counter.getCurrencyCode();
    }

    public static String toSymbol(Currency currency) {
        if (Currency.IOT.equals((Object)currency)) {
            return "IOTA";
        }
        return currency.getSymbol();
    }

    public static Order.OrderType convert(OrderSide side) {
        switch (side) {
            case BUY: {
                return Order.OrderType.BID;
            }
            case SELL: {
                return Order.OrderType.ASK;
            }
        }
        throw new RuntimeException("Not supported order side: " + (Object)((Object)side));
    }

    public static OrderSide convert(Order.OrderType type) {
        switch (type) {
            case ASK: {
                return OrderSide.SELL;
            }
            case BID: {
                return OrderSide.BUY;
            }
        }
        throw new RuntimeException("Not supported order type: " + type);
    }

    public static CurrencyPair convert(String symbol) {
        for (Currency base : Arrays.asList(Currency.BTC, Currency.ETH, Currency.BNB, Currency.USDT)) {
            if (!symbol.contains(base.toString())) continue;
            String counter = symbol.replace(base.toString(), "");
            return new CurrencyPair(base, new Currency(counter));
        }
        throw new IllegalArgumentException("Could not parse currency pair from '" + symbol + "'");
    }

    public static long id(String id) {
        try {
            return Long.valueOf(id);
        }
        catch (Throwable e) {
            throw new RuntimeException("Binance id must be a valid long number.", e);
        }
    }

    public static Order.OrderStatus adaptOrderStatus(OrderStatus orderStatus) {
        switch (orderStatus) {
            case NEW: {
                return Order.OrderStatus.NEW;
            }
            case FILLED: {
                return Order.OrderStatus.FILLED;
            }
            case EXPIRED: {
                return Order.OrderStatus.EXPIRED;
            }
            case CANCELED: {
                return Order.OrderStatus.CANCELED;
            }
            case REJECTED: {
                return Order.OrderStatus.REJECTED;
            }
            case PENDING_CANCEL: {
                return Order.OrderStatus.PENDING_CANCEL;
            }
            case PARTIALLY_FILLED: {
                return Order.OrderStatus.PARTIALLY_FILLED;
            }
        }
        return Order.OrderStatus.UNKNOWN;
    }

    public static Order.OrderType convertType(boolean isBuyer) {
        return isBuyer ? Order.OrderType.BID : Order.OrderType.ASK;
    }

    public static CurrencyPair adaptSymbol(String symbol) {
        int pairLength = symbol.length();
        if (symbol.endsWith("USDT")) {
            return new CurrencyPair(symbol.substring(0, pairLength - 4), "USDT");
        }
        return new CurrencyPair(symbol.substring(0, pairLength - 3), symbol.substring(pairLength - 3));
    }

    public static Order adaptOrder(final BinanceOrder order) {
        Order.OrderType type = BinanceAdapters.convert(order.side);
        CurrencyPair currencyPair = BinanceAdapters.adaptSymbol(order.symbol);
        Order.OrderStatus orderStatus = BinanceAdapters.adaptOrderStatus(order.status);
        BigDecimal averagePrice = order.executedQty.signum() == 0 || order.type.equals((Object)OrderType.MARKET) ? BigDecimal.ZERO : order.price;
        Object result = order.type.equals((Object)OrderType.MARKET) ? new MarketOrder(type, order.origQty, currencyPair, Long.toString(order.orderId), order.getTime(), averagePrice, order.executedQty, BigDecimal.ZERO, orderStatus) : (order.type.equals((Object)OrderType.LIMIT) || order.type.equals((Object)OrderType.LIMIT_MAKER) ? new LimitOrder(type, order.origQty, currencyPair, Long.toString(order.orderId), order.getTime(), order.price, averagePrice, order.executedQty, BigDecimal.ZERO, orderStatus) : new StopOrder(type, order.origQty, currencyPair, Long.toString(order.orderId), order.getTime(), order.stopPrice, averagePrice, order.executedQty, orderStatus));
        HashSet<1> flags = new HashSet<1>();
        if (order.clientOrderId != null) {
            flags.add(new BinanceTradeService.BinanceOrderFlags(){

                @Override
                public String getClientId() {
                    return order.clientOrderId;
                }
            });
        }
        result.setOrderFlags(flags);
        return result;
    }
}

