/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.util.bookend;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConsulBookendContext {
    private Map<String, Object> data;

    ConsulBookendContext() {
    }

    public void put(String key, Object value) {
        if (Objects.isNull(this.data)) {
            this.data = new HashMap<String, Object>();
        }
        this.data.put(key, value);
    }

    public <T> Optional<T> get(String key, Class<T> klazz) {
        if (Objects.isNull(this.data) || !this.data.containsKey(key)) {
            return Optional.empty();
        }
        Object object = this.data.get(key);
        if (Objects.isNull(object)) {
            return Optional.empty();
        }
        Preconditions.checkState((boolean)klazz.isAssignableFrom(object.getClass()), (String)"Data for key '%s' is not of type: %s", (Object)key, (Object)klazz.getName());
        T castObject = klazz.cast(object);
        return Optional.of(castObject);
    }
}

