/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.consul.util.UncheckedMalformedURLException;
import org.kiwiproject.consul.util.UncheckedURISyntaxException;

public class Urls {
    private Urls() {
    }

    public static URL newUrl(String urlString) {
        try {
            return new URI(urlString).toURL();
        }
        catch (URISyntaxException e) {
            throw new UncheckedURISyntaxException(e);
        }
        catch (MalformedURLException e) {
            throw new UncheckedMalformedURLException(e);
        }
    }

    public static URL newUrl(String scheme, String host, int port) {
        return Urls.newUrl(scheme, host, port, null);
    }

    public static URL newUrl(String scheme, String host, int port, @Nullable String file) {
        try {
            URI base = new URI(scheme, null, host, port, null, null, null);
            if (StringUtils.isBlank((CharSequence)file)) {
                return base.toURL();
            }
            return base.resolve(file).toURL();
        }
        catch (URISyntaxException e) {
            throw new UncheckedURISyntaxException(e);
        }
        catch (MalformedURLException e) {
            throw new UncheckedMalformedURLException(e);
        }
    }
}

