/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.option.ParamAdder;
import org.kiwiproject.consul.option.PutOptions;

@Generated(from="PutOptions", generator="Immutables")
public final class ImmutablePutOptions
extends PutOptions {
    private final ImmutableList<String> toQueryParameters;
    private final ImmutableMap<String, String> toHeaders;
    @Nullable
    private final Long cas;
    @Nullable
    private final String acquire;
    @Nullable
    private final String release;
    @Nullable
    private final String dc;
    @Nullable
    private final String token;

    private ImmutablePutOptions(ImmutableList<String> toQueryParameters, ImmutableMap<String, String> toHeaders, @Nullable Long cas, @Nullable String acquire, @Nullable String release, @Nullable String dc, @Nullable String token) {
        this.toQueryParameters = toQueryParameters;
        this.toHeaders = toHeaders;
        this.cas = cas;
        this.acquire = acquire;
        this.release = release;
        this.dc = dc;
        this.token = token;
    }

    public ImmutableList<String> toQueryParameters() {
        return this.toQueryParameters;
    }

    public ImmutableMap<String, String> toHeaders() {
        return this.toHeaders;
    }

    @Override
    public Optional<Long> getCas() {
        return Optional.ofNullable(this.cas);
    }

    @Override
    public Optional<String> getAcquire() {
        return Optional.ofNullable(this.acquire);
    }

    @Override
    public Optional<String> getRelease() {
        return Optional.ofNullable(this.release);
    }

    @Override
    public Optional<String> getDc() {
        return Optional.ofNullable(this.dc);
    }

    @Override
    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    public final ImmutablePutOptions withToQueryParameters(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutablePutOptions((ImmutableList<String>)newValue, this.toHeaders, this.cas, this.acquire, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withToQueryParameters(Iterable<String> elements) {
        if (this.toQueryParameters == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutablePutOptions((ImmutableList<String>)newValue, this.toHeaders, this.cas, this.acquire, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withToHeaders(Map<String, ? extends String> entries) {
        if (this.toHeaders == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutablePutOptions(this.toQueryParameters, (ImmutableMap<String, String>)newValue, this.cas, this.acquire, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withCas(long value) {
        Long newValue = value;
        if (Objects.equals(this.cas, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.toQueryParameters, this.toHeaders, newValue, this.acquire, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withCas(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.cas, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.toQueryParameters, this.toHeaders, value, this.acquire, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withAcquire(String value) {
        String newValue = Objects.requireNonNull(value, "acquire");
        if (Objects.equals(this.acquire, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.toQueryParameters, this.toHeaders, this.cas, newValue, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withAcquire(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.acquire, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.toQueryParameters, this.toHeaders, this.cas, value, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withRelease(String value) {
        String newValue = Objects.requireNonNull(value, "release");
        if (Objects.equals(this.release, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.toQueryParameters, this.toHeaders, this.cas, this.acquire, newValue, this.dc, this.token);
    }

    public final ImmutablePutOptions withRelease(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.release, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.toQueryParameters, this.toHeaders, this.cas, this.acquire, value, this.dc, this.token);
    }

    public final ImmutablePutOptions withDc(String value) {
        String newValue = Objects.requireNonNull(value, "dc");
        if (Objects.equals(this.dc, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.toQueryParameters, this.toHeaders, this.cas, this.acquire, this.release, newValue, this.token);
    }

    public final ImmutablePutOptions withDc(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.dc, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.toQueryParameters, this.toHeaders, this.cas, this.acquire, this.release, value, this.token);
    }

    public final ImmutablePutOptions withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (Objects.equals(this.token, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.toQueryParameters, this.toHeaders, this.cas, this.acquire, this.release, this.dc, newValue);
    }

    public final ImmutablePutOptions withToken(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.toQueryParameters, this.toHeaders, this.cas, this.acquire, this.release, this.dc, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePutOptions && this.equalsByValue((ImmutablePutOptions)another);
    }

    private boolean equalsByValue(ImmutablePutOptions another) {
        return this.toQueryParameters.equals(another.toQueryParameters) && this.toHeaders.equals(another.toHeaders) && Objects.equals(this.cas, another.cas) && Objects.equals(this.acquire, another.acquire) && Objects.equals(this.release, another.release) && Objects.equals(this.dc, another.dc) && Objects.equals(this.token, another.token);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.toQueryParameters.hashCode();
        h += (h << 5) + this.toHeaders.hashCode();
        h += (h << 5) + Objects.hashCode(this.cas);
        h += (h << 5) + Objects.hashCode(this.acquire);
        h += (h << 5) + Objects.hashCode(this.release);
        h += (h << 5) + Objects.hashCode(this.dc);
        h += (h << 5) + Objects.hashCode(this.token);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PutOptions").omitNullValues().add("toQueryParameters", this.toQueryParameters).add("toHeaders", this.toHeaders).add("cas", (Object)this.cas).add("acquire", (Object)this.acquire).add("release", (Object)this.release).add("dc", (Object)this.dc).add("token", (Object)this.token).toString();
    }

    public static ImmutablePutOptions copyOf(PutOptions instance) {
        if (instance instanceof ImmutablePutOptions) {
            return (ImmutablePutOptions)instance;
        }
        return ImmutablePutOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PutOptions", generator="Immutables")
    public static final class Builder {
        private ImmutableList.Builder<String> toQueryParameters = ImmutableList.builder();
        private ImmutableMap.Builder<String, String> toHeaders = ImmutableMap.builder();
        @Nullable
        private Long cas;
        @Nullable
        private String acquire;
        @Nullable
        private String release;
        @Nullable
        private String dc;
        @Nullable
        private String token;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ParamAdder instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PutOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            ParamAdder instance;
            long bits = 0L;
            if (object instanceof ParamAdder) {
                instance = (ParamAdder)object;
                this.addAllToQueryParameters(instance.toQueryParameters());
                this.putAllToHeaders(instance.toHeaders());
            }
            if (object instanceof PutOptions) {
                Optional<String> dcOptional;
                Optional<String> tokenOptional;
                Optional<String> releaseOptional;
                Optional<String> acquireOptional;
                instance = (PutOptions)object;
                Optional<Long> casOptional = ((PutOptions)instance).getCas();
                if (casOptional.isPresent()) {
                    this.cas(casOptional);
                }
                if ((acquireOptional = ((PutOptions)instance).getAcquire()).isPresent()) {
                    this.acquire(acquireOptional);
                }
                if ((releaseOptional = ((PutOptions)instance).getRelease()).isPresent()) {
                    this.release(releaseOptional);
                }
                if ((tokenOptional = ((PutOptions)instance).getToken()).isPresent()) {
                    this.token(tokenOptional);
                }
                if ((dcOptional = ((PutOptions)instance).getDc()).isPresent()) {
                    this.dc(dcOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String element) {
            this.toQueryParameters.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String ... elements) {
            this.toQueryParameters.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toQueryParameters(Iterable<String> elements) {
            this.toQueryParameters = ImmutableList.builder();
            return this.addAllToQueryParameters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllToQueryParameters(Iterable<String> elements) {
            this.toQueryParameters.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(String key, String value) {
            this.toHeaders.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(Map.Entry<String, ? extends String> entry) {
            this.toHeaders.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toHeaders(Map<String, ? extends String> entries) {
            this.toHeaders = ImmutableMap.builder();
            return this.putAllToHeaders(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllToHeaders(Map<String, ? extends String> entries) {
            this.toHeaders.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cas(long cas) {
            this.cas = cas;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cas(Optional<Long> cas) {
            this.cas = cas.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder acquire(String acquire) {
            this.acquire = Objects.requireNonNull(acquire, "acquire");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder acquire(Optional<String> acquire) {
            this.acquire = acquire.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder release(String release) {
            this.release = Objects.requireNonNull(release, "release");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder release(Optional<String> release) {
            this.release = release.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dc(String dc) {
            this.dc = Objects.requireNonNull(dc, "dc");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dc(Optional<String> dc) {
            this.dc = dc.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(Optional<String> token) {
            this.token = token.orElse(null);
            return this;
        }

        public ImmutablePutOptions build() {
            return new ImmutablePutOptions((ImmutableList<String>)this.toQueryParameters.build(), (ImmutableMap<String, String>)this.toHeaders.build(), this.cas, this.acquire, this.release, this.dc, this.token);
        }
    }
}

