/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.acl.Token;

@Generated(from="Token.NodeIdentity", generator="Immutables")
public final class ImmutableNodeIdentity
extends Token.NodeIdentity {
    private final String name;
    private final String datacenter;

    private ImmutableNodeIdentity(String name, String datacenter) {
        this.name = name;
        this.datacenter = datacenter;
    }

    @Override
    @JsonProperty(value="NodeName")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public String datacenter() {
        return this.datacenter;
    }

    public final ImmutableNodeIdentity withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeIdentity(newValue, this.datacenter);
    }

    public final ImmutableNodeIdentity withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (this.datacenter.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeIdentity(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeIdentity && this.equalsByValue((ImmutableNodeIdentity)another);
    }

    private boolean equalsByValue(ImmutableNodeIdentity another) {
        return this.name.equals(another.name) && this.datacenter.equals(another.datacenter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.datacenter.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NodeIdentity").omitNullValues().add("name", (Object)this.name).add("datacenter", (Object)this.datacenter).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNodeIdentity fromJson(Json json) {
        Builder builder = ImmutableNodeIdentity.builder();
        if (json._name != null) {
            builder.name(json._name);
        }
        if (json._datacenter != null) {
            builder.datacenter(json._datacenter);
        }
        return builder.build();
    }

    public static ImmutableNodeIdentity copyOf(Token.NodeIdentity instance) {
        if (instance instanceof ImmutableNodeIdentity) {
            return (ImmutableNodeIdentity)instance;
        }
        return ImmutableNodeIdentity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Token.NodeIdentity", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_DATACENTER = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String datacenter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Token.NodeIdentity instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.datacenter(instance.datacenter());
            return this;
        }

        @JsonProperty(value="NodeName")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Datacenter")
        @CanIgnoreReturnValue
        public final Builder datacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableNodeIdentity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeIdentity(this.name, this.datacenter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("datacenter");
            }
            return "Cannot build NodeIdentity, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="Token.NodeIdentity", generator="Immutables")
    static final class Json
    extends Token.NodeIdentity {
        @JsonIgnore
        @Nullable
        String _name;
        @JsonIgnore
        @Nullable
        String _datacenter;

        Json() {
        }

        @JsonProperty(value="NodeName")
        public void setName(String name) {
            this._name = name;
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(String datacenter) {
            this._datacenter = datacenter;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String datacenter() {
            throw new UnsupportedOperationException();
        }
    }
}

