/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.option.ParamAdder;
import org.kiwiproject.consul.option.RoleOptions;

@Generated(from="RoleOptions", generator="Immutables")
public final class ImmutableRoleOptions
extends RoleOptions {
    private final ImmutableList<String> toQueryParameters;
    private final ImmutableMap<String, String> toHeaders;
    @Nullable
    private final String policy;
    @Nullable
    private final String namespace;

    private ImmutableRoleOptions(ImmutableList<String> toQueryParameters, ImmutableMap<String, String> toHeaders, @Nullable String policy, @Nullable String namespace) {
        this.toQueryParameters = toQueryParameters;
        this.toHeaders = toHeaders;
        this.policy = policy;
        this.namespace = namespace;
    }

    public ImmutableList<String> toQueryParameters() {
        return this.toQueryParameters;
    }

    public ImmutableMap<String, String> toHeaders() {
        return this.toHeaders;
    }

    @Override
    public Optional<String> getPolicy() {
        return Optional.ofNullable(this.policy);
    }

    @Override
    public Optional<String> getNamespace() {
        return Optional.ofNullable(this.namespace);
    }

    public final ImmutableRoleOptions withToQueryParameters(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRoleOptions((ImmutableList<String>)newValue, this.toHeaders, this.policy, this.namespace);
    }

    public final ImmutableRoleOptions withToQueryParameters(Iterable<String> elements) {
        if (this.toQueryParameters == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRoleOptions((ImmutableList<String>)newValue, this.toHeaders, this.policy, this.namespace);
    }

    public final ImmutableRoleOptions withToHeaders(Map<String, ? extends String> entries) {
        if (this.toHeaders == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableRoleOptions(this.toQueryParameters, (ImmutableMap<String, String>)newValue, this.policy, this.namespace);
    }

    public final ImmutableRoleOptions withPolicy(String value) {
        String newValue = Objects.requireNonNull(value, "policy");
        if (Objects.equals(this.policy, newValue)) {
            return this;
        }
        return new ImmutableRoleOptions(this.toQueryParameters, this.toHeaders, newValue, this.namespace);
    }

    public final ImmutableRoleOptions withPolicy(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.policy, value)) {
            return this;
        }
        return new ImmutableRoleOptions(this.toQueryParameters, this.toHeaders, value, this.namespace);
    }

    public final ImmutableRoleOptions withNamespace(String value) {
        String newValue = Objects.requireNonNull(value, "namespace");
        if (Objects.equals(this.namespace, newValue)) {
            return this;
        }
        return new ImmutableRoleOptions(this.toQueryParameters, this.toHeaders, this.policy, newValue);
    }

    public final ImmutableRoleOptions withNamespace(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.namespace, value)) {
            return this;
        }
        return new ImmutableRoleOptions(this.toQueryParameters, this.toHeaders, this.policy, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRoleOptions && this.equalsByValue((ImmutableRoleOptions)another);
    }

    private boolean equalsByValue(ImmutableRoleOptions another) {
        return this.toQueryParameters.equals(another.toQueryParameters) && this.toHeaders.equals(another.toHeaders) && Objects.equals(this.policy, another.policy) && Objects.equals(this.namespace, another.namespace);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.toQueryParameters.hashCode();
        h += (h << 5) + this.toHeaders.hashCode();
        h += (h << 5) + Objects.hashCode(this.policy);
        h += (h << 5) + Objects.hashCode(this.namespace);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RoleOptions").omitNullValues().add("toQueryParameters", this.toQueryParameters).add("toHeaders", this.toHeaders).add("policy", (Object)this.policy).add("namespace", (Object)this.namespace).toString();
    }

    public static ImmutableRoleOptions copyOf(RoleOptions instance) {
        if (instance instanceof ImmutableRoleOptions) {
            return (ImmutableRoleOptions)instance;
        }
        return ImmutableRoleOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RoleOptions", generator="Immutables")
    public static final class Builder {
        private ImmutableList.Builder<String> toQueryParameters = ImmutableList.builder();
        private ImmutableMap.Builder<String, String> toHeaders = ImmutableMap.builder();
        @Nullable
        private String policy;
        @Nullable
        private String namespace;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ParamAdder instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RoleOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            ParamAdder instance;
            long bits = 0L;
            if (object instanceof ParamAdder) {
                instance = (ParamAdder)object;
                this.addAllToQueryParameters(instance.toQueryParameters());
                this.putAllToHeaders(instance.toHeaders());
            }
            if (object instanceof RoleOptions) {
                Optional<String> policyOptional;
                instance = (RoleOptions)object;
                Optional<String> namespaceOptional = ((RoleOptions)instance).getNamespace();
                if (namespaceOptional.isPresent()) {
                    this.namespace(namespaceOptional);
                }
                if ((policyOptional = ((RoleOptions)instance).getPolicy()).isPresent()) {
                    this.policy(policyOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String element) {
            this.toQueryParameters.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String ... elements) {
            this.toQueryParameters.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toQueryParameters(Iterable<String> elements) {
            this.toQueryParameters = ImmutableList.builder();
            return this.addAllToQueryParameters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllToQueryParameters(Iterable<String> elements) {
            this.toQueryParameters.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(String key, String value) {
            this.toHeaders.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(Map.Entry<String, ? extends String> entry) {
            this.toHeaders.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toHeaders(Map<String, ? extends String> entries) {
            this.toHeaders = ImmutableMap.builder();
            return this.putAllToHeaders(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllToHeaders(Map<String, ? extends String> entries) {
            this.toHeaders.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder policy(String policy) {
            this.policy = Objects.requireNonNull(policy, "policy");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder policy(Optional<String> policy) {
            this.policy = policy.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(String namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(Optional<String> namespace) {
            this.namespace = namespace.orElse(null);
            return this;
        }

        public ImmutableRoleOptions build() {
            return new ImmutableRoleOptions((ImmutableList<String>)this.toQueryParameters.build(), (ImmutableMap<String, String>)this.toHeaders.build(), this.policy, this.namespace);
        }
    }
}

