/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.util.failover.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.ThreadUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kiwiproject.consul.util.Lists;
import org.kiwiproject.consul.util.failover.strategy.ConsulFailoverStrategy;

public class RoundRobinConsulFailoverStrategy
implements ConsulFailoverStrategy {
    @VisibleForTesting
    final ThreadLocal<Integer> lastTargetIndexThreadLocal = ThreadLocal.withInitial(() -> -1);
    private final List<HostAndPort> targets;
    private final int numberOfTargets;
    private final Duration delay;
    private final boolean delayAfterFailedRequest;

    public RoundRobinConsulFailoverStrategy(List<HostAndPort> targets) {
        this(targets, Duration.ZERO);
    }

    public RoundRobinConsulFailoverStrategy(List<HostAndPort> targets, Duration delayAfterFailure) {
        Preconditions.checkArgument((boolean)Lists.isNotNullOrEmpty(targets), (Object)"targets must not be null or empty");
        this.targets = List.copyOf(targets);
        this.numberOfTargets = this.targets.size();
        Preconditions.checkArgument((boolean)Objects.nonNull(delayAfterFailure), (Object)"delayAfterFailure must not be null");
        long millis = delayAfterFailure.toMillis();
        Preconditions.checkArgument((millis >= 0L ? 1 : 0) != 0, (Object)"delayAfterFailure must be zero or a positive duration");
        this.delay = delayAfterFailure;
        this.delayAfterFailedRequest = millis > 0L;
    }

    @Override
    public @NonNull Optional<Request> computeNextStage(Request previousRequest) {
        return this.computeNextStage(previousRequest, null);
    }

    @Override
    public @NonNull Optional<Request> computeNextStage(@NonNull Request previousRequest, @Nullable Response previousResponse) {
        int nextIndex = this.lastTargetIndexThreadLocal.get() + 1;
        if (nextIndex >= this.numberOfTargets) {
            return Optional.empty();
        }
        if (nextIndex > 0) {
            this.sleepIfPositiveDelay();
        }
        HostAndPort nextTarget = this.targets.get(nextIndex);
        HttpUrl nextURL = previousRequest.url().newBuilder().host(nextTarget.getHost()).port(nextTarget.getPort()).build();
        return Optional.of(previousRequest.newBuilder().url(nextURL).build());
    }

    private void sleepIfPositiveDelay() {
        if (this.delayAfterFailedRequest) {
            ThreadUtils.sleepQuietly((Duration)this.delay);
        }
    }

    @Override
    public boolean isRequestViable(@NonNull Request request) {
        return true;
    }

    @Override
    public void markRequestFailed(@NonNull Request request) {
        this.lastTargetIndexThreadLocal.set(this.lastTargetIndexThreadLocal.get() + 1);
    }

    @Override
    public void reset() {
        this.lastTargetIndexThreadLocal.remove();
    }
}

