/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.kiwiproject.consul.BaseClient;
import org.kiwiproject.consul.async.Callback;
import org.kiwiproject.consul.async.ConsulResponseCallback;
import org.kiwiproject.consul.config.ClientConfig;
import org.kiwiproject.consul.model.ConsulResponse;
import org.kiwiproject.consul.monitoring.ClientEventCallback;
import org.kiwiproject.consul.option.QueryOptions;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.QueryMap;
import retrofit2.http.Streaming;

public class SnapshotClient
extends BaseClient {
    private static final String CLIENT_NAME = "snapshot";
    private final Api api;

    SnapshotClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = (Api)retrofit.create(Api.class);
    }

    public void save(final File destinationFile, QueryOptions queryOptions, final Callback<BigInteger> callback) {
        this.http.extractConsulResponse(this.api.generateSnapshot(queryOptions.toQuery()), new ConsulResponseCallback<ResponseBody>(){

            @Override
            public void onComplete(ConsulResponse<ResponseBody> consulResponse) {
                try (ResponseBody responseBody = consulResponse.getResponse();
                     InputStream inputStream = responseBody.byteStream();){
                    Files.copy(inputStream, destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    callback.onResponse(consulResponse.getIndex());
                }
                catch (IOException e) {
                    callback.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                callback.onFailure(t);
            }
        }, new Integer[0]);
    }

    public void restore(File sourceFile, QueryOptions queryOptions, Callback<Void> callback) {
        RequestBody requestBody = RequestBody.create((File)sourceFile, (MediaType)MediaType.parse((String)"application/binary"));
        this.http.extractBasicResponse(this.api.restoreSnapshot(queryOptions.toQuery(), requestBody), callback, new Integer[0]);
    }

    static interface Api {
        @Streaming
        @GET(value="snapshot")
        public Call<ResponseBody> generateSnapshot(@QueryMap Map<String, Object> var1);

        @PUT(value="snapshot")
        @Headers(value={"Content-Type: application/binary"})
        public Call<Void> restoreSnapshot(@QueryMap Map<String, Object> var1, @Body RequestBody var2);
    }
}

