/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.option;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.immutables.value.Value;
import org.kiwiproject.consul.option.ConsistencyMode;
import org.kiwiproject.consul.option.ImmutableQueryOptions;
import org.kiwiproject.consul.option.Options;
import org.kiwiproject.consul.option.ParamAdder;

@Value.Immutable
@Value.Style(jakarta=true)
public abstract class QueryOptions
implements ParamAdder {
    public static final QueryOptions BLANK = ImmutableQueryOptions.builder().build();

    public abstract Optional<String> getWait();

    public abstract Optional<String> getToken();

    public abstract Optional<String> getHash();

    public abstract Optional<BigInteger> getIndex();

    public abstract Optional<String> getNear();

    public abstract Optional<String> getDatacenter();

    public abstract Optional<String> getFilter();

    public abstract Optional<String> getNamespace();

    public abstract Optional<Boolean> getWan();

    public abstract Optional<String> getSegment();

    public abstract Optional<String> getNote();

    public abstract Optional<Boolean> getEnable();

    public abstract Optional<String> getReason();

    public abstract List<String> getNodeMeta();

    public abstract List<String> getTag();

    @Value.Default
    public ConsistencyMode getConsistencyMode() {
        return ConsistencyMode.DEFAULT;
    }

    @Value.Derived
    public boolean isBlocking() {
        return this.getWait().isPresent();
    }

    @Value.Derived
    public boolean hasToken() {
        return this.getToken().isPresent();
    }

    @Value.Derived
    public List<String> getNodeMetaQuery() {
        return List.copyOf(this.getNodeMeta());
    }

    @Value.Derived
    public List<String> getTagsQuery() {
        return List.copyOf(this.getTag());
    }

    @Value.Check
    void validate() {
        if (this.isBlocking()) {
            Preconditions.checkArgument((this.getIndex().isPresent() || this.getHash().isPresent() ? 1 : 0) != 0, (Object)"If wait is specified, index/hash must also be specified");
            Preconditions.checkArgument((!this.getIndex().isPresent() || !this.getHash().isPresent() ? 1 : 0) != 0, (Object)"Cannot specify index and hash ath the same time");
        }
    }

    public static ImmutableQueryOptions.Builder blockSeconds(int seconds, BigInteger index) {
        return QueryOptions.blockBuilder("s", seconds, index);
    }

    public static ImmutableQueryOptions.Builder blockMinutes(int minutes, BigInteger index) {
        return QueryOptions.blockBuilder("m", minutes, index);
    }

    private static ImmutableQueryOptions.Builder blockBuilder(String identifier, int qty, BigInteger index) {
        return ImmutableQueryOptions.builder().wait(String.format("%s%s", qty, identifier)).index(index);
    }

    public static ImmutableQueryOptions.Builder blockSeconds(int seconds, String hash) {
        return QueryOptions.blockBuilder("s", seconds, hash);
    }

    public static ImmutableQueryOptions.Builder blockMinutes(int minutes, String hash) {
        return QueryOptions.blockBuilder("m", minutes, hash);
    }

    private static ImmutableQueryOptions.Builder blockBuilder(String identifier, int qty, String hash) {
        return ImmutableQueryOptions.builder().wait(String.format("%s%s", qty, identifier)).hash(hash);
    }

    @Override
    public Map<String, Object> toQuery() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Optional<String> consistency = this.getConsistencyMode().toParam();
        consistency.ifPresent(s -> result.put((String)s, ""));
        if (this.isBlocking()) {
            Options.optionallyAdd(result, "wait", this.getWait());
            Options.optionallyAdd(result, "index", this.getIndex());
            Options.optionallyAdd(result, "hash", this.getHash());
        }
        Options.optionallyAdd(result, "token", this.getToken());
        Options.optionallyAdd(result, "near", this.getNear());
        Options.optionallyAdd(result, "dc", this.getDatacenter());
        Options.optionallyAdd(result, "filter", this.getFilter());
        Options.optionallyAdd(result, "ns", this.getNamespace());
        Options.optionallyAdd(result, "wan", this.getWan());
        Options.optionallyAdd(result, "segment", this.getSegment());
        Options.optionallyAdd(result, "note", this.getNote());
        Options.optionallyAdd(result, "enable", this.getEnable());
        Options.optionallyAdd(result, "reason", this.getReason());
        return result;
    }

    @Override
    public Map<String, String> toHeaders() {
        return this.getConsistencyMode().getAdditionalHeaders();
    }
}

