/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.option.DeleteOptions;
import org.kiwiproject.consul.option.ParamAdder;

@Generated(from="DeleteOptions", generator="Immutables")
public final class ImmutableDeleteOptions
extends DeleteOptions {
    private final ImmutableList<String> toQueryParameters;
    private final ImmutableMap<String, String> toHeaders;
    @Nullable
    private final Long cas;
    @Nullable
    private final Boolean recurse;
    @Nullable
    private final String datacenter;
    private final transient boolean isRecurse;

    private ImmutableDeleteOptions(ImmutableList<String> toQueryParameters, ImmutableMap<String, String> toHeaders, @Nullable Long cas, @Nullable Boolean recurse, @Nullable String datacenter) {
        this.toQueryParameters = toQueryParameters;
        this.toHeaders = toHeaders;
        this.cas = cas;
        this.recurse = recurse;
        this.datacenter = datacenter;
        this.isRecurse = super.isRecurse();
    }

    public ImmutableList<String> toQueryParameters() {
        return this.toQueryParameters;
    }

    public ImmutableMap<String, String> toHeaders() {
        return this.toHeaders;
    }

    @Override
    public Optional<Long> getCas() {
        return Optional.ofNullable(this.cas);
    }

    @Override
    public Optional<Boolean> getRecurse() {
        return Optional.ofNullable(this.recurse);
    }

    @Override
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    public boolean isRecurse() {
        return this.isRecurse;
    }

    public final ImmutableDeleteOptions withToQueryParameters(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDeleteOptions((ImmutableList<String>)newValue, this.toHeaders, this.cas, this.recurse, this.datacenter);
    }

    public final ImmutableDeleteOptions withToQueryParameters(Iterable<String> elements) {
        if (this.toQueryParameters == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDeleteOptions((ImmutableList<String>)newValue, this.toHeaders, this.cas, this.recurse, this.datacenter);
    }

    public final ImmutableDeleteOptions withToHeaders(Map<String, ? extends String> entries) {
        if (this.toHeaders == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableDeleteOptions(this.toQueryParameters, (ImmutableMap<String, String>)newValue, this.cas, this.recurse, this.datacenter);
    }

    public final ImmutableDeleteOptions withCas(long value) {
        Long newValue = value;
        if (Objects.equals(this.cas, newValue)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.toQueryParameters, this.toHeaders, newValue, this.recurse, this.datacenter);
    }

    public final ImmutableDeleteOptions withCas(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.cas, value)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.toQueryParameters, this.toHeaders, value, this.recurse, this.datacenter);
    }

    public final ImmutableDeleteOptions withRecurse(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.recurse, newValue)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.toQueryParameters, this.toHeaders, this.cas, newValue, this.datacenter);
    }

    public final ImmutableDeleteOptions withRecurse(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.recurse, value)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.toQueryParameters, this.toHeaders, this.cas, value, this.datacenter);
    }

    public final ImmutableDeleteOptions withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.toQueryParameters, this.toHeaders, this.cas, this.recurse, newValue);
    }

    public final ImmutableDeleteOptions withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.toQueryParameters, this.toHeaders, this.cas, this.recurse, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteOptions && this.equalTo(0, (ImmutableDeleteOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeleteOptions another) {
        return this.toQueryParameters.equals(another.toQueryParameters) && this.toHeaders.equals(another.toHeaders) && Objects.equals(this.cas, another.cas) && Objects.equals(this.recurse, another.recurse) && Objects.equals(this.datacenter, another.datacenter) && this.isRecurse == another.isRecurse;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.toQueryParameters.hashCode();
        h += (h << 5) + this.toHeaders.hashCode();
        h += (h << 5) + Objects.hashCode(this.cas);
        h += (h << 5) + Objects.hashCode(this.recurse);
        h += (h << 5) + Objects.hashCode(this.datacenter);
        h += (h << 5) + Booleans.hashCode((boolean)this.isRecurse);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DeleteOptions").omitNullValues().add("toQueryParameters", this.toQueryParameters).add("toHeaders", this.toHeaders).add("cas", (Object)this.cas).add("recurse", (Object)this.recurse).add("datacenter", (Object)this.datacenter).add("isRecurse", this.isRecurse).toString();
    }

    public static ImmutableDeleteOptions copyOf(DeleteOptions instance) {
        if (instance instanceof ImmutableDeleteOptions) {
            return (ImmutableDeleteOptions)instance;
        }
        return ImmutableDeleteOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeleteOptions", generator="Immutables")
    public static final class Builder {
        private ImmutableList.Builder<String> toQueryParameters = ImmutableList.builder();
        private ImmutableMap.Builder<String, String> toHeaders = ImmutableMap.builder();
        @Nullable
        private Long cas;
        @Nullable
        private Boolean recurse;
        @Nullable
        private String datacenter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ParamAdder instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DeleteOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ParamAdder instance;
            if (object instanceof ParamAdder) {
                instance = (ParamAdder)object;
                this.addAllToQueryParameters(instance.toQueryParameters());
                this.putAllToHeaders(instance.toHeaders());
            }
            if (object instanceof DeleteOptions) {
                Optional<Boolean> recurseOptional;
                Optional<String> datacenterOptional;
                instance = (DeleteOptions)object;
                Optional<Long> casOptional = ((DeleteOptions)instance).getCas();
                if (casOptional.isPresent()) {
                    this.cas(casOptional);
                }
                if ((datacenterOptional = ((DeleteOptions)instance).getDatacenter()).isPresent()) {
                    this.datacenter(datacenterOptional);
                }
                if ((recurseOptional = ((DeleteOptions)instance).getRecurse()).isPresent()) {
                    this.recurse(recurseOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String element) {
            this.toQueryParameters.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String ... elements) {
            this.toQueryParameters.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toQueryParameters(Iterable<String> elements) {
            this.toQueryParameters = ImmutableList.builder();
            return this.addAllToQueryParameters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllToQueryParameters(Iterable<String> elements) {
            this.toQueryParameters.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(String key, String value) {
            this.toHeaders.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(Map.Entry<String, ? extends String> entry) {
            this.toHeaders.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toHeaders(Map<String, ? extends String> entries) {
            this.toHeaders = ImmutableMap.builder();
            return this.putAllToHeaders(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllToHeaders(Map<String, ? extends String> entries) {
            this.toHeaders.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cas(long cas) {
            this.cas = cas;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cas(Optional<Long> cas) {
            this.cas = cas.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder recurse(boolean recurse) {
            this.recurse = recurse;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder recurse(Optional<Boolean> recurse) {
            this.recurse = recurse.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        public ImmutableDeleteOptions build() {
            return new ImmutableDeleteOptions((ImmutableList<String>)this.toQueryParameters.build(), (ImmutableMap<String, String>)this.toHeaders.build(), this.cas, this.recurse, this.datacenter);
        }
    }
}

