/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.option;

import java.util.Map;
import java.util.Optional;

public class ConsistencyMode {
    public static final ConsistencyMode DEFAULT = new ConsistencyMode("DEFAULT", 0, null);
    public static final ConsistencyMode STALE = new ConsistencyMode("STALE", 1, "stale");
    public static final ConsistencyMode CONSISTENT = new ConsistencyMode("CONSISTENT", 2, "consistent");
    private final String name;
    private final int ordinal;
    private final String param;
    private final Map<String, String> additionalHeaders;

    private ConsistencyMode(String name, int ordinal, String param) {
        this(name, ordinal, param, Map.of());
    }

    private ConsistencyMode(String name, int ordinal, String param, Map<String, String> headers) {
        this.name = name;
        this.ordinal = ordinal;
        this.param = param;
        this.additionalHeaders = headers;
    }

    public final Optional<String> toParam() {
        return Optional.ofNullable(this.param);
    }

    public final Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public static ConsistencyMode createCachedConsistencyWithMaxAgeAndStale(Optional<Long> maxAgeInSeconds, Optional<Long> maxStaleInSeconds) {
        long v;
        Object maxAge = "";
        if (maxAgeInSeconds.isPresent()) {
            v = maxAgeInSeconds.get();
            if (v < 0L) {
                throw new IllegalArgumentException("maxAgeInSeconds must greater or equal to 0");
            }
            maxAge = (String)maxAge + String.format("max-age=%d", v);
        }
        if (maxStaleInSeconds.isPresent()) {
            v = maxStaleInSeconds.get();
            if (v < 0L) {
                throw new IllegalArgumentException("maxStaleInSeconds must greater or equal to 0");
            }
            if (!((String)maxAge).isEmpty()) {
                maxAge = (String)maxAge + ",";
            }
            maxAge = (String)maxAge + String.format("stale-if-error=%d", v);
        }
        Map<Object, Object> headers = ((String)maxAge).isEmpty() ? Map.of() : Map.of("Cache-Control", maxAge);
        return new ConsistencyMode("CACHED", 3, "cached", headers);
    }

    public final String name() {
        return this.name;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(this.name());
        for (Map.Entry<String, String> entry : this.getAdditionalHeaders().entrySet()) {
            builder.append(String.format("[%s=%s]", entry.getKey(), entry.getValue()));
        }
        return builder.toString();
    }

    public int ordinal() {
        return this.ordinal;
    }

    public static ConsistencyMode[] values() {
        ConsistencyMode[] res = new ConsistencyMode[]{DEFAULT, STALE, CONSISTENT};
        return res;
    }
}

