/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.kiwiproject.consul.BaseClient;
import org.kiwiproject.consul.async.Callback;
import org.kiwiproject.consul.config.ClientConfig;
import org.kiwiproject.consul.model.query.PreparedQuery;
import org.kiwiproject.consul.model.query.QueryId;
import org.kiwiproject.consul.model.query.QueryResults;
import org.kiwiproject.consul.model.query.StoredQuery;
import org.kiwiproject.consul.monitoring.ClientEventCallback;
import org.kiwiproject.consul.option.QueryOptions;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public class PreparedQueryClient
extends BaseClient {
    private static final String CLIENT_NAME = "preparedquery";
    private final Api api;

    PreparedQueryClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = (Api)retrofit.create(Api.class);
    }

    public String createPreparedQuery(PreparedQuery preparedQuery) {
        return this.createPreparedQuery(preparedQuery, null);
    }

    public String createPreparedQuery(PreparedQuery preparedQuery, String dc) {
        return this.http.extract(this.api.createPreparedQuery(preparedQuery, this.dcQuery(dc)), new Integer[0]).getId();
    }

    private Map<String, String> dcQuery(String dc) {
        return Objects.nonNull(dc) ? Map.of("dc", dc) : Map.of();
    }

    public List<StoredQuery> getPreparedQueries() {
        return this.getPreparedQueries(null);
    }

    public List<StoredQuery> getPreparedQueries(String dc) {
        return this.http.extract(this.api.getPreparedQueries(this.dcQuery(dc)), new Integer[0]);
    }

    public Optional<StoredQuery> getPreparedQuery(String id) {
        return this.getPreparedQuery(id, null);
    }

    public Optional<StoredQuery> getPreparedQuery(String id, String dc) {
        List<StoredQuery> result = this.http.extract(this.api.getPreparedQuery(id, this.dcQuery(dc)), new Integer[0]);
        return result.isEmpty() ? Optional.empty() : Optional.of(result.get(0));
    }

    public QueryResults execute(String nameOrId) {
        return this.http.extract(this.api.execute(nameOrId, Map.of()), new Integer[0]);
    }

    public void execute(String nameOrId, QueryOptions options, Callback<QueryResults> callback) {
        this.http.extractBasicResponse(this.api.execute(nameOrId, options.toQuery()), callback, new Integer[0]);
    }

    public void deletePreparedQuery(String id) {
        this.deletePreparedQuery(id, null);
    }

    public void deletePreparedQuery(String id, String dc) {
        this.http.extract(this.api.deletePreparedQuery(id, this.dcQuery(dc)), new Integer[0]);
    }

    static interface Api {
        @GET(value="query")
        public Call<List<StoredQuery>> getPreparedQueries(@QueryMap Map<String, String> var1);

        @POST(value="query")
        public Call<QueryId> createPreparedQuery(@Body PreparedQuery var1, @QueryMap Map<String, String> var2);

        @GET(value="query/{id}")
        public Call<List<StoredQuery>> getPreparedQuery(@Path(value="id") String var1, @QueryMap Map<String, String> var2);

        @GET(value="query/{nameOrId}/execute")
        public Call<QueryResults> execute(@Path(value="nameOrId") String var1, @QueryMap Map<String, Object> var2);

        @DELETE(value="query/{id}")
        public Call<Void> deletePreparedQuery(@Path(value="id") String var1, @QueryMap Map<String, String> var2);
    }
}

