package org.kiwiproject.consul.model.operator;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RaftConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRaftConfiguration.builder()}.
 */
@Generated(from = "RaftConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableRaftConfiguration extends RaftConfiguration {
  private final ImmutableList<RaftServer> servers;
  private final BigInteger index;

  private ImmutableRaftConfiguration(
      ImmutableList<RaftServer> servers,
      BigInteger index) {
    this.servers = servers;
    this.index = index;
  }

  /**
   * @return The value of the {@code servers} attribute
   */
  @JsonProperty("Servers")
  @Override
  public ImmutableList<RaftServer> servers() {
    return servers;
  }

  /**
   * @return The value of the {@code index} attribute
   */
  @JsonProperty("Index")
  @Override
  public BigInteger index() {
    return index;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RaftConfiguration#servers() servers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRaftConfiguration withServers(RaftServer... elements) {
    ImmutableList<RaftServer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRaftConfiguration(newValue, this.index);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RaftConfiguration#servers() servers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of servers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRaftConfiguration withServers(Iterable<? extends RaftServer> elements) {
    if (this.servers == elements) return this;
    ImmutableList<RaftServer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRaftConfiguration(newValue, this.index);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RaftConfiguration#index() index} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for index
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRaftConfiguration withIndex(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "index");
    if (this.index.equals(newValue)) return this;
    return new ImmutableRaftConfiguration(this.servers, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRaftConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRaftConfiguration
        && equalTo(0, (ImmutableRaftConfiguration) another);
  }

  private boolean equalTo(int synthetic, ImmutableRaftConfiguration another) {
    return servers.equals(another.servers)
        && index.equals(another.index);
  }

  /**
   * Computes a hash code from attributes: {@code servers}, {@code index}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + servers.hashCode();
    h += (h << 5) + index.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RaftConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RaftConfiguration")
        .omitNullValues()
        .add("servers", servers)
        .add("index", index)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RaftConfiguration", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends RaftConfiguration {
    @Nullable List<RaftServer> servers = ImmutableList.of();
    @Nullable BigInteger index;
    @JsonProperty("Servers")
    public void setServers(List<RaftServer> servers) {
      this.servers = servers;
    }
    @JsonProperty("Index")
    public void setIndex(BigInteger index) {
      this.index = index;
    }
    @Override
    public List<RaftServer> servers() { throw new UnsupportedOperationException(); }
    @Override
    public BigInteger index() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRaftConfiguration fromJson(Json json) {
    ImmutableRaftConfiguration.Builder builder = ImmutableRaftConfiguration.builder();
    if (json.servers != null) {
      builder.addAllServers(json.servers);
    }
    if (json.index != null) {
      builder.index(json.index);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RaftConfiguration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RaftConfiguration instance
   */
  public static ImmutableRaftConfiguration copyOf(RaftConfiguration instance) {
    if (instance instanceof ImmutableRaftConfiguration) {
      return (ImmutableRaftConfiguration) instance;
    }
    return ImmutableRaftConfiguration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRaftConfiguration ImmutableRaftConfiguration}.
   * <pre>
   * ImmutableRaftConfiguration.builder()
   *    .addServers|addAllServers(org.kiwiproject.consul.model.operator.RaftServer) // {@link RaftConfiguration#servers() servers} elements
   *    .index(java.math.BigInteger) // required {@link RaftConfiguration#index() index}
   *    .build();
   * </pre>
   * @return A new ImmutableRaftConfiguration builder
   */
  public static ImmutableRaftConfiguration.Builder builder() {
    return new ImmutableRaftConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRaftConfiguration ImmutableRaftConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RaftConfiguration", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_INDEX = 0x1L;
    private long initBits = 0x1L;

    private ImmutableList.Builder<RaftServer> servers = ImmutableList.builder();
    private @Nullable BigInteger index;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RaftConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RaftConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      addAllServers(instance.servers());
      index(instance.index());
      return this;
    }

    /**
     * Adds one element to {@link RaftConfiguration#servers() servers} list.
     * @param element A servers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addServers(RaftServer element) {
      this.servers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link RaftConfiguration#servers() servers} list.
     * @param elements An array of servers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addServers(RaftServer... elements) {
      this.servers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link RaftConfiguration#servers() servers} list.
     * @param elements An iterable of servers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Servers")
    public final Builder servers(Iterable<? extends RaftServer> elements) {
      this.servers = ImmutableList.builder();
      return addAllServers(elements);
    }

    /**
     * Adds elements to {@link RaftConfiguration#servers() servers} list.
     * @param elements An iterable of servers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllServers(Iterable<? extends RaftServer> elements) {
      this.servers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link RaftConfiguration#index() index} attribute.
     * @param index The value for index 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Index")
    public final Builder index(BigInteger index) {
      this.index = Objects.requireNonNull(index, "index");
      initBits &= ~INIT_BIT_INDEX;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRaftConfiguration ImmutableRaftConfiguration}.
     * @return An immutable instance of RaftConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRaftConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRaftConfiguration(servers.build(), index);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_INDEX) != 0) attributes.add("index");
      return "Cannot build RaftConfiguration, some of required attributes are not set " + attributes;
    }
  }
}
