package org.kiwiproject.consul.model.health;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HealthCheck}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHealthCheck.builder()}.
 */
@Generated(from = "HealthCheck", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableHealthCheck extends HealthCheck {
  private final String node;
  private final String checkId;
  private final String name;
  private final String status;
  private final @Nullable String notes;
  private final @Nullable String output;
  private final @Nullable String serviceId;
  private final @Nullable String serviceName;
  private final ImmutableList<String> serviceTags;

  private ImmutableHealthCheck(
      String node,
      String checkId,
      String name,
      String status,
      @Nullable String notes,
      @Nullable String output,
      @Nullable String serviceId,
      @Nullable String serviceName,
      ImmutableList<String> serviceTags) {
    this.node = node;
    this.checkId = checkId;
    this.name = name;
    this.status = status;
    this.notes = notes;
    this.output = output;
    this.serviceId = serviceId;
    this.serviceName = serviceName;
    this.serviceTags = serviceTags;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public String getNode() {
    return node;
  }

  /**
   * @return The value of the {@code checkId} attribute
   */
  @JsonProperty("CheckID")
  @Override
  public String getCheckId() {
    return checkId;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("Status")
  @Override
  public String getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code notes} attribute
   */
  @JsonProperty("Notes")
  @Override
  public Optional<String> getNotes() {
    return Optional.ofNullable(notes);
  }

  /**
   * @return The value of the {@code output} attribute
   */
  @JsonProperty("Output")
  @Override
  public Optional<String> getOutput() {
    return Optional.ofNullable(output);
  }

  /**
   * @return The value of the {@code serviceId} attribute
   */
  @JsonProperty("ServiceID")
  @Override
  public Optional<String> getServiceId() {
    return Optional.ofNullable(serviceId);
  }

  /**
   * @return The value of the {@code serviceName} attribute
   */
  @JsonProperty("ServiceName")
  @Override
  public Optional<String> getServiceName() {
    return Optional.ofNullable(serviceName);
  }

  /**
   * @return The value of the {@code serviceTags} attribute
   */
  @JsonProperty("ServiceTags")
  @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
  @Override
  public ImmutableList<String> getServiceTags() {
    return serviceTags;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HealthCheck#getNode() node} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHealthCheck withNode(String value) {
    String newValue = Objects.requireNonNull(value, "node");
    if (this.node.equals(newValue)) return this;
    return new ImmutableHealthCheck(
        newValue,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName,
        this.serviceTags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HealthCheck#getCheckId() checkId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for checkId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHealthCheck withCheckId(String value) {
    String newValue = Objects.requireNonNull(value, "checkId");
    if (this.checkId.equals(newValue)) return this;
    return new ImmutableHealthCheck(
        this.node,
        newValue,
        this.name,
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName,
        this.serviceTags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HealthCheck#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHealthCheck withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        newValue,
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName,
        this.serviceTags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HealthCheck#getStatus() status} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHealthCheck withStatus(String value) {
    String newValue = Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        newValue,
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName,
        this.serviceTags);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HealthCheck#getNotes() notes} attribute.
   * @param value The value for notes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withNotes(String value) {
    String newValue = Objects.requireNonNull(value, "notes");
    if (Objects.equals(this.notes, newValue)) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        newValue,
        this.output,
        this.serviceId,
        this.serviceName,
        this.serviceTags);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HealthCheck#getNotes() notes} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for notes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withNotes(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.notes, value)) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        value,
        this.output,
        this.serviceId,
        this.serviceName,
        this.serviceTags);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HealthCheck#getOutput() output} attribute.
   * @param value The value for output
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withOutput(String value) {
    String newValue = Objects.requireNonNull(value, "output");
    if (Objects.equals(this.output, newValue)) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        newValue,
        this.serviceId,
        this.serviceName,
        this.serviceTags);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HealthCheck#getOutput() output} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for output
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withOutput(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.output, value)) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        value,
        this.serviceId,
        this.serviceName,
        this.serviceTags);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HealthCheck#getServiceId() serviceId} attribute.
   * @param value The value for serviceId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceId(String value) {
    String newValue = Objects.requireNonNull(value, "serviceId");
    if (Objects.equals(this.serviceId, newValue)) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        newValue,
        this.serviceName,
        this.serviceTags);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HealthCheck#getServiceId() serviceId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.serviceId, value)) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        value,
        this.serviceName,
        this.serviceTags);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HealthCheck#getServiceName() serviceName} attribute.
   * @param value The value for serviceName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceName(String value) {
    String newValue = Objects.requireNonNull(value, "serviceName");
    if (Objects.equals(this.serviceName, newValue)) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        newValue,
        this.serviceTags);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HealthCheck#getServiceName() serviceName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.serviceName, value)) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        value,
        this.serviceTags);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HealthCheck#getServiceTags() serviceTags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceTags(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HealthCheck#getServiceTags() serviceTags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of serviceTags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceTags(Iterable<String> elements) {
    if (this.serviceTags == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHealthCheck} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHealthCheck
        && equalTo(0, (ImmutableHealthCheck) another);
  }

  private boolean equalTo(int synthetic, ImmutableHealthCheck another) {
    return node.equals(another.node)
        && checkId.equals(another.checkId)
        && name.equals(another.name)
        && status.equals(another.status)
        && Objects.equals(notes, another.notes)
        && Objects.equals(output, another.output)
        && Objects.equals(serviceId, another.serviceId)
        && Objects.equals(serviceName, another.serviceName)
        && serviceTags.equals(another.serviceTags);
  }

  /**
   * Computes a hash code from attributes: {@code node}, {@code checkId}, {@code name}, {@code status}, {@code notes}, {@code output}, {@code serviceId}, {@code serviceName}, {@code serviceTags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + node.hashCode();
    h += (h << 5) + checkId.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + status.hashCode();
    h += (h << 5) + Objects.hashCode(notes);
    h += (h << 5) + Objects.hashCode(output);
    h += (h << 5) + Objects.hashCode(serviceId);
    h += (h << 5) + Objects.hashCode(serviceName);
    h += (h << 5) + serviceTags.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HealthCheck} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HealthCheck")
        .omitNullValues()
        .add("node", node)
        .add("checkId", checkId)
        .add("name", name)
        .add("status", status)
        .add("notes", notes)
        .add("output", output)
        .add("serviceId", serviceId)
        .add("serviceName", serviceName)
        .add("serviceTags", serviceTags)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "HealthCheck", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends HealthCheck {
    @Nullable String node;
    @Nullable String checkId;
    @Nullable String name;
    @Nullable String status;
    @Nullable Optional<String> notes = Optional.empty();
    @Nullable Optional<String> output = Optional.empty();
    @Nullable Optional<String> serviceId = Optional.empty();
    @Nullable Optional<String> serviceName = Optional.empty();
    @Nullable List<String> serviceTags = ImmutableList.of();
    @JsonProperty("Node")
    public void setNode(String node) {
      this.node = node;
    }
    @JsonProperty("CheckID")
    public void setCheckId(String checkId) {
      this.checkId = checkId;
    }
    @JsonProperty("Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("Status")
    public void setStatus(String status) {
      this.status = status;
    }
    @JsonProperty("Notes")
    public void setNotes(Optional<String> notes) {
      this.notes = notes;
    }
    @JsonProperty("Output")
    public void setOutput(Optional<String> output) {
      this.output = output;
    }
    @JsonProperty("ServiceID")
    public void setServiceId(Optional<String> serviceId) {
      this.serviceId = serviceId;
    }
    @JsonProperty("ServiceName")
    public void setServiceName(Optional<String> serviceName) {
      this.serviceName = serviceName;
    }
    @JsonProperty("ServiceTags")
    @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
    public void setServiceTags(List<String> serviceTags) {
      this.serviceTags = serviceTags;
    }
    @Override
    public String getNode() { throw new UnsupportedOperationException(); }
    @Override
    public String getCheckId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getStatus() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getNotes() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getOutput() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getServiceId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getServiceName() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getServiceTags() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableHealthCheck fromJson(Json json) {
    ImmutableHealthCheck.Builder builder = ImmutableHealthCheck.builder();
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.checkId != null) {
      builder.checkId(json.checkId);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.notes != null) {
      builder.notes(json.notes);
    }
    if (json.output != null) {
      builder.output(json.output);
    }
    if (json.serviceId != null) {
      builder.serviceId(json.serviceId);
    }
    if (json.serviceName != null) {
      builder.serviceName(json.serviceName);
    }
    if (json.serviceTags != null) {
      builder.addAllServiceTags(json.serviceTags);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link HealthCheck} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HealthCheck instance
   */
  public static ImmutableHealthCheck copyOf(HealthCheck instance) {
    if (instance instanceof ImmutableHealthCheck) {
      return (ImmutableHealthCheck) instance;
    }
    return ImmutableHealthCheck.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHealthCheck ImmutableHealthCheck}.
   * <pre>
   * ImmutableHealthCheck.builder()
   *    .node(String) // required {@link HealthCheck#getNode() node}
   *    .checkId(String) // required {@link HealthCheck#getCheckId() checkId}
   *    .name(String) // required {@link HealthCheck#getName() name}
   *    .status(String) // required {@link HealthCheck#getStatus() status}
   *    .notes(String) // optional {@link HealthCheck#getNotes() notes}
   *    .output(String) // optional {@link HealthCheck#getOutput() output}
   *    .serviceId(String) // optional {@link HealthCheck#getServiceId() serviceId}
   *    .serviceName(String) // optional {@link HealthCheck#getServiceName() serviceName}
   *    .addServiceTags|addAllServiceTags(String) // {@link HealthCheck#getServiceTags() serviceTags} elements
   *    .build();
   * </pre>
   * @return A new ImmutableHealthCheck builder
   */
  public static ImmutableHealthCheck.Builder builder() {
    return new ImmutableHealthCheck.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHealthCheck ImmutableHealthCheck}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HealthCheck", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private static final long INIT_BIT_CHECK_ID = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_STATUS = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String node;
    private @Nullable String checkId;
    private @Nullable String name;
    private @Nullable String status;
    private @Nullable String notes;
    private @Nullable String output;
    private @Nullable String serviceId;
    private @Nullable String serviceName;
    private ImmutableList.Builder<String> serviceTags = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HealthCheck} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HealthCheck instance) {
      Objects.requireNonNull(instance, "instance");
      node(instance.getNode());
      checkId(instance.getCheckId());
      name(instance.getName());
      status(instance.getStatus());
      Optional<String> notesOptional = instance.getNotes();
      if (notesOptional.isPresent()) {
        notes(notesOptional);
      }
      Optional<String> outputOptional = instance.getOutput();
      if (outputOptional.isPresent()) {
        output(outputOptional);
      }
      Optional<String> serviceIdOptional = instance.getServiceId();
      if (serviceIdOptional.isPresent()) {
        serviceId(serviceIdOptional);
      }
      Optional<String> serviceNameOptional = instance.getServiceName();
      if (serviceNameOptional.isPresent()) {
        serviceName(serviceNameOptional);
      }
      addAllServiceTags(instance.getServiceTags());
      return this;
    }

    /**
     * Initializes the value for the {@link HealthCheck#getNode() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Node")
    public final Builder node(String node) {
      this.node = Objects.requireNonNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link HealthCheck#getCheckId() checkId} attribute.
     * @param checkId The value for checkId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("CheckID")
    public final Builder checkId(String checkId) {
      this.checkId = Objects.requireNonNull(checkId, "checkId");
      initBits &= ~INIT_BIT_CHECK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link HealthCheck#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link HealthCheck#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Status")
    public final Builder status(String status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getNotes() notes} to notes.
     * @param notes The value for notes
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder notes(String notes) {
      this.notes = Objects.requireNonNull(notes, "notes");
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getNotes() notes} to notes.
     * @param notes The value for notes
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Notes")
    public final Builder notes(Optional<String> notes) {
      this.notes = notes.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getOutput() output} to output.
     * @param output The value for output
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder output(String output) {
      this.output = Objects.requireNonNull(output, "output");
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getOutput() output} to output.
     * @param output The value for output
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Output")
    public final Builder output(Optional<String> output) {
      this.output = output.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getServiceId() serviceId} to serviceId.
     * @param serviceId The value for serviceId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serviceId(String serviceId) {
      this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getServiceId() serviceId} to serviceId.
     * @param serviceId The value for serviceId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceID")
    public final Builder serviceId(Optional<String> serviceId) {
      this.serviceId = serviceId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getServiceName() serviceName} to serviceName.
     * @param serviceName The value for serviceName
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serviceName(String serviceName) {
      this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getServiceName() serviceName} to serviceName.
     * @param serviceName The value for serviceName
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceName")
    public final Builder serviceName(Optional<String> serviceName) {
      this.serviceName = serviceName.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link HealthCheck#getServiceTags() serviceTags} list.
     * @param element A serviceTags element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addServiceTags(String element) {
      this.serviceTags.add(element);
      return this;
    }

    /**
     * Adds elements to {@link HealthCheck#getServiceTags() serviceTags} list.
     * @param elements An array of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addServiceTags(String... elements) {
      this.serviceTags.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HealthCheck#getServiceTags() serviceTags} list.
     * @param elements An iterable of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceTags")
    @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
    public final Builder serviceTags(Iterable<String> elements) {
      this.serviceTags = ImmutableList.builder();
      return addAllServiceTags(elements);
    }

    /**
     * Adds elements to {@link HealthCheck#getServiceTags() serviceTags} list.
     * @param elements An iterable of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllServiceTags(Iterable<String> elements) {
      this.serviceTags.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableHealthCheck ImmutableHealthCheck}.
     * @return An immutable instance of HealthCheck
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHealthCheck build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHealthCheck(node, checkId, name, status, notes, output, serviceId, serviceName, serviceTags.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_CHECK_ID) != 0) attributes.add("checkId");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build HealthCheck, some of required attributes are not set " + attributes;
    }
  }
}
