package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Role.RoleServiceIdentity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRoleServiceIdentity.builder()}.
 */
@Generated(from = "Role.RoleServiceIdentity", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableRoleServiceIdentity
    extends Role.RoleServiceIdentity {
  private final String name;
  private final ImmutableList<String> datacenters;

  private ImmutableRoleServiceIdentity(String name, ImmutableList<String> datacenters) {
    this.name = name;
    this.datacenters = datacenters;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("ServiceName")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code datacenters} attribute
   */
  @JsonProperty("Datacenters")
  @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
  @Override
  public ImmutableList<String> datacenters() {
    return datacenters;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Role.RoleServiceIdentity#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRoleServiceIdentity withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableRoleServiceIdentity(newValue, this.datacenters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Role.RoleServiceIdentity#datacenters() datacenters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleServiceIdentity withDatacenters(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRoleServiceIdentity(this.name, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Role.RoleServiceIdentity#datacenters() datacenters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of datacenters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRoleServiceIdentity withDatacenters(Iterable<String> elements) {
    if (this.datacenters == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRoleServiceIdentity(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRoleServiceIdentity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRoleServiceIdentity
        && equalTo(0, (ImmutableRoleServiceIdentity) another);
  }

  private boolean equalTo(int synthetic, ImmutableRoleServiceIdentity another) {
    return name.equals(another.name)
        && datacenters.equals(another.datacenters);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code datacenters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + datacenters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RoleServiceIdentity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RoleServiceIdentity")
        .omitNullValues()
        .add("name", name)
        .add("datacenters", datacenters)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Role.RoleServiceIdentity", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Role.RoleServiceIdentity {
    @Nullable String name;
    @Nullable List<String> datacenters = ImmutableList.of();
    @JsonProperty("ServiceName")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("Datacenters")
    @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
    public void setDatacenters(List<String> datacenters) {
      this.datacenters = datacenters;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> datacenters() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRoleServiceIdentity fromJson(Json json) {
    ImmutableRoleServiceIdentity.Builder builder = ImmutableRoleServiceIdentity.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.datacenters != null) {
      builder.addAllDatacenters(json.datacenters);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Role.RoleServiceIdentity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RoleServiceIdentity instance
   */
  public static ImmutableRoleServiceIdentity copyOf(Role.RoleServiceIdentity instance) {
    if (instance instanceof ImmutableRoleServiceIdentity) {
      return (ImmutableRoleServiceIdentity) instance;
    }
    return ImmutableRoleServiceIdentity.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRoleServiceIdentity ImmutableRoleServiceIdentity}.
   * <pre>
   * ImmutableRoleServiceIdentity.builder()
   *    .name(String) // required {@link Role.RoleServiceIdentity#name() name}
   *    .addDatacenters|addAllDatacenters(String) // {@link Role.RoleServiceIdentity#datacenters() datacenters} elements
   *    .build();
   * </pre>
   * @return A new ImmutableRoleServiceIdentity builder
   */
  public static ImmutableRoleServiceIdentity.Builder builder() {
    return new ImmutableRoleServiceIdentity.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRoleServiceIdentity ImmutableRoleServiceIdentity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Role.RoleServiceIdentity", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private ImmutableList.Builder<String> datacenters = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RoleServiceIdentity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Role.RoleServiceIdentity instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      addAllDatacenters(instance.datacenters());
      return this;
    }

    /**
     * Initializes the value for the {@link Role.RoleServiceIdentity#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ServiceName")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link Role.RoleServiceIdentity#datacenters() datacenters} list.
     * @param element A datacenters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDatacenters(String element) {
      this.datacenters.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Role.RoleServiceIdentity#datacenters() datacenters} list.
     * @param elements An array of datacenters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDatacenters(String... elements) {
      this.datacenters.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Role.RoleServiceIdentity#datacenters() datacenters} list.
     * @param elements An iterable of datacenters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Datacenters")
    @JsonDeserialize(as = ImmutableList.class, contentAs = String.class)
    public final Builder datacenters(Iterable<String> elements) {
      this.datacenters = ImmutableList.builder();
      return addAllDatacenters(elements);
    }

    /**
     * Adds elements to {@link Role.RoleServiceIdentity#datacenters() datacenters} list.
     * @param elements An iterable of datacenters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllDatacenters(Iterable<String> elements) {
      this.datacenters.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRoleServiceIdentity ImmutableRoleServiceIdentity}.
     * @return An immutable instance of RoleServiceIdentity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRoleServiceIdentity build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRoleServiceIdentity(name, datacenters.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build RoleServiceIdentity, some of required attributes are not set " + attributes;
    }
  }
}
