/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.cache;

import com.google.common.primitives.Ints;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.kiwiproject.consul.HealthClient;
import org.kiwiproject.consul.async.ConsulResponseCallback;
import org.kiwiproject.consul.cache.CacheDescriptor;
import org.kiwiproject.consul.cache.ConsulCache;
import org.kiwiproject.consul.config.CacheConfig;
import org.kiwiproject.consul.model.State;
import org.kiwiproject.consul.model.health.HealthCheck;
import org.kiwiproject.consul.option.QueryOptions;

public class HealthCheckCache
extends ConsulCache<String, HealthCheck> {
    private HealthCheckCache(HealthClient healthClient, State checkState, int watchSeconds, QueryOptions queryOptions, Function<HealthCheck, String> keyExtractor, ConsulCache.Scheduler callbackScheduler) {
        super(keyExtractor, (BigInteger index, ConsulResponseCallback<List<V>> callback) -> {
            HealthCheckCache.checkWatch(healthClient.getNetworkTimeoutConfig().getClientReadTimeoutMillis(), watchSeconds);
            QueryOptions params = HealthCheckCache.watchParams(index, watchSeconds, queryOptions);
            healthClient.getChecksByState(checkState, params, callback);
        }, healthClient.getConfig().getCacheConfig(), healthClient.getEventHandler(), new CacheDescriptor("health.state", checkState.getName()), callbackScheduler);
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State checkState, int watchSeconds, QueryOptions queryOptions, Function<HealthCheck, String> keyExtractor, ScheduledExecutorService callbackExecutorService) {
        ConsulCache.Scheduler callbackScheduler = HealthCheckCache.createExternal(callbackExecutorService);
        return new HealthCheckCache(healthClient, checkState, watchSeconds, queryOptions, keyExtractor, callbackScheduler);
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State checkState, int watchSeconds, QueryOptions queryOptions, Function<HealthCheck, String> keyExtractor) {
        return new HealthCheckCache(healthClient, checkState, watchSeconds, queryOptions, keyExtractor, HealthCheckCache.createDefault());
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State checkState, int watchSeconds, QueryOptions queryOptions) {
        return HealthCheckCache.newCache(healthClient, checkState, watchSeconds, queryOptions, HealthCheck::getCheckId);
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State checkState, int watchSeconds) {
        return HealthCheckCache.newCache(healthClient, checkState, watchSeconds, QueryOptions.BLANK);
    }

    public static HealthCheckCache newCache(HealthClient healthClient, State checkState) {
        CacheConfig cacheConfig = healthClient.getConfig().getCacheConfig();
        int watchSeconds = Ints.checkedCast((long)cacheConfig.getWatchDuration().getSeconds());
        return HealthCheckCache.newCache(healthClient, checkState, watchSeconds);
    }
}

