/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerEventSupport {
    private static final Logger logger = LoggerFactory.getLogger(KieServerEventSupport.class);
    private static final ServiceLoader<KieServerEventListener> eventListenersLoader = ServiceLoader.load(KieServerEventListener.class);
    private List<KieServerEventListener> eventListeners = new ArrayList<KieServerEventListener>();

    public KieServerEventSupport() {
        eventListenersLoader.forEach(listener -> {
            this.eventListeners.add((KieServerEventListener)listener);
            logger.debug("Found kie server event listener {}", listener);
        });
    }

    public void fireBeforeServerStarted(KieServer kieServer) {
        Iterator<KieServerEventListener> iter = this.eventListeners.iterator();
        if (iter.hasNext()) {
            do {
                iter.next().beforeServerStarted(kieServer);
            } while (iter.hasNext());
        }
    }

    public void fireAfterServerStarted(KieServer kieServer) {
        Iterator<KieServerEventListener> iter = this.eventListeners.iterator();
        if (iter.hasNext()) {
            do {
                iter.next().afterServerStarted(kieServer);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeServerStopped(KieServer kieServer) {
        Iterator<KieServerEventListener> iter = this.eventListeners.iterator();
        if (iter.hasNext()) {
            do {
                iter.next().beforeServerStopped(kieServer);
            } while (iter.hasNext());
        }
    }

    public void fireAfterServerStopped(KieServer kieServer) {
        Iterator<KieServerEventListener> iter = this.eventListeners.iterator();
        if (iter.hasNext()) {
            do {
                iter.next().afterServerStopped(kieServer);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeContainerStarted(KieServer kieServer, KieContainerInstance containerInstance) {
        Iterator<KieServerEventListener> iter = this.eventListeners.iterator();
        if (iter.hasNext()) {
            do {
                iter.next().beforeContainerStarted(kieServer, containerInstance);
            } while (iter.hasNext());
        }
    }

    public void fireAfterContainerStarted(KieServer kieServer, KieContainerInstance containerInstance) {
        Iterator<KieServerEventListener> iter = this.eventListeners.iterator();
        if (iter.hasNext()) {
            do {
                iter.next().afterContainerStarted(kieServer, containerInstance);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeContainerStopped(KieServer kieServer, KieContainerInstance containerInstance) {
        Iterator<KieServerEventListener> iter = this.eventListeners.iterator();
        if (iter.hasNext()) {
            do {
                iter.next().beforeContainerStopped(kieServer, containerInstance);
            } while (iter.hasNext());
        }
    }

    public void fireAfterContainerStopped(KieServer kieServer, KieContainerInstance containerInstance) {
        Iterator<KieServerEventListener> iter = this.eventListeners.iterator();
        if (iter.hasNext()) {
            do {
                iter.next().afterContainerStopped(kieServer, containerInstance);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeContainerActivated(KieServer kieServer, KieContainerInstance containerInstance) {
        Iterator<KieServerEventListener> iter = this.eventListeners.iterator();
        if (iter.hasNext()) {
            do {
                iter.next().beforeContainerActivated(kieServer, containerInstance);
            } while (iter.hasNext());
        }
    }

    public void fireAfterContainerActivated(KieServer kieServer, KieContainerInstance containerInstance) {
        Iterator<KieServerEventListener> iter = this.eventListeners.iterator();
        if (iter.hasNext()) {
            do {
                iter.next().afterContainerActivated(kieServer, containerInstance);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeContainerDeactivated(KieServer kieServer, KieContainerInstance containerInstance) {
        Iterator<KieServerEventListener> iter = this.eventListeners.iterator();
        if (iter.hasNext()) {
            do {
                iter.next().beforeContainerDeactivated(kieServer, containerInstance);
            } while (iter.hasNext());
        }
    }

    public void fireAfterContainerDeactivated(KieServer kieServer, KieContainerInstance containerInstance) {
        Iterator<KieServerEventListener> iter = this.eventListeners.iterator();
        if (iter.hasNext()) {
            do {
                iter.next().afterContainerDeactivated(kieServer, containerInstance);
            } while (iter.hasNext());
        }
    }
}

