/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.integration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.kie.api.KieServices;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNResult;
import org.kie.internal.runtime.Cacheable;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.DMNServicesClient;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.RuleServicesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBusinessRuleTaskHandler
implements Cacheable,
WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(RemoteBusinessRuleTaskHandler.class);
    protected static final String DRL_LANG = "DRL";
    protected static final String DMN_LANG = "DMN";
    protected KieCommands commandsFactory = KieServices.get().getCommands();
    private KieServicesClient client;

    public RemoteBusinessRuleTaskHandler(String serverUrl, String userName, String password, ClassLoader classLoader) {
        serverUrl = System.getProperty(serverUrl, serverUrl);
        logger.debug("KieServerClient configured for server url(s) {} and username {}", (Object)serverUrl, (Object)userName);
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration(serverUrl, userName, password);
        configuration.setMarshallingFormat(MarshallingFormat.XSTREAM);
        this.client = KieServicesFactory.newKieServicesClient(configuration, classLoader);
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        HashMap parameters = new HashMap(workItem.getParameters());
        String containerId = (String)parameters.remove("ContainerId");
        if (containerId == null || containerId.isEmpty()) {
            throw new IllegalArgumentException("Container ID is required for remote BusinessRuleTask");
        }
        String language = (String)parameters.remove("Language");
        if (language == null) {
            language = DRL_LANG;
        }
        String kieSessionName = (String)parameters.remove("KieSessionName");
        parameters.remove("TaskName");
        parameters.remove("KieSessionType");
        HashMap<String, Object> results = new HashMap<String, Object>();
        logger.debug("Facts to be inserted into working memory {}", parameters);
        if (DRL_LANG.equalsIgnoreCase(language)) {
            RuleServicesClient ruleClient = this.client.getServicesClient(RuleServicesClient.class);
            ArrayList<Command> commands = new ArrayList<Command>();
            BatchExecutionCommand executionCommand = this.commandsFactory.newBatchExecution(commands, kieSessionName);
            for (Map.Entry entry : parameters.entrySet()) {
                String inputKey = workItem.getId() + "_" + (String)entry.getKey();
                commands.add(this.commandsFactory.newInsert(entry.getValue(), inputKey, true, null));
            }
            commands.add(this.commandsFactory.newFireAllRules("Fired"));
            ServiceResponse<ExecutionResults> reply = ruleClient.executeCommandsWithResults(containerId, (Command<?>)executionCommand);
            if (KieServiceResponse.ResponseType.FAILURE.equals((Object)reply.getType())) {
                throw new KieServicesException(reply.getMsg());
            }
            ExecutionResults executionResults = (ExecutionResults)reply.getResult();
            logger.debug("{} rules fired", executionResults.getValue("Fired"));
            for (Map.Entry entry : parameters.entrySet()) {
                String inputKey = workItem.getId() + "_" + (String)entry.getKey();
                String key = ((String)entry.getKey()).replaceAll(workItem.getId() + "_", "");
                results.put(key, executionResults.getValue(inputKey));
            }
        } else if (DMN_LANG.equalsIgnoreCase(language)) {
            String namespace = (String)parameters.remove("Namespace");
            String model = (String)parameters.remove("Model");
            String decision = (String)parameters.remove("Decision");
            DMNServicesClient dmnClient = this.client.getServicesClient(DMNServicesClient.class);
            DMNContext dmnContext = dmnClient.newContext();
            for (Map.Entry entry : parameters.entrySet()) {
                dmnContext.set((String)entry.getKey(), entry.getValue());
            }
            ServiceResponse<DMNResult> evaluationResult = null;
            evaluationResult = decision != null ? dmnClient.evaluateDecisionByName(containerId, namespace, model, decision, dmnContext) : dmnClient.evaluateAll(containerId, namespace, model, dmnContext);
            DMNResult dMNResult = (DMNResult)evaluationResult.getResult();
            results.putAll(dMNResult.getContext().getAll());
        } else {
            throw new IllegalArgumentException("Not supported language type " + language);
        }
        logger.debug("Facts retrieved from working memory {}", results);
        workItemManager.completeWorkItem(workItem.getId(), results);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
    }

    public void close() {
    }
}

