/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.manager;

import javax.persistence.EntityManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.task.api.UserInfo;
import org.kie.spring.persistence.KieSpringTransactionManagerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;

public class SpringRuntimeManagerFactoryImpl
extends RuntimeManagerFactoryImpl {
    private AbstractPlatformTransactionManager transactionManager;
    private UserGroupCallback userGroupCallback;
    private EntityManager entityManager;
    private UserInfo userInfo;
    private boolean pessimisticLocking = false;
    private GlobalSchedulerService schedulerService;
    private static final String TX_FACTORY_CLASS = "org.kie.txm.factory.class";
    private static final String SPRING_TX_FACTORY_CLASS = "org.kie.spring.persistence.KieSpringTransactionManagerFactory";
    private ApplicationContext applicationContext;

    public SpringRuntimeManagerFactoryImpl(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        System.setProperty(TX_FACTORY_CLASS, SPRING_TX_FACTORY_CLASS);
        TransactionManagerFactory.resetInstance();
        TransactionManagerFactory transactionManagerFactory = TransactionManagerFactory.get();
        if (transactionManagerFactory instanceof KieSpringTransactionManagerFactory) {
            ((KieSpringTransactionManagerFactory)transactionManagerFactory).setGlobalTransactionManager((AbstractPlatformTransactionManager)applicationContext.getBean(AbstractPlatformTransactionManager.class));
        }
    }

    public RuntimeManager newSingletonRuntimeManager(RuntimeEnvironment environment, String identifier) {
        this.adjustEnvironment(environment);
        return super.newSingletonRuntimeManager(environment, identifier);
    }

    public RuntimeManager newPerRequestRuntimeManager(RuntimeEnvironment environment, String identifier) {
        this.disallowSharedTaskService(environment);
        this.adjustEnvironment(environment);
        return super.newPerRequestRuntimeManager(environment, identifier);
    }

    public RuntimeManager newPerProcessInstanceRuntimeManager(RuntimeEnvironment environment, String identifier) {
        this.disallowSharedTaskService(environment);
        this.adjustEnvironment(environment);
        return super.newPerProcessInstanceRuntimeManager(environment, identifier);
    }

    public RuntimeManager newPerCaseRuntimeManager(RuntimeEnvironment environment, String identifier) {
        this.disallowSharedTaskService(environment);
        this.adjustEnvironment(environment);
        return super.newPerCaseRuntimeManager(environment, identifier);
    }

    public UserGroupCallback getUserGroupCallback() {
        return this.userGroupCallback;
    }

    public void setUserGroupCallback(UserGroupCallback userGroupCallback) {
        this.userGroupCallback = userGroupCallback;
    }

    public AbstractPlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(AbstractPlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public boolean isPessimisticLocking() {
        return this.pessimisticLocking;
    }

    public void setPessimisticLocking(boolean pessimisticLocking) {
        this.pessimisticLocking = pessimisticLocking;
    }

    public GlobalSchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public void setSchedulerService(GlobalSchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    protected void adjustEnvironment(RuntimeEnvironment environment) {
        TransactionManagerFactory transactionManagerFactory;
        if (this.userGroupCallback != null) {
            ((SimpleRuntimeEnvironment)environment).setUserGroupCallback(this.userGroupCallback);
        }
        if (this.schedulerService != null) {
            ((SimpleRuntimeEnvironment)environment).setSchedulerService(this.schedulerService);
        }
        ((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().set("org.kie.transaction.TransactionManager", (Object)this.transactionManager);
        ((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().set("org.kie.api.task.UserGroupCallback", (Object)this.userGroupCallback);
        ((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().set("org.kie.api.task.UserInfo", (Object)this.userInfo);
        if (this.entityManager != null) {
            ((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().set("org.kie.api.persistence.jpa.AppScopedEntityManager", (Object)this.entityManager);
            ((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().set("org.kie.api.persistence.jpa.CmdScopedEntityManager", (Object)this.entityManager);
            ((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().set("IS_JTA_TRANSACTION", (Object)false);
            ((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().set("IS_SHARED_ENTITY_MANAGER", (Object)true);
        }
        if (this.pessimisticLocking) {
            ((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        if ((transactionManagerFactory = TransactionManagerFactory.get()) instanceof KieSpringTransactionManagerFactory) {
            ((KieSpringTransactionManagerFactory)transactionManagerFactory).setGlobalTransactionManager(this.transactionManager);
        }
    }

    protected void disallowSharedTaskService(RuntimeEnvironment environment) {
        if (((SimpleRuntimeEnvironment)environment).getEnvironmentTemplate().get("org.kie.api.task.TaskService") != null) {
            throw new IllegalStateException("Per process instance and per request runtime manager do not support shared task service");
        }
    }
}

