/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.clustering.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.clustering.Cluster;
import org.dmg.pmml.clustering.ClusteringField;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.clustering.MissingValueWeights;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.builders.KiePMMLModelCodegenUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.clustering.compiler.factories.KiePMMLClusteringConversionUtils;
import org.kie.pmml.models.clustering.model.KiePMMLCluster;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringField;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringModel;
import org.kie.pmml.models.clustering.model.KiePMMLComparisonMeasure;
import org.kie.pmml.models.clustering.model.KiePMMLMissingValueWeights;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLClusteringModelFactory {
    static final String KIE_PMML_CLUSTERING_MODEL_TEMPLATE_JAVA = "KiePMMLClusteringModelTemplate.tmpl";
    static final String KIE_PMML_CLUSTERING_MODEL_TEMPLATE = "KiePMMLClusteringModelTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLClusteringModelFactory.class.getName());

    private KiePMMLClusteringModelFactory() {
    }

    public static KiePMMLClusteringModel getKiePMMLClusteringModel(CompilationDTO<ClusteringModel> compilationDTO) {
        logger.trace("getKiePMMLClusteringModel {}", compilationDTO);
        Map<String, String> sourcesMap = KiePMMLClusteringModelFactory.getKiePMMLClusteringModelSourcesMap(compilationDTO);
        try {
            Class clusteringModelClass = compilationDTO.compileAndLoadClass(sourcesMap);
            return (KiePMMLClusteringModel)clusteringModelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLClusteringModelSourcesMap(CompilationDTO<ClusteringModel> compilationDTO) {
        logger.trace("getKiePMMLClusteringModelSourcesMap {}", compilationDTO);
        String simpleClassName = compilationDTO.getSimpleClassName();
        CompilationUnit compilationUnit = JavaParserUtils.getKiePMMLModelCompilationUnit((String)simpleClassName, (String)compilationDTO.getPackageName(), (String)KIE_PMML_CLUSTERING_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_CLUSTERING_MODEL_TEMPLATE);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)compilationUnit.getClassByName(simpleClassName).orElseThrow(() -> new KiePMMLException("Main class not found: " + simpleClassName));
        KiePMMLClusteringModelFactory.setConstructor(compilationDTO, modelTemplate);
        HashMap<String, String> sourcesMap = new HashMap<String, String>();
        sourcesMap.put(JavaParserUtils.getFullClassName((CompilationUnit)compilationUnit), compilationUnit.toString());
        return sourcesMap;
    }

    static void setConstructor(CompilationDTO<ClusteringModel> compilationDTO, ClassOrInterfaceDeclaration modelTemplate) {
        KiePMMLModelCodegenUtils.init(compilationDTO, (ClassOrInterfaceDeclaration)modelTemplate);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        BlockStmt body = constructorDeclaration.getBody();
        ClusteringModel clusteringModel = (ClusteringModel)compilationDTO.getModel();
        body.addStatement((Expression)CommonCodegenUtils.assignExprFrom((String)"modelClass", (Enum)KiePMMLClusteringConversionUtils.modelClassFrom(clusteringModel.getModelClass())));
        clusteringModel.getClusters().stream().map(KiePMMLClusteringModelFactory::clusterCreationExprFrom).map(expr -> CommonCodegenUtils.methodCallExprFrom((String)"clusters", (String)"add", (Expression[])new Expression[]{expr})).forEach(arg_0 -> ((BlockStmt)body).addStatement(arg_0));
        clusteringModel.getClusteringFields().stream().map(KiePMMLClusteringModelFactory::clusteringFieldCreationExprFrom).map(expr -> CommonCodegenUtils.methodCallExprFrom((String)"clusteringFields", (String)"add", (Expression[])new Expression[]{expr})).forEach(arg_0 -> ((BlockStmt)body).addStatement(arg_0));
        body.addStatement((Expression)CommonCodegenUtils.assignExprFrom((String)"comparisonMeasure", (Expression)KiePMMLClusteringModelFactory.comparisonMeasureCreationExprFrom(clusteringModel.getComparisonMeasure())));
        if (clusteringModel.getMissingValueWeights() != null) {
            body.addStatement((Expression)CommonCodegenUtils.assignExprFrom((String)"missingValueWeights", (Expression)KiePMMLClusteringModelFactory.missingValueWeightsCreationExprFrom(clusteringModel.getMissingValueWeights())));
        }
    }

    private static ObjectCreationExpr clusterCreationExprFrom(Cluster cluster) {
        NodeList arguments = new NodeList();
        arguments.add((Node)CommonCodegenUtils.literalExprFrom((String)cluster.getId()));
        arguments.add((Node)CommonCodegenUtils.literalExprFrom((String)cluster.getName()));
        if (cluster.getArray() != null && cluster.getArray().getType() == Array.Type.REAL) {
            String arrayStringValue = (String)cluster.getArray().getValue();
            String[] arrayStringChunks = arrayStringValue.split(" ");
            try {
                Arrays.stream(arrayStringChunks).map(Double::parseDouble).map(DoubleLiteralExpr::new).forEach(arg_0 -> ((NodeList)arguments).add(arg_0));
            }
            catch (NumberFormatException e) {
                logger.error("Can't parse \"real\" cluster with value \"" + arrayStringValue + "\"", (Throwable)e);
            }
        }
        return new ObjectCreationExpr(null, new ClassOrInterfaceType(null, KiePMMLCluster.class.getCanonicalName()), arguments);
    }

    private static ObjectCreationExpr clusteringFieldCreationExprFrom(ClusteringField clusteringField) {
        double fieldWeight = clusteringField.getFieldWeight() == null ? 1.0 : clusteringField.getFieldWeight().doubleValue();
        boolean isCenterField = clusteringField.getCenterField() == null || clusteringField.getCenterField() == ClusteringField.CenterField.TRUE;
        NodeList arguments = new NodeList();
        arguments.add((Node)CommonCodegenUtils.literalExprFrom((String)clusteringField.getField().getValue()));
        arguments.add((Node)new DoubleLiteralExpr(fieldWeight));
        arguments.add((Node)new BooleanLiteralExpr(isCenterField));
        arguments.add((Node)(clusteringField.getCompareFunction() == null ? new NullLiteralExpr() : CommonCodegenUtils.literalExprFrom((Enum)KiePMMLClusteringConversionUtils.compareFunctionFrom(clusteringField.getCompareFunction()))));
        arguments.add((Node)new NullLiteralExpr());
        return new ObjectCreationExpr(null, new ClassOrInterfaceType(null, KiePMMLClusteringField.class.getCanonicalName()), arguments);
    }

    private static ObjectCreationExpr comparisonMeasureCreationExprFrom(ComparisonMeasure comparisonMeasure) {
        NodeList arguments = new NodeList();
        arguments.add((Node)CommonCodegenUtils.literalExprFrom((Enum)KiePMMLClusteringConversionUtils.comparisonMeasureKindFrom(comparisonMeasure.getKind())));
        arguments.add((Node)CommonCodegenUtils.literalExprFrom((Enum)KiePMMLClusteringConversionUtils.aggregateFunctionFrom(comparisonMeasure.getMeasure())));
        arguments.add((Node)CommonCodegenUtils.literalExprFrom((Enum)KiePMMLClusteringConversionUtils.compareFunctionFrom(comparisonMeasure.getCompareFunction())));
        return new ObjectCreationExpr(null, new ClassOrInterfaceType(null, KiePMMLComparisonMeasure.class.getCanonicalName()), arguments);
    }

    private static ObjectCreationExpr missingValueWeightsCreationExprFrom(MissingValueWeights missingValueWeights) {
        NodeList arguments = new NodeList();
        if (missingValueWeights.getArray() != null && missingValueWeights.getArray().getType() == Array.Type.REAL) {
            String arrayStringValue = (String)missingValueWeights.getArray().getValue();
            try {
                Arrays.stream(arrayStringValue.split(" ")).map(Double::parseDouble).map(DoubleLiteralExpr::new).forEach(arg_0 -> ((NodeList)arguments).add(arg_0));
            }
            catch (NumberFormatException e) {
                logger.error("Can't parse \"real\" missing value weights with value \"" + arrayStringValue + "\"", (Throwable)e);
            }
        }
        return new ObjectCreationExpr(null, new ClassOrInterfaceType(null, KiePMMLMissingValueWeights.class.getCanonicalName()), arguments);
    }
}

