/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasDataType;
import org.dmg.pmml.MiningField;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.MISSING_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLIntervalFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLMiningFieldFactory {
    static final String KIE_PMML_MININGFIELD_TEMPLATE_JAVA = "KiePMMLMiningFieldTemplate.tmpl";
    static final String KIE_PMML_MININGFIELD_TEMPLATE = "KiePMMLMiningFieldTemplate";
    static final String GETKIEPMMLMININGFIELD = "getKiePMMLMiningField";
    static final String MININGFIELD = "miningField";
    static final ClassOrInterfaceDeclaration MININGFIELD_TEMPLATE;

    private KiePMMLMiningFieldFactory() {
    }

    static BlockStmt getMiningFieldVariableDeclaration(String variableName, MiningField miningField, List<Field<?>> fields) {
        NullLiteralExpr invalidValueReplacementExpr;
        NullLiteralExpr missingValueReplacementExpr;
        NullLiteralExpr invalidValueTreatmentMethodExpr;
        NullLiteralExpr missingValueTreatmentMethodExpr;
        NullLiteralExpr opTypeExpr;
        NullLiteralExpr fieldUsageTypeExpr;
        MethodDeclaration methodDeclaration = ((MethodDeclaration)MININGFIELD_TEMPLATE.getMethodsByName(GETKIEPMMLMININGFIELD).get(0)).clone();
        BlockStmt miningFieldBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(miningFieldBody, MININGFIELD).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", MININGFIELD, miningFieldBody)));
        variableDeclarator.setName(variableName);
        BlockStmt toReturn = new BlockStmt();
        MethodCallExpr initializer = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", MININGFIELD, toReturn)))).asMethodCallExpr();
        MethodCallExpr builder = CommonCodegenUtils.getChainedMethodCallExprFrom("builder", initializer);
        StringLiteralExpr nameExpr = new StringLiteralExpr(miningField.getName().getValue());
        if (miningField.getUsageType() != null) {
            FIELD_USAGE_TYPE fieldUsageType = FIELD_USAGE_TYPE.byName((String)miningField.getUsageType().value());
            fieldUsageTypeExpr = new NameExpr(FIELD_USAGE_TYPE.class.getName() + "." + fieldUsageType.name());
        } else {
            fieldUsageTypeExpr = new NullLiteralExpr();
        }
        if (miningField.getOpType() != null) {
            OP_TYPE opType = OP_TYPE.byName((String)miningField.getOpType().value());
            opTypeExpr = new NameExpr(OP_TYPE.class.getName() + "." + opType.name());
        } else {
            opTypeExpr = new NullLiteralExpr();
        }
        List<Field<?>> mappedFields = KiePMMLMiningFieldFactory.getMappedFields(fields, miningField.getName().getValue());
        DataType dataType = KiePMMLMiningFieldFactory.getDataType(mappedFields, miningField.getName().getValue());
        DATA_TYPE data_TYPE = DATA_TYPE.byName((String)dataType.value());
        NameExpr dataTypeExpr = new NameExpr(DATA_TYPE.class.getName() + "." + data_TYPE.name());
        if (miningField.getMissingValueTreatment() != null) {
            MISSING_VALUE_TREATMENT_METHOD missingValueTreatmentMethod = MISSING_VALUE_TREATMENT_METHOD.byName((String)miningField.getMissingValueTreatment().value());
            missingValueTreatmentMethodExpr = new NameExpr(MISSING_VALUE_TREATMENT_METHOD.class.getName() + "." + missingValueTreatmentMethod.name());
        } else {
            missingValueTreatmentMethodExpr = new NullLiteralExpr();
        }
        if (miningField.getInvalidValueTreatment() != null) {
            INVALID_VALUE_TREATMENT_METHOD invalidValueTreatmentMethod = INVALID_VALUE_TREATMENT_METHOD.byName((String)miningField.getInvalidValueTreatment().value());
            invalidValueTreatmentMethodExpr = new NameExpr(INVALID_VALUE_TREATMENT_METHOD.class.getName() + "." + invalidValueTreatmentMethod.name());
        } else {
            invalidValueTreatmentMethodExpr = new NullLiteralExpr();
        }
        if (miningField.getMissingValueReplacement() != null) {
            String missingValueReplacement = miningField.getMissingValueReplacement().toString();
            missingValueReplacementExpr = new StringLiteralExpr(missingValueReplacement);
        } else {
            missingValueReplacementExpr = new NullLiteralExpr();
        }
        if (miningField.getInvalidValueReplacement() != null) {
            String invalidValueReplacement = miningField.getInvalidValueReplacement().toString();
            invalidValueReplacementExpr = new StringLiteralExpr(invalidValueReplacement);
        } else {
            invalidValueReplacementExpr = new NullLiteralExpr();
        }
        DataField dataField = KiePMMLMiningFieldFactory.getMappedDataField(mappedFields);
        NodeList allowedValuesExpressions = dataField != null ? KiePMMLMiningFieldFactory.getAllowedValuesExpressions(dataField) : new NodeList();
        NodeList intervalsExpressions = dataField != null ? KiePMMLMiningFieldFactory.getIntervalsExpressions(dataField) : new NodeList();
        builder.setArgument(0, (Expression)nameExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withFieldUsageType", initializer).setArgument(0, (Expression)fieldUsageTypeExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withOpType", initializer).setArgument(0, (Expression)opTypeExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withDataType", initializer).setArgument(0, (Expression)dataTypeExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withMissingValueTreatmentMethod", initializer).setArgument(0, (Expression)missingValueTreatmentMethodExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withInvalidValueTreatmentMethod", initializer).setArgument(0, (Expression)invalidValueTreatmentMethodExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withMissingValueReplacement", initializer).setArgument(0, (Expression)missingValueReplacementExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withInvalidValueReplacement", initializer).setArgument(0, (Expression)invalidValueReplacementExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withAllowedValues", initializer).getArgument(0).asMethodCallExpr().setArguments(allowedValuesExpressions);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withIntervals", initializer).getArgument(0).asMethodCallExpr().setArguments(intervalsExpressions);
        miningFieldBody.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    private static List<Field<?>> getMappedFields(List<Field<?>> fields, String fieldName) {
        return fields.stream().filter(fld -> Objects.equals(fieldName, fld.getName().getValue())).collect(Collectors.toList());
    }

    private static DataField getMappedDataField(List<Field<?>> fields) {
        return fields.stream().filter(DataField.class::isInstance).map(DataField.class::cast).findFirst().orElse(null);
    }

    private static DataType getDataType(List<Field<?>> fields, String fieldName) {
        return fields.stream().map(HasDataType::getDataType).findFirst().orElseThrow(() -> new KiePMMLInternalException(String.format("Failed to find DataType for field %s", fieldName)));
    }

    private static NodeList<Expression> getAllowedValuesExpressions(DataField dataField) {
        NodeList toReturn = new NodeList();
        if (dataField.hasValues()) {
            dataField.getValues().forEach(value -> toReturn.add((Node)new StringLiteralExpr(value.getValue().toString())));
        }
        return toReturn;
    }

    private static NodeList<Expression> getIntervalsExpressions(DataField dataField) {
        NodeList toReturn = new NodeList();
        if (dataField.hasIntervals()) {
            dataField.getIntervals().forEach(interval -> {
                BlockStmt intervalStmt = KiePMMLIntervalFactory.getIntervalVariableDeclaration("name", interval);
                Expression toAdd = (Expression)intervalStmt.getStatement(0).asExpressionStmt().getExpression().asVariableDeclarationExpr().getVariable(0).getInitializer().orElseThrow(() -> new KiePMMLInternalException(String.format("Failed to create initializer for Interval %s", interval)));
                toReturn.add((Node)toAdd);
            });
        }
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_MININGFIELD_TEMPLATE_JAVA);
        MININGFIELD_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_MININGFIELD_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLMiningFieldTemplate"));
        ((MethodDeclaration)MININGFIELD_TEMPLATE.getMethodsByName(GETKIEPMMLMININGFIELD).get(0)).clone();
    }
}

